/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.georss;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.geometry.JGeometry;
import org.w3c.dom.Node;

public class GMLParser {
    public static JGeometry getGeometry(Node node) {
        String nodeName = node.getNodeName();
        if ("gml:point".equals(nodeName = nodeName.toLowerCase(Locale.ENGLISH))) {
            return GMLParser.getPoint(node);
        }
        if ("gml:linestring".equals(nodeName) || "gml:curve".equals(nodeName)) {
            return GMLParser.getLineString(node);
        }
        if ("gml:polygon".equals(nodeName)) {
            return GMLParser.getPolygon(node);
        }
        if ("gml:envelope".equals(nodeName)) {
            return GMLParser.getBox(node);
        }
        return null;
    }

    public static JGeometry getPoint(Node node) {
        Node pos = XMLDOMParser.getSubElement(node, "gml:pos");
        if (pos == null) {
            return null;
        }
        String v = XMLDOMParser.getElementValue(pos);
        ArrayList l = Util.splitBy(v, " ");
        double[] xy = new double[2];
        xy[1] = Double.parseDouble((String)l.get(0));
        xy[0] = Double.parseDouble((String)l.get(1));
        return JSDOGeometry.createPoint((double[])xy, (int)2, (int)8307);
    }

    public static JGeometry getLineString(Node node) {
        Node pos = XMLDOMParser.getSubElement(node, "gml:posList");
        if (pos == null) {
            return null;
        }
        String v = XMLDOMParser.getElementValue(pos);
        ArrayList l = Util.splitBy(v, " ");
        double[] coords = new double[l.size()];
        for (int i = 0; i < l.size() / 2; ++i) {
            coords[i * 2] = Double.parseDouble((String)l.get(i * 2 + 1));
            coords[i * 2 + 1] = Double.parseDouble((String)l.get(i * 2));
        }
        return JSDOGeometry.createLinearLineString((double[])coords, (int)2, (int)8307);
    }

    public static JGeometry getBox(Node node) {
        Node lc = XMLDOMParser.getSubElement(node, "gml:lowerCorner");
        if (lc == null) {
            return null;
        }
        String v = XMLDOMParser.getElementValue(lc);
        ArrayList l = Util.splitBy(v, " ");
        double[] xyLC = new double[2];
        xyLC[1] = Double.parseDouble((String)l.get(0));
        xyLC[0] = Double.parseDouble((String)l.get(1));
        Node uc = XMLDOMParser.getSubElement(node, "gml:upperCorner");
        if (uc == null) {
            return null;
        }
        v = XMLDOMParser.getElementValue(lc);
        l = Util.splitBy(v, " ");
        double[] xyUC = new double[2];
        xyUC[1] = Double.parseDouble((String)l.get(0));
        xyUC[0] = Double.parseDouble((String)l.get(1));
        return new JGeometry(Math.min(xyLC[0], xyUC[0]), Math.min(xyLC[1], xyUC[1]), Math.max(xyLC[0], xyUC[0]), Math.max(xyLC[1], xyUC[1]), 8307);
    }

    public static JGeometry getPolygon(Node node) {
        double[] coordsExt = GMLParser.getPolygonExterior(node);
        List innerRings = GMLParser.getPolygonInterior(node);
        Object[] res = new Object[innerRings.size() + 1];
        res[0] = coordsExt;
        for (int i = 0; i < innerRings.size(); ++i) {
            res[i + 1] = (double[])innerRings.get(i);
        }
        return JSDOGeometry.createLinearPolygon((Object[])res, (int)2, (int)8307);
    }

    private static double[] getPolygonExterior(Node node) {
        Node ext = XMLDOMParser.getSubElement(node, "gml:exterior");
        if (ext == null) {
            return null;
        }
        Node lr = XMLDOMParser.getSubElement(ext, "gml:LinearRing");
        if (lr == null) {
            return null;
        }
        Node pos = XMLDOMParser.getSubElement(lr, "gml:posList");
        if (pos == null) {
            return null;
        }
        String v = XMLDOMParser.getElementValue(pos);
        ArrayList l = Util.splitBy(v, " ");
        double[] coords = new double[l.size()];
        for (int i = 0; i < l.size() / 2; ++i) {
            coords[i * 2] = Double.parseDouble((String)l.get(i * 2 + 1));
            coords[i * 2 + 1] = Double.parseDouble((String)l.get(i * 2));
        }
        return coords;
    }

    private static List getPolygonInterior(Node node) {
        ArrayList nl = XMLDOMParser.getSubElements(node, "gml:interior");
        if (nl == null || nl.size() == 0) {
            return new ArrayList(1);
        }
        ArrayList<double[]> res = new ArrayList<double[]>(2);
        for (int k = 0; k < nl.size(); ++k) {
            Node pos;
            Node in = (Node)nl.get(k);
            Node lr = XMLDOMParser.getSubElement(in, "gml:LinearRing");
            if (lr == null || (pos = XMLDOMParser.getSubElement(lr, "gml:posList")) == null) continue;
            String v = XMLDOMParser.getElementValue(pos);
            ArrayList l = Util.splitBy(v, " ");
            double[] coords = new double[l.size()];
            for (int i = 0; i < l.size() / 2; ++i) {
                coords[i * 2] = Double.parseDouble((String)l.get(i * 2 + 1));
                coords[i * 2 + 1] = Double.parseDouble((String)l.get(i * 2));
            }
            res.add(coords);
        }
        return res;
    }
}

