/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.edit.session.layer;

import java.util.ArrayList;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopoFeatureDescriptor;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;
import oracle.sdovis.edit.session.layer.EditSessionLayer;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;

public class TopologyFeatureEditSessionLayer
extends EditSessionLayer {
    public TopologyFeatureEditSessionLayer(String name) {
        this.name = name;
    }

    @Override
    public String getSpatialType() {
        return EditSessionLayer.TOPOFEATURE_TYPE;
    }

    @Override
    public boolean allowDataLoad() {
        return true;
    }

    @Override
    public Object parseElement(Node parentNode) throws Exception {
        ArrayList nodes;
        Node childsNode;
        ArrayList nodes2;
        Node tpNode;
        String value;
        Node tyNode;
        String value2;
        Node lyNode;
        String value3;
        if (parentNode == null) {
            throw new Exception("Input node value is null.");
        }
        Node valueNode = parentNode.getFirstChild();
        String nodeName = valueNode.getNodeName();
        if (nodeName == null) {
            throw new Exception("Node name is null.");
        }
        if (!nodeName.equalsIgnoreCase("topo_geometry")) {
            throw new Exception("Invalid child node name. Must be topo_geometry.");
        }
        TopoFeatureDescriptor tpf = new TopoFeatureDescriptor();
        Node idNode = XMLDOMParser.getSubElement(valueNode, "tg_id");
        if (idNode != null && (value3 = XMLDOMParser.getElementValue(idNode)) != null) {
            try {
                tpf.setFeatureId(Integer.parseInt(value3));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((lyNode = XMLDOMParser.getSubElement(valueNode, "tg_layer_id")) != null && (value2 = XMLDOMParser.getElementValue(lyNode)) != null) {
            try {
                tpf.setLayerId(Integer.parseInt(value2));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((tyNode = XMLDOMParser.getSubElement(valueNode, "tg_type")) != null && (value = XMLDOMParser.getElementValue(tyNode)) != null) {
            try {
                tpf.setTopoFeatureType(Integer.parseInt(value));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((tpNode = XMLDOMParser.getSubElement(valueNode, "topology")) != null) {
            tpf.setTopology(XMLDOMParser.getElementValue(tpNode));
        } else {
            tpf.setTopology(this.getParameterValue("topology"));
        }
        Node ftNode = XMLDOMParser.getSubElement(valueNode, "feature_table");
        if (ftNode != null) {
            tpf.setFeatureTable(XMLDOMParser.getElementValue(ftNode));
        } else {
            tpf.setFeatureTable(this.baseTable);
        }
        Node tcNode = XMLDOMParser.getSubElement(valueNode, "topo_column");
        if (tcNode != null) {
            tpf.setTopoColumn(XMLDOMParser.getElementValue(tcNode));
        } else {
            tpf.setTopoColumn(this.spatialColumn);
        }
        Node primsNode = XMLDOMParser.getSubElement(valueNode, "topo_primitives");
        if (primsNode != null && (nodes2 = XMLDOMParser.getSubElements(primsNode, "topo_primitive")) != null && nodes2.size() > 0) {
            for (int i = 0; i < nodes2.size(); ++i) {
                Node nd = (Node)nodes2.get(i);
                String topo_id = XMLDOMParser.getAttribute(nd, "topo_id");
                String topo_type = XMLDOMParser.getAttribute(nd, "topo_type");
                try {
                    int id = Integer.parseInt(topo_id);
                    int type = Integer.parseInt(topo_type);
                    TopoPrimitiveDescriptor tpd = new TopoPrimitiveDescriptor(id, type);
                    tpf.addPrimitive(tpd);
                    continue;
                }
                catch (Exception ex) {
                    throw new Exception("Invalid topo primitive value [" + topo_id + "," + topo_type + "]. " + ex.getMessage());
                }
            }
        }
        if ((childsNode = XMLDOMParser.getSubElement(valueNode, "child_features")) != null && (nodes = XMLDOMParser.getSubElements(childsNode, "child_feature")) != null && nodes.size() > 0) {
            for (int i = 0; i < nodes.size(); ++i) {
                Node nd = (Node)nodes.get(i);
                String layer_id = XMLDOMParser.getAttribute(nd, "layer_id");
                String feature_id = XMLDOMParser.getAttribute(nd, "feature_id");
                try {
                    int layerid = Integer.parseInt(layer_id);
                    int featid = Integer.parseInt(feature_id);
                    TopoChildFeatureDescriptor tcfd = new TopoChildFeatureDescriptor(layerid, featid);
                    tpf.addChildFeature(tcfd);
                    continue;
                }
                catch (Exception ex) {
                    throw new Exception("Invalid topo child feature value [" + layer_id + "," + feature_id + "]. " + ex.getMessage());
                }
            }
        }
        return tpf;
    }

    @Override
    public boolean allowGetConflicts() {
        return true;
    }

    @Override
    public boolean isMyObjectType(Object obj) {
        return obj instanceof TopoFeatureDescriptor;
    }

    @Override
    public String object2String(Object obj) {
        return ((TopoFeatureDescriptor)obj).toXML();
    }

    @Override
    public Object loadFromDB(Object obj) {
        return null;
    }
}

