/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BasemapCache;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyleCache;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.TileLayerCache;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.edit.session.EditSessionCache;
import oracle.sdovis.util.UserIdentity;

public abstract class AbstractDBDataSource
implements DBDataSource {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String name;
    protected boolean closed;
    protected boolean pre9i;
    protected boolean tenG;
    protected boolean is9i;
    protected String dbProductVersion;
    protected StyleCache styleCache;
    protected ThemeCache themeCache;
    protected BasemapCache basemapCache;
    protected TileLayerCache tilelayerCache;
    protected EditSessionCache editsessionCache;
    protected SRSCache srsCache;
    protected Hashtable ownerTableSrid = new Hashtable();
    protected String userInfoPackageName;
    protected boolean userIfnoPackageValid = false;
    protected boolean useProxySession = false;
    protected String proxyType = null;
    protected String authenticatedUserType = UserIdentity.J2EE_USER;
    protected boolean jdbcThemeAllowed = false;
    protected String tempDir = null;
    protected boolean isEditable = false;

    @Override
    public abstract Connection getConnection() throws SQLException;

    @Override
    public abstract Connection getConnection(String var1, String var2) throws SQLException;

    @Override
    public boolean isPre9i() {
        return this.pre9i;
    }

    @Override
    public boolean is9i() {
        return this.is9i;
    }

    @Override
    public boolean is10g() {
        return this.tenG;
    }

    public abstract boolean supportOLS();

    @Override
    public abstract DataSource getUnwrappedDataSource();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract void close();

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public StyleCache getStyleCache() {
        return this.styleCache;
    }

    @Override
    public ThemeCache getThemeCache() {
        return this.themeCache;
    }

    @Override
    public BasemapCache getBasemapCache() {
        return this.basemapCache;
    }

    @Override
    public TileLayerCache getTileLayerCache() {
        return this.tilelayerCache;
    }

    @Override
    public EditSessionCache getEditSessionCache() {
        return this.editsessionCache;
    }

    @Override
    public SRSCache getSRSCache() {
        return this.srsCache;
    }

    public void setStyleCache(StyleCache sc) {
        this.styleCache = sc;
    }

    public void setThemeCache(ThemeCache dc) {
        this.themeCache = dc;
    }

    public void setBasemapCache(BasemapCache mc) {
        this.basemapCache = mc;
    }

    public void setTileLayerCache(TileLayerCache tc) {
        this.tilelayerCache = tc;
    }

    public void setEditSessionCache(EditSessionCache ec) {
        this.editsessionCache = ec;
    }

    public void setSRSCache(SRSCache sc) {
        this.srsCache = sc;
    }

    public Hashtable getOwnerTableSridCache() {
        return this.ownerTableSrid;
    }

    public void setDbProductVersion(String dbProductVersion) {
        this.dbProductVersion = dbProductVersion;
    }

    public String getDbProductVersion() {
        return this.dbProductVersion;
    }

    public void setUserIfnoPackageValid(boolean param) {
        this.userIfnoPackageValid = param;
    }

    @Override
    public boolean isUserIfnoPackageValid() {
        return this.userIfnoPackageValid;
    }

    public abstract String getUser();

    @Override
    public boolean useProxySession() {
        return this.useProxySession;
    }

    @Override
    public String getProxyType() {
        return this.proxyType;
    }

    @Override
    public void setUseProxySession(boolean v) {
        this.useProxySession = v;
    }

    @Override
    public void setProxyType(String type) {
        if ("USER_NAME".equalsIgnoreCase(type)) {
            this.proxyType = "USER_NAME";
        } else if ("DISTINGUISED_NAME".equalsIgnoreCase(type)) {
            this.proxyType = "DISTINGUISED_NAME";
        } else {
            throw new IllegalArgumentException("Invalid proxy type specified.");
        }
    }

    @Override
    public void setWebUserType(String type) {
        this.authenticatedUserType = type;
    }

    @Override
    public String getWebUserType() {
        return this.authenticatedUserType;
    }

    @Override
    public String getTemporaryDirectory() {
        return this.tempDir;
    }

    @Override
    public void setTemporaryDirectory(String dir) {
        this.tempDir = dir;
    }

    @Override
    public String getOwner() {
        return this.getUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getMetaDataDefinition(String name, int type) {
        Connection c = null;
        try {
            HashMap res;
            c = this.getConnection();
            HashMap hashMap = res = DSUtil.getMetaDataDefinition(c, name, type);
            return hashMap;
        }
        catch (SQLException e) {
            log.warning("Cannot get meta data definition for " + name + ". " + e.getMessage());
            HashMap hashMap = null;
            return hashMap;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public HashMap storeMetaDataDefinition(String name, int type, HashMap data) {
        return null;
    }

    @Override
    public HashMap deleteMetaData(String name, int type) {
        return null;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setIsEditable(boolean v) {
        this.isEditable = v;
    }

    @Override
    public boolean isJDBCThemeAllowed() {
        return this.jdbcThemeAllowed;
    }

    @Override
    public void setJDBCThemeAllowed(boolean v) {
        this.jdbcThemeAllowed = v;
    }
}

