/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import oracle.sdovis.JSDOGeometry;

public class Unpickle81 {
    static short KOPI20_LN_ELNL = (short)255;
    static short KOPI20_LN_5BLN = (short)254;
    static short KOPI20_LN_ATMN = (short)253;
    static short KOPI20_LN_IEMN = (short)252;
    static short KOPI20_LN_MAXV = (short)245;
    static short KOPI20_IF_IS81 = (short)128;
    static short KOPI20_IF_CMSB = (short)64;
    static short KOPI20_IF_CLSB = (short)32;
    static short KOPI20_IF_DEGN = (short)16;
    static short KOPI20_IF_COLL = (short)8;
    static short KOPI20_IF_NOPS = (short)4;
    static short KOPI20_IF_ANY = (short)2;
    static short KOPI20_IF_NONL = 1;
    static short KOPI20_CF_CMSB = (short)64;
    static short KOPI20_CF_CLSB = (short)32;
    static short KOPI20_CF_INDX = (short)16;
    static short KOPI20_CF_NOLN = (short)8;
    static short KOPI20_VERSION = 1;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;
    private static boolean DEBUG = false;
    private static final double[] RD100 = new double[]{0.01, 1.0E-4, 1.0E-6, 1.0E-8, 1.0E-10, 1.0E-12, 1.0E-14, 1.0E-16, 1.0E-18, 1.0E-20, 1.0E-22, 1.0E-24, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

    public static final JSDOGeometry unpickle(byte[] image) throws Exception {
        if (image == null || image.length < 7) {
            throw new Exception("invalid geometry image");
        }
        UnpickleHelper helper = new UnpickleHelper(image);
        helper.checkImageHeader();
        helper.skipLength();
        helper.checkPrefix();
        if (DEBUG) {
            System.out.println("offset = " + helper.offset);
        }
        int gType = Unpickle81.getInt(helper);
        if (DEBUG) {
            System.out.println("get gType: " + gType);
        }
        int srid = Unpickle81.getInt(helper);
        if (DEBUG) {
            System.out.println("get srid: " + srid);
        }
        boolean hasLabelPoint = false;
        double x = Double.NaN;
        double y = Double.NaN;
        double z = Double.NaN;
        if (image[helper.offset] < -1) {
            hasLabelPoint = false;
            ++helper.offset;
        } else {
            hasLabelPoint = true;
            x = Unpickle81.getDouble(helper);
            y = Unpickle81.getDouble(helper);
            z = Unpickle81.getDouble(helper);
            if (Double.isNaN(x) || Double.isNaN(y)) {
                x = Double.NaN;
                y = Double.NaN;
            }
        }
        int[] elemInfo = Unpickle81.getElemInfoArray(helper);
        double[] coords = Unpickle81.getOrdinates(helper);
        if (coords != null && elemInfo != null) {
            boolean flag = JSDOGeometry.nonOracleETypeExists(elemInfo);
            if (!flag) {
                return new JSDOGeometry(gType, srid, x, y, z, elemInfo, coords);
            }
            return JSDOGeometry.removeEType0(gType, srid, x, y, z, elemInfo, coords);
        }
        if (!Double.isNaN(x) && !Double.isNaN(y)) {
            if (!Double.isNaN(z)) {
                return new JSDOGeometry(x, y, z, srid);
            }
            return new JSDOGeometry(x, y, srid);
        }
        if (DEBUG) {
            System.out.println("cannot unpickle geometry. validate?");
        }
        return null;
    }

    private static final int getInt(UnpickleHelper helper) {
        double value = Unpickle81.getDouble(helper);
        return Double.isNaN(value) ? 0 : (int)Math.round(value);
    }

    private static final double getDouble(UnpickleHelper helper) {
        int i;
        int pow;
        boolean negative;
        byte[] image = helper.image;
        int offset = helper.offset++;
        double value = 0.0;
        int length = image[offset];
        if (length < 0) {
            return Double.NaN;
        }
        helper.offset += 1 + length;
        if (length == 1) {
            return 0.0;
        }
        --length;
        byte exponent = image[offset + 1];
        boolean bl = negative = (exponent & 0x80) == 0;
        if (negative) {
            --length;
        }
        exponent = (byte)(exponent & 0x7F);
        double ratio = 1.0;
        int n = pow = negative ? 62 - exponent : exponent - 65;
        if (pow > 0) {
            for (i = 0; i < pow; ++i) {
                ratio *= 100.0;
            }
        } else if (pow < 0) {
            for (i = 0; i < -pow; ++i) {
                ratio /= 100.0;
            }
        }
        double r = 1.0;
        int j = 0;
        for (int i2 = 2; i2 < length + 2; ++i2) {
            int digit = image[offset + i2];
            digit = negative ? 101 - digit : --digit;
            value += (double)digit * r;
            r = RD100[j++];
        }
        return negative ? -value : (value *= ratio);
    }

    private static final int[] getElemInfoArray(UnpickleHelper helper) throws Exception {
        byte lenByte = helper.readByte();
        if ((lenByte & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        helper.skipRestOfLength(lenByte);
        helper.checkArrayHeader();
        helper.readByte();
        int length = helper.readLength();
        if (length < 0) {
            return null;
        }
        if (length % 3 != 0) {
            throw new Exception("Corrupted element info array.");
        }
        int[] ei = new int[length];
        for (int i = 0; i < length; ++i) {
            ei[i] = Unpickle81.getInt(helper);
        }
        return ei;
    }

    private static final double[] getOrdinates(UnpickleHelper helper) throws Exception {
        byte lenByte = helper.readByte();
        if ((lenByte & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        helper.skipRestOfLength(lenByte);
        helper.checkArrayHeader();
        helper.readByte();
        int length = helper.readLength();
        if (length < 0) {
            return null;
        }
        double[] coord = new double[length];
        for (int i = 0; i < length; ++i) {
            coord[i] = Unpickle81.getDouble(helper);
        }
        return coord;
    }

    private static final class UnpickleHelper {
        byte[] image = null;
        int offset = 0;

        public UnpickleHelper(byte[] image) {
            this.image = image;
            this.offset = 0;
        }

        public UnpickleHelper(byte[] image, int offset) {
            this.image = image;
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public byte[] getImage() {
            return this.image;
        }

        public byte readByte() {
            byte b = this.image[this.offset];
            ++this.offset;
            return b;
        }

        public byte[] readBytes(int length) {
            byte[] b = new byte[length];
            System.arraycopy(this.image, this.offset, b, 0, length);
            this.offset += length;
            return b;
        }

        protected final void checkImageHeader() throws Exception {
            byte flags = this.image[0];
            if ((flags & 0xFF & KOPI20_IF_IS81) == 0) {
                throw new Exception("Image is not in 8.1 format");
            }
            if ((flags & 0xFF & KOPI20_IF_COLL) != 0) {
                throw new Exception("Image is a collection image, expecting ADT");
            }
            byte version = this.image[1];
            if ((version & 0xFF) > KOPI20_VERSION) {
                throw new Exception("Image version is not recognized");
            }
            this.offset += 2;
        }

        public final byte[] readDataValue() {
            int len = this.image[this.offset] & 0xFF;
            if (len == KOPI20_LN_ELNL) {
                ++this.offset;
                return null;
            }
            if (len > KOPI20_LN_MAXV) {
                len = (((this.image[this.offset + 1] & 0xFF) * 256 + (this.image[this.offset + 2] & 0xFF)) * 256 + (this.image[this.offset + 3] & 0xFF)) * 256 + (this.image[this.offset + 4] & 0xFF);
                this.offset += 5;
            } else {
                ++this.offset;
            }
            byte[] b = new byte[len];
            System.arraycopy(this.image, this.offset, b, 0, b.length);
            this.offset += b.length;
            return b;
        }

        public byte[] readDataValue(int len) {
            if (len == 0) {
                return null;
            }
            byte[] b = new byte[len];
            System.arraycopy(this.image, this.offset, b, 0, len);
            this.offset += len;
            return b;
        }

        public boolean isElementNull(byte flag) {
            return (flag & 0xFF) == KOPI20_LN_ELNL;
        }

        protected final void skipLength() {
            int len = this.image[this.offset] & 0xFF;
            this.offset = len > KOPI20_LN_MAXV ? (this.offset += 5) : ++this.offset;
        }

        protected final void skipTo(int off) {
            if (off > this.offset) {
                this.offset = off;
            }
        }

        protected final int readLength() {
            int len = this.image[this.offset] & 0xFF;
            if (len > KOPI20_LN_MAXV) {
                if (len == KOPI20_LN_ELNL) {
                    return -1;
                }
                len = (((this.image[this.offset + 1] & 0xFF) * 256 + (this.image[this.offset + 2] & 0xFF)) * 256 + (this.image[this.offset + 3] & 0xFF)) * 256 + (this.image[this.offset + 4] & 0xFF);
                this.offset += 5;
            } else {
                ++this.offset;
            }
            return len;
        }

        protected final void skipRestOfLength(byte len) throws Exception {
            if ((len & 0xFF) > KOPI20_LN_MAXV) {
                if ((len & 0xFF) == KOPI20_LN_5BLN) {
                    this.offset += 4;
                } else {
                    throw new Exception("Invalid first length byte");
                }
            }
        }

        protected final void checkPrefix() throws Exception {
            boolean hasTypeVersion;
            byte flag = this.image[0];
            if ((flag & 0xFF & KOPI20_IF_NOPS) != 0) {
                return;
            }
            long _endOffset = this.readLength() + this.getOffset();
            byte _prefixFlag = this.readByte();
            byte _TypeInfoEncodedBits = (byte)(_prefixFlag & 0xC);
            boolean hasTypeInfoNONE = _TypeInfoEncodedBits == 0;
            boolean hasTypeInfoTOID = _TypeInfoEncodedBits == 4;
            boolean hasTypeInfoTOBJN = _TypeInfoEncodedBits == 8;
            boolean hasTypeInfoTDS = _TypeInfoEncodedBits == 12;
            boolean bl = hasTypeVersion = (_prefixFlag & 0x10) != 0;
            if (hasTypeInfoTOID) {
                byte[] _toid = this.readBytes(16);
            }
            int typeVer = 0;
            typeVer = hasTypeVersion ? this.readLength() : 1;
            if (hasTypeInfoTOBJN | hasTypeInfoTDS) {
                throw new Exception("Unsupported feature in prefix segment");
            }
            this.skipTo((int)_endOffset);
        }

        public final void checkArrayHeader() throws Exception {
            byte flags = this.readByte();
            if ((flags & 0xFF & KOPI20_IF_NOPS) != 0) {
                throw new Exception("Array image has no prefix segment");
            }
            boolean inline = true;
            if ((flags & 0xFF & KOPI20_IF_COLL) != 0) {
                inline = true;
            } else if ((flags & 0xFF & KOPI20_IF_DEGN) != 0) {
                inline = false;
            } else {
                throw new Exception("Image is not a collection image");
            }
            this.readByte();
            long length = this.readLength();
            if (DEBUG) {
                System.out.println("array total len=" + length);
            }
            int psegLen = this.readLength();
            byte psegFlags = this.readByte();
            this.readDataValue(psegLen - 1);
        }
    }
}

