/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;

public class UTFGrid {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final int GRID_MAXX = 255;
    public static final int GRID_MAXY = 255;
    public static final short DEFAULT_RESOLUTION = 4;
    String utfGridPack = null;
    private int resolution = 4;
    private BufferedImage grids = null;
    private ArrayList<Integer> keys = null;
    private HashMap<Integer, String> kvps = null;

    UTFGrid(short n) {
        this.resolution = n;
    }

    UTFGrid() {
    }

    public void init() {
        if (this.keys == null) {
            this.keys = new ArrayList();
        } else {
            this.keys.clear();
        }
        if (this.kvps == null) {
            this.kvps = new HashMap();
        } else {
            this.kvps.clear();
        }
    }

    public void clear() {
        this.keys.clear();
        this.kvps.clear();
    }

    public short DecodeUTFGridKey(char value) {
        short result = (short)value;
        if (result >= 93) {
            result = (short)(result - 1);
        }
        if (result >= 35) {
            result = (short)(result - 1);
        }
        return (short)(result - 32);
    }

    public short EncodeUTFGridKey(short value) {
        short result = (short)(value + 32);
        if (result >= 34) {
            result = (short)(result + 1);
        }
        if (result >= 92) {
            result = (short)(result + 1);
        }
        return result;
    }

    public void setGrid(String theme, BufferedImage _img) {
        BufferedImage img = this.copyImage(_img);
        try {
            if (img == null) {
                log.warning("grid (image) has not been instantiated.");
                return;
            }
            this.grids = img;
            log.finest("Adding UTFGrid for theme:[" + theme + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    public void appendKVP(int key, String strs) {
        try {
            if (this.kvps == null) {
                log.warning("data (i.e. key value pairs) has not been instantiated.");
                return;
            }
            this.kvps.put(key, strs);
            log.finest("Adding key:" + key + "; values:" + strs);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    public void appendKey(int key) {
        try {
            if (this.keys == null) {
                log.warning("keys has not been instantiated.");
                return;
            }
            this.keys.add(key);
            log.finest("Adding key:" + key);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    public BufferedImage copyImage(BufferedImage source) {
        BufferedImage b = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        Graphics g = b.getGraphics();
        g.drawImage(source, 0, 0, null);
        g.dispose();
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.resolution == 0) {
            System.out.println("factor cannot be 0, reset it to 4");
        }
        sb.append(this.convertListIntoKeysJSON(this.keys));
        sb.append(this.convertHashMapIntoKVPsJSON(this.kvps));
        sb.append(this.convertImageIntoJSON(this.grids));
        return sb.toString();
    }

    private String convertImageIntoJSON(BufferedImage bi) {
        int rows = bi.getHeight();
        int cols = bi.getWidth();
        StringBuilder sb = new StringBuilder();
        sb.append("\"grid\":[");
        if (this.resolution == 0) {
            log.warning("factor cannot be 0., reset to 4");
            this.resolution = 4;
        }
        char[] chars = new char[cols / this.resolution];
        for (int i = 0; i < rows; i += this.resolution) {
            int nn = 0;
            for (int j = 0; j < cols; j += this.resolution) {
                int b;
                int g;
                int[] localgrid = new int[this.resolution * this.resolution];
                for (int ii = 0; ii < this.resolution; ++ii) {
                    for (int jj = 0; jj < this.resolution; ++jj) {
                        localgrid[ii * this.resolution + jj] = bi.getRGB(j + jj, i + ii);
                    }
                }
                int rgb = this.getMode(localgrid);
                Color c = new Color(rgb);
                int r = c.getRed();
                char pixVal = (char)((r * 256 + (g = c.getGreen())) * 256 + (b = c.getBlue()));
                if (pixVal >= '\uffde') {
                    // empty if block
                }
                char encoded = (char)this.EncodeUTFGridKey((short)pixVal);
                chars[nn++] = encoded;
            }
            sb.append("\"");
            sb.append(chars);
            sb.append("\"");
            if (i == rows - this.resolution) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private int getMode(int[] ar) {
        for (int k = 0; k < this.resolution * this.resolution - 1; ++k) {
            int index = k;
            int min = ar[k];
            for (int l = k + 1; l < this.resolution * this.resolution; ++l) {
                if (min <= ar[l]) continue;
                min = ar[l];
                index = l;
            }
            int tmp = ar[k];
            ar[k] = ar[index];
            ar[index] = tmp;
        }
        if (ar[0] == 0 && ar[ar.length - 1] == 0) {
            return 0;
        }
        int mode = 0;
        int temp = -1;
        int temp2 = -1;
        int startI = -1;
        for (int j = 0; j < ar.length; ++j) {
            if (ar[j] == 0) continue;
            mode = ar[j];
            temp = 1;
            temp2 = 1;
            startI = j;
            break;
        }
        for (int i = startI + 1; i < ar.length; ++i) {
            if (ar[i] == 0) continue;
            temp = ar[i - 1] == ar[i] ? ++temp : 1;
            if (temp < temp2) continue;
            mode = ar[i];
            temp2 = temp;
        }
        return mode;
    }

    private String convertListIntoKeysJSON(ArrayList<Integer> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"keys\":[");
        for (int i = 0; i < list.size(); ++i) {
            sb.append("\"" + list.get(i) + "\"");
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        sb.append("],");
        return sb.toString();
    }

    private String convertHashMapIntoKVPsJSON(HashMap hmap) {
        Object[] strKeys = hmap.keySet().toArray();
        Object[] strVals = hmap.values().toArray();
        StringBuilder sb = new StringBuilder();
        sb.append("\"data\":{");
        for (int i = 0; i < strKeys.length; ++i) {
            sb.append("\"" + strKeys[i].toString() + "\":" + strVals[i].toString());
            if (i == strKeys.length - 1) continue;
            sb.append(",");
        }
        sb.append("},");
        return sb.toString();
    }

    public String getUTFGridPack() {
        return this.utfGridPack;
    }

    public void setUTFGridPack(String str) {
        this.utfGridPack = str;
    }

    public void setGridResolution(int n) {
        this.resolution = n;
    }

    public int getGridResolution() {
        return this.resolution;
    }

    public int getGridWidth() {
        if (this.grids != null) {
            return this.grids.getWidth() / this.resolution;
        }
        log.warning("Grid has not been set.");
        return 0;
    }

    public int getGridHeight() {
        if (this.grids != null) {
            return this.grids.getWidth() / this.resolution;
        }
        log.warning("Grid has not been set.");
        return 0;
    }
}

