/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.GeoRasterBitmapMask;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.RSBundle;
import oracle.sdovis.ThemeStore;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.AnnotationTextThemeDefinition;
import oracle.sdovis.theme.CommonThemeAttrs;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.LRSThemeDefinition;
import oracle.sdovis.theme.NetworkThemeDefinition;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ShadedReliefThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.TopologyThemeDefinition;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.theme.WFSThemeDefinition;
import oracle.sdovis.theme.WMSMapThemeDefinition;
import oracle.sdovis.theme.WMTSThemeDefinition;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WSAuthenticator;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.security.ChecksumHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThemeTable
extends DBTable
implements ThemeStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String mName = null;
    private String mDescription = null;
    private String mBaseTable = null;
    private String mBaseTableOwner;
    private String mSpatialColumn = null;
    private StringBuffer mStylingRulesData;
    private int mSRID = 0;
    private CommonThemeAttrs commonAttrs = new CommonThemeAttrs();
    private boolean metadataExists = false;

    public ThemeTable(String dataSrc, String themeTableName) {
        super(dataSrc, themeTableName);
        this.mStylingRulesData = new StringBuffer(4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getThemeNames(String descriptionTag) {
        Statement pstmt = null;
        ArrayList<String> v = new ArrayList<String>(32);
        try {
            AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = ds.getConnection();
            pstmt = descriptionTag == null || descriptionTag.length() == 0 ? this.mConnection.prepareStatement("select name from " + this.mTableName) : this.mConnection.prepareStatement("select name from " + this.mTableName + " where description like '%" + descriptionTag + "%'");
            this.query((PreparedStatement)pstmt);
            while (this.mResultSet.next()) {
                String name = this.mResultSet.getString(1);
                if (name == null) continue;
                v.add(name);
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            e.printStackTrace(System.err);
            List list = null;
            return list;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getThemeNamesAndTypes(String[] types) {
        Statement pstmt = null;
        ArrayList<String> v = new ArrayList<String>(32);
        String query = "select name,styling_rules from " + this.mTableName;
        if (types != null && types.length > 0) {
            query = query + " where ";
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    query = query + " or ";
                }
                query = types[0].equalsIgnoreCase("geometry") ? query + "styling_rules not like '%theme_type=%' or styling_rules like '%theme_type=\"geometry\"%'" : query + "styling_rules like '%theme_type=\"" + types[i].toLowerCase() + "\"%'";
            }
        }
        log.finest("Theme type query: " + query);
        try {
            AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = ds.getConnection();
            pstmt = this.mConnection.prepareStatement(query);
            pstmt.setFetchSize(50);
            this.query((PreparedStatement)pstmt);
            log.finest("Parsing themes type in styling rules...");
            while (this.mResultSet.next()) {
                String name = this.mResultSet.getString(1);
                String type = null;
                Clob mCLOBSVG = this.mResultSet.getClob(2);
                StringBuffer mSVGData = null;
                try {
                    mSVGData = new StringBuffer(mCLOBSVG.getSubString(1L, (int)mCLOBSVG.length()));
                }
                catch (SQLException e) {
                    mSVGData = null;
                }
                if (mSVGData != null) {
                    XMLDOMParser parser = new XMLDOMParser();
                    boolean flag = false;
                    try {
                        flag = parser.parse(mSVGData.toString());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (flag) {
                        type = "geometry";
                        Node root = parser.getElementNode("styling_rules");
                        if (root != null) {
                            type = XMLDOMParser.getAttribute(root, "theme_type");
                        }
                    } else {
                        log.warning("Unable to parse styling rules for theme: " + name);
                    }
                }
                if (name == null) continue;
                if (type == null) {
                    if (name.indexOf(":") > -1) {
                        v.add(name + ":geometry");
                        continue;
                    }
                    v.add(name);
                    continue;
                }
                if (!ThemeDefinition.isValidPredefinedThemeType(type)) {
                    v.add(name);
                    continue;
                }
                v.add(name + ":" + type);
            }
            log.finest("Returned " + v.size() + " themes.");
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            e.printStackTrace(System.err);
            List list = null;
            return list;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        return v;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String v) {
        this.mName = v;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String v) {
        this.mDescription = v;
    }

    public String getBaseTable() {
        return this.mBaseTable;
    }

    public void setBaseTable(String v) {
        this.mBaseTable = v;
    }

    public String getSpatialColumn() {
        return this.mSpatialColumn;
    }

    public void setSpatialColumn(String v) {
        this.mSpatialColumn = v;
    }

    public String getStylingRules() {
        return this.mStylingRulesData == null ? null : this.mStylingRulesData.toString();
    }

    public void setStylingRules(String v) {
        this.mStylingRulesData = new StringBuffer(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThemeDefinition getThemeDefinition(String name) {
        ThemeDefinition td;
        Statement pstmt = null;
        try {
            AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = ds.getConnection();
            String qstr = "SELECT * FROM " + this.mTableName + " WHERE upper(name)=?";
            pstmt = this.mConnection.prepareStatement(qstr);
            pstmt.setString(1, name.toUpperCase());
            this.query((PreparedStatement)pstmt);
            if (!this.next()) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01015") + " [" + name + "]");
                ThemeDefinition themeDefinition = null;
                return themeDefinition;
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            ThemeDefinition qstr = null;
            return qstr;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        String srules = this.mStylingRulesData.toString().toLowerCase();
        if (srules.indexOf("theme_type=\"wfs\"") < 0 && srules.indexOf("theme_type=\"wms\"") < 0 && srules.indexOf("theme_type=\"wmts\"") < 0 && srules.indexOf("theme_type=\"geom_custom\"") < 0 && !this.getSrid(name)) {
            this.getSridFromUser(name);
        }
        if ((td = this.parseStylingRules(this.mName, this.mBaseTable, this.mSpatialColumn, this.mStylingRulesData)) != null) {
            td.setDescription(this.mDescription);
            td.setFetchSize(this.commonAttrs.fetchSize);
            td.setScaleType(this.commonAttrs.scaleType);
            td.setMinRenderScale(this.commonAttrs.minRenderScale);
            td.setMaxRenderScale(this.commonAttrs.maxRenderScale);
            td.setMinLabelScale(this.commonAttrs.minLabelScale);
            td.setMaxLabelScale(this.commonAttrs.maxLabelScale);
            td.setMetadataRegistered(this.metadataExists);
        }
        return td;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThemeDefinition getGeometryTheme(String name, XMLDOMParser parser, Node root) {
        for (int i = 0; i < this.commonAttrs.styleRules.length; ++i) {
            if (!this.commonAttrs.styleRules[i].isCompleteSQLQuery()) continue;
            return this.convertToJDBCTheme(name, this.mSpatialColumn, this.mSRID, this.commonAttrs.styleRules[i], this.commonAttrs.keyColumn);
        }
        PredGeomThemeDefinition pgt = new PredGeomThemeDefinition(name, this.mDataSource, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, this.commonAttrs.styleRules, this.mSRID);
        pgt.setCachingMode(this.commonAttrs.cacheMode);
        pgt.setTableAlias(this.commonAttrs.table_Alias);
        if (this.commonAttrs.identifiableColumns != null) {
            Field[] attrs = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < attrs.length; ++i) {
                Field col = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                col.setDisplayName(this.commonAttrs.identifiableNames[i]);
                attrs[i] = col;
            }
            pgt.setIdentifiableColumns(attrs);
        }
        String subRegion = null;
        Connection conn = null;
        try {
            conn = DSUtil.getDBConnection(this.mDataSource, null);
            subRegion = CacheMgr2.getSubRegionName(conn);
            pgt.setCacheSubRegionName(subRegion);
            pgt.populateIndexInfo(conn);
            if (pgt.getRtreeIndexName() != null) {
                pgt.populateIndexMBR(conn, pgt.getRtreeIndexName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
        boolean pinned = this.commonAttrs.cacheMode == 2;
        try {
            CacheMgr2.createGeomGroup(subRegion, pgt.getCacheGroupName(), 0, pinned);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(pgt);
        pgt.setResourceClassName(this.commonAttrs.resourceClass);
        return pgt;
    }

    private ThemeDefinition convertToJDBCTheme(String name, String spatialCol, int srid, StylingRule rule, String keyColumn) {
        String query = rule.getFeatureCond();
        boolean asis = rule.isQueryPassThrough();
        DynGeomThemeDefinition dgt = new DynGeomThemeDefinition(name, this.mDataSource, query, spatialCol, srid);
        dgt.setPassthrough(asis);
        dgt.setFeatureStyleName(rule.getFeatureStyleName());
        dgt.setLabelColumn(rule.getLabelColumn());
        dgt.setLabelStyleName(rule.getLabelStyleName());
        if (this.commonAttrs.identifiableColumns != null) {
            Field[] attrs = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < attrs.length; ++i) {
                Field col = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                col.setDisplayName(this.commonAttrs.identifiableNames[i]);
                attrs[i] = col;
            }
            dgt.setIdentifiableColumns(attrs);
        }
        if (keyColumn != null) {
            dgt.setKeyColumn(keyColumn);
        }
        dgt.setRenderingRules(rule.getRenderingRules());
        return dgt;
    }

    private ThemeDefinition getImageTheme(String name, XMLDOMParser parser, Node root) {
        boolean imageTheme = false;
        String imageColumn = null;
        String imageFormat = null;
        String imageResUnit = null;
        String imageRes = null;
        String ic = XMLDOMParser.getAttribute(root, "image_column");
        String mf = XMLDOMParser.getAttribute(root, "image_format");
        imageResUnit = XMLDOMParser.getAttribute(root, "image_unit");
        imageRes = XMLDOMParser.getAttribute(root, "image_resolution");
        if (ic == null || ic.length() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01017") + " [" + name + "]");
        }
        if (mf == null || mf.length() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01018") + " [" + name + "]");
        }
        if (mf == null || mf.length() <= 0 || ic == null || ic.length() <= 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01019") + " [" + name + "]");
            return null;
        }
        imageTheme = true;
        imageColumn = ic;
        imageFormat = mf;
        log.finest("Loading image theme " + name + "[image_column is: " + imageColumn + "] " + "[image_resolution is: " + imageRes + "].");
        ImageThemeDefinition imgTd = new ImageThemeDefinition(name, this.mDataSource, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, imageColumn, imageFormat, this.commonAttrs.styleRules, this.mSRID);
        if (imageResUnit != null) {
            try {
                imgTd.setImageResolution(imageResUnit, Double.parseDouble(imageRes));
            }
            catch (Exception ex) {
                log.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(imgTd);
        return imgTd;
    }

    private ThemeDefinition getShadedReliefTheme(String name, XMLDOMParser parser, Node root) {
        String cam_deg;
        String cam_z;
        String cam_y;
        GeoRasterThemeDefinition grt = (GeoRasterThemeDefinition)this.getGeoRasterTheme(name, parser, root);
        String cam_x = XMLDOMParser.getAttribute(root, "camera_coordinate_x");
        if (cam_x != null && cam_x.trim().length() < 1) {
            cam_x = null;
        }
        if ((cam_y = XMLDOMParser.getAttribute(root, "camera_coordinate_y")) != null && cam_y.trim().length() < 1) {
            cam_y = null;
        }
        if ((cam_z = XMLDOMParser.getAttribute(root, "camera_coordinate_z")) != null && cam_z.trim().length() < 1) {
            cam_z = null;
        }
        if ((cam_deg = XMLDOMParser.getAttribute(root, "camera_degrees")) != null && cam_deg.trim().length() < 1) {
            cam_deg = null;
        }
        if (cam_x == null || cam_y == null || cam_z == null) {
            // empty if block
        }
        if (cam_deg == null) {
            // empty if block
        }
        cam_x = cam_x.trim();
        cam_y = cam_y.trim();
        cam_z = cam_z.trim();
        Vector3d camloc = new Vector3d(Double.parseDouble(cam_x), Double.parseDouble(cam_y), Double.parseDouble(cam_z));
        ShadedReliefThemeDefinition srt = new ShadedReliefThemeDefinition(name, grt, camloc, Double.parseDouble(cam_deg), 1, 1);
        System.out.println("ThemeTable.getShadedReliefTheme. here");
        return srt;
    }

    private ThemeDefinition getGeoRasterTheme(String name, XMLDOMParser parser, Node root) {
        String interpHint;
        String filter;
        NodeList masks;
        Node imgmasks;
        Node nd;
        NodeList operations;
        String polyMask;
        String nodata;
        String imageRes;
        String imageResUnit;
        String raster_Bands;
        String raster_Pyramid;
        String raster_Id;
        String rasterTable = null;
        String rasterId = null;
        String rasterPyramid = null;
        String rasterBands = null;
        boolean transpnodata = false;
        String raster_Table = XMLDOMParser.getAttribute(root, "raster_table");
        if (raster_Table != null && raster_Table.trim().length() < 1) {
            raster_Table = null;
        }
        if ((raster_Id = XMLDOMParser.getAttribute(root, "raster_id")) != null && raster_Id.trim().length() < 1) {
            raster_Id = null;
        }
        if ((raster_Pyramid = XMLDOMParser.getAttribute(root, "raster_pyramid")) != null && raster_Pyramid.trim().length() < 1) {
            raster_Pyramid = null;
        }
        if ((raster_Bands = XMLDOMParser.getAttribute(root, "raster_bands")) != null && raster_Bands.trim().length() < 1) {
            raster_Bands = null;
        }
        if ((imageResUnit = XMLDOMParser.getAttribute(root, "image_unit")) != null && imageResUnit.trim().length() < 1) {
            imageResUnit = null;
        }
        if ((imageRes = XMLDOMParser.getAttribute(root, "image_resolution")) != null && imageRes.trim().length() < 1) {
            imageRes = null;
        }
        if ((nodata = XMLDOMParser.getAttribute(root, "transparent_nodata")) != null && nodata.trim().length() > 0) {
            transpnodata = nodata.trim().equalsIgnoreCase("true");
        }
        String alpha_Band = XMLDOMParser.getAttribute(root, "alpha_band");
        if (raster_Table != null) {
            rasterTable = raster_Table.trim();
        }
        if (raster_Id != null) {
            rasterId = raster_Id.trim();
        }
        if (raster_Pyramid != null) {
            rasterPyramid = raster_Pyramid.trim();
        }
        if (raster_Bands != null) {
            rasterBands = raster_Bands.trim();
        }
        GeoRasterThemeDefinition grt = new GeoRasterThemeDefinition(name, this.mDataSource, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, rasterTable, rasterId, rasterPyramid, rasterBands, this.commonAttrs.styleRules, this.mSRID);
        if (alpha_Band != null && alpha_Band.trim().length() > 0) {
            try {
                grt.setAlphaBand(Integer.parseInt(alpha_Band));
            }
            catch (Exception ex) {
                log.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        if (imageResUnit != null) {
            try {
                grt.setImageResolution(imageResUnit, Double.parseDouble(imageRes));
            }
            catch (Exception ex) {
                log.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        int pmaskSRID = this.mSRID;
        String polyMaskSRID = XMLDOMParser.getAttribute(root, "polygon_mask_srid");
        if (polyMaskSRID != null && polyMaskSRID.trim().length() > 0) {
            try {
                pmaskSRID = Integer.parseInt(polyMaskSRID);
            }
            catch (Exception ex) {
                pmaskSRID = this.mSRID;
            }
        }
        if ((polyMask = XMLDOMParser.getAttribute(root, "polygon_mask")) != null && polyMask.trim().length() > 1) {
            ArrayList pts = Util.splitBy(polyMask, ",");
            double[] coords = new double[pts.size()];
            boolean validcoords = true;
            for (int k = 0; k < pts.size(); ++k) {
                try {
                    coords[k] = Double.parseDouble((String)pts.get(k));
                    continue;
                }
                catch (Exception ex) {
                    log.warning("Invalid GeoRaster polygon mask coordinates.");
                    validcoords = false;
                    break;
                }
            }
            if (validcoords) {
                grt.setPolygonMask(coords, pmaskSRID);
            }
        } else {
            String pmjoingeor;
            String pmjoingeom;
            String pmcond;
            String pmcolumn;
            String pmtable = XMLDOMParser.getAttribute(root, "polygon_mask_table");
            if (pmtable != null && pmtable.length() < 1) {
                pmtable = null;
            }
            if ((pmcolumn = XMLDOMParser.getAttribute(root, "polygon_mask_geomcolumn")) != null && pmcolumn.length() < 1) {
                pmcolumn = null;
            }
            if ((pmcond = XMLDOMParser.getAttribute(root, "polygon_mask_condition")) != null && pmcond.trim().length() < 1) {
                pmcond = null;
            }
            if ((pmjoingeom = XMLDOMParser.getAttribute(root, "polygon_mask_joingeomcolumn")) != null && pmjoingeom.length() < 1) {
                pmjoingeom = null;
            }
            if ((pmjoingeor = XMLDOMParser.getAttribute(root, "polygon_mask_joingeorcolumn")) != null && pmjoingeor.length() < 1) {
                pmjoingeor = null;
            }
            grt.setPolygonMaskFromTable(pmtable, pmcolumn, pmcond, pmjoingeom, pmjoingeor);
        }
        Node oper = parser.getElementNode("operations");
        if (oper != null && (operations = parser.getElementNodes("operation")).getLength() > 0) {
            Vector<String> operNames = new Vector<String>();
            Hashtable operParameters = new Hashtable();
            for (int i = 0; i < operations.getLength(); ++i) {
                nd = operations.item(i);
                String opName = XMLDOMParser.getAttribute(nd, "name");
                if (opName == null || opName.trim().length() < 1) {
                    log.info("Theme operation name must be defined.");
                    continue;
                }
                log.finer("Operation name: " + opName);
                operNames.add(opName);
                NodeList childs = nd.getChildNodes();
                if (childs == null || childs.getLength() <= 0) continue;
                Hashtable<String, String> parameters = new Hashtable<String, String>();
                for (int k = 0; k < childs.getLength(); ++k) {
                    Node child = childs.item(k);
                    String parname = XMLDOMParser.getAttribute(child, "name");
                    if (parname == null || parname.trim().length() < 1) continue;
                    String value = XMLDOMParser.getAttribute(child, "value");
                    if (value == null || value.trim().length() < 1) continue;
                    log.finer("Parameter name: " + parname.trim());
                    log.finer("Parameter value: " + value.trim());
                    parameters.put(parname.trim().toLowerCase(), value.trim());
                }
                if (parameters.size() <= 0) continue;
                operParameters.put(opName, parameters);
            }
            String[] opNames = null;
            if (operNames.size() > 0) {
                opNames = operNames.toArray(new String[operNames.size()]);
            }
            if (operParameters.size() == 0) {
                operParameters = null;
            }
            grt.setImageProcess(opNames, operParameters);
        }
        if ((imgmasks = parser.getElementNode("bitmap_masks")) != null && (masks = parser.getElementNodes("mask")).getLength() > 0) {
            Vector<GeoRasterBitmapMask> imasks = new Vector<GeoRasterBitmapMask>();
            for (int i = 0; i < masks.getLength(); ++i) {
                nd = masks.item(i);
                String rid = XMLDOMParser.getAttribute(nd, "raster_id");
                if (rid == null || rid.trim().length() < 1) {
                    log.warning("Image mask raster id must be defined. Mask " + i + " ignored.");
                    continue;
                }
                int rasterid = -1;
                try {
                    rasterid = Integer.parseInt(rid);
                }
                catch (Exception e) {
                    log.warning("Image mask raster id must be numeric. Mask " + i + " ignored.");
                    continue;
                }
                String rdt = XMLDOMParser.getAttribute(nd, "raster_table");
                if (rdt == null || rdt.trim().length() < 1) {
                    log.warning("Image mask raster data table name must be defined. Mask " + i + " ignored.");
                    continue;
                }
                GeoRasterBitmapMask geormask = new GeoRasterBitmapMask();
                geormask.setRasterId(rasterid);
                geormask.setRasterDataTableName(rdt.trim());
                int[] layers = null;
                int zeroMap = 0;
                int oneMap = 255;
                String imgMaskLayers = XMLDOMParser.getAttribute(nd, "layers");
                if (imgMaskLayers != null && imgMaskLayers.trim().length() > 0) {
                    ArrayList pts = Util.splitBy(imgMaskLayers, ",");
                    layers = new int[pts.size()];
                    for (int k = 0; k < pts.size(); ++k) {
                        try {
                            layers[k] = Integer.parseInt((String)pts.get(k));
                            continue;
                        }
                        catch (Exception ex) {
                            log.warning("Invalid GeoRaster image mask layers.");
                            layers = null;
                            break;
                        }
                    }
                    if (layers != null) {
                        String oneMapping;
                        geormask.setLayers(layers);
                        String zeroMapping = XMLDOMParser.getAttribute(nd, "zeromapping");
                        if (zeroMapping != null && zeroMapping.trim().length() > 0) {
                            try {
                                int zmap = Integer.parseInt(zeroMapping);
                                if (zmap < 0 || zmap > 255) {
                                    log.warning("Invalid zero mapping value. Must be between 0-255. Assuming value equal 0.");
                                    zmap = 0;
                                }
                                zeroMap = zmap;
                            }
                            catch (Exception ex) {
                                log.warning("Invalid zero mapping value. Assuming value equal 0.");
                                zeroMap = 0;
                            }
                        }
                        if ((oneMapping = XMLDOMParser.getAttribute(nd, "onemapping")) != null && oneMapping.trim().length() > 0) {
                            try {
                                int zmap = Integer.parseInt(oneMapping);
                                if (zmap < 0 || zmap > 255) {
                                    log.warning("Invalid one mapping value. Must be between 0-255. Assuming value equal 255.");
                                    zmap = 255;
                                }
                                oneMap = zmap;
                            }
                            catch (Exception ex) {
                                log.warning("Invalid one mapping value. Assuming value equal 255.");
                                oneMap = 255;
                            }
                        }
                        geormask.setZeroMapping(zeroMap);
                        geormask.setOneMapping(oneMap);
                        imasks.add(geormask);
                        continue;
                    }
                    log.warning("Mask layers must be defined. Mask ignored.");
                    continue;
                }
                log.warning("Mask layers must be defined. Mask ignored.");
            }
            if (imasks.size() > 0) {
                grt.setBitmapMasks(imasks.toArray(new GeoRasterBitmapMask[imasks.size()]));
            }
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(grt);
        grt.setNODATATransparent(transpnodata);
        String reproj = XMLDOMParser.getAttribute(root, "reproj_mode");
        if (reproj != null && reproj.trim().length() > 0) {
            grt.setReprojectionMode(reproj.trim());
        }
        if ((filter = XMLDOMParser.getAttribute(root, "filter_reproj")) != null && filter.trim().length() > 0 && filter.trim().equalsIgnoreCase("true")) {
            grt.setFilterReprojectionResult(true);
        }
        if ((interpHint = XMLDOMParser.getAttribute(root, "render_interpolation_hint")) != null && interpHint.trim().length() > 0) {
            grt.setRenderInterpolationHint(interpHint.trim());
        }
        return grt;
    }

    private ThemeDefinition getNetworkTheme(String name, XMLDOMParser parser, Node root) {
        int netLevel = 1;
        String networkName = null;
        networkName = XMLDOMParser.getAttribute(root, "network_name");
        String networkLevel = XMLDOMParser.getAttribute(root, "network_level");
        if (networkName == null || networkName.length() < 1) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01020") + " [" + name + "]");
            return null;
        }
        if (networkLevel != null && networkLevel.length() > 0) {
            try {
                netLevel = Integer.parseInt(networkLevel);
            }
            catch (Exception e) {
                netLevel = 1;
            }
        }
        NetworkThemeDefinition ntd = new NetworkThemeDefinition(name, this.mDataSource, networkName, netLevel, this.commonAttrs.styleRules, this.mSRID, this.commonAttrs.cacheMode);
        this.commonAttrs.updateThemeDefinitionCustomTags(ntd);
        return ntd;
    }

    private ThemeDefinition getTopologyTheme(String name, XMLDOMParser parser, Node root) {
        String topologyName = XMLDOMParser.getAttribute(root, "topology_name");
        if (topologyName == null || topologyName.length() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01021") + " [" + name + "]");
            return null;
        }
        TopologyThemeDefinition ttd = new TopologyThemeDefinition(name, this.mDataSource, topologyName, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, this.commonAttrs.styleRules, this.mSRID, this.commonAttrs.cacheMode);
        Node viewNode = parser.getElementNode("topo_view_info");
        if (viewNode != null) {
            NodeList children;
            Node viewcolumnName;
            NodeList children2;
            String vname = null;
            String vcolumn = null;
            Node viewName = parser.getElementNode("topo_view_name");
            if (viewName != null && (children2 = viewName.getChildNodes()) != null && (vname = children2.item(0).getNodeValue()) != null && vname.trim().length() < 1) {
                vname = null;
            }
            if ((viewcolumnName = parser.getElementNode("topo_view_column_name")) != null && (children = viewcolumnName.getChildNodes()) != null && (vcolumn = children.item(0).getNodeValue()) != null && vcolumn.trim().length() < 1) {
                vcolumn = null;
            }
            if (vname != null && vcolumn != null) {
                ttd.setTopoViewParameters(vname.trim(), vcolumn.trim());
            }
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(ttd);
        return ttd;
    }

    private ThemeDefinition getWFSTheme(String name, XMLDOMParser parser, Node root) {
        String version = XMLDOMParser.getAttribute(root, "version");
        version = version == null || version.trim().length() == 0 ? "1.0.0" : version.trim();
        String outputFormat = XMLDOMParser.getAttribute(root, "format");
        outputFormat = outputFormat == null || outputFormat.trim().length() == 0 ? "GML2" : outputFormat.trim();
        String serviceUrl = XMLDOMParser.getAttribute(root, "service_url");
        if (serviceUrl == null || serviceUrl.trim().length() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01022") + " [" + name + "]");
            return null;
        }
        serviceUrl = serviceUrl.trim();
        String key = XMLDOMParser.getAttribute(root, "key_column");
        if (key != null && key.length() > 0) {
            this.commonAttrs.keyColumn = key;
            log.finest("WFS key_column specified by user: " + this.commonAttrs.keyColumn);
        } else {
            log.finest("WFS key_column using default: fid");
            this.commonAttrs.keyColumn = "fid";
        }
        String srs = XMLDOMParser.getAttribute(root, "srs");
        if (srs != null) {
            srs = srs.trim();
        }
        String featids = XMLDOMParser.getAttribute(root, "feature_ids");
        String[] fids = null;
        if (featids != null && featids.trim().length() > 0) {
            ArrayList al = Util.splitBy(featids.trim(), ",");
            fids = al.toArray(new String[al.size()]);
        }
        String wfsUser = XMLDOMParser.getAttribute(root, "user");
        String wfsPwd = XMLDOMParser.getAttribute(root, "password");
        if (wfsPwd != null && wfsPwd.length() >= 32) {
            wfsPwd = ChecksumHelper.decAsc((String)wfsPwd);
        }
        boolean ignoreAxisOrderCheck = false;
        String igAxisOrder = XMLDOMParser.getAttribute(root, "ignore_axis_order_check");
        if (igAxisOrder != null && igAxisOrder.trim().length() > 0 && igAxisOrder.trim().equalsIgnoreCase("true")) {
            ignoreAxisOrderCheck = true;
        }
        WFSThemeDefinition wfstd = new WFSThemeDefinition(name, this.mDataSource, serviceUrl, srs, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.styleRules, fids, this.commonAttrs.keyColumn);
        wfstd.setAuthentication(wfsUser, wfsPwd);
        if (this.commonAttrs.identifiableColumns != null) {
            Field[] attrs = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < attrs.length; ++i) {
                Field col = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                col.setDisplayName(this.commonAttrs.identifiableNames[i]);
                attrs[i] = col;
            }
            wfstd.setIdentifiableColumns(attrs);
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(wfstd);
        wfstd.setVersion(version, true);
        wfstd.setOutputFormat(outputFormat);
        wfstd.setIgnoreAxisOrderCheck(ignoreAxisOrderCheck);
        return wfstd;
    }

    private ThemeDefinition getWMSTheme(String name, XMLDOMParser parser) {
        WMSMapThemeDefinition wmstdef = ThemeTable.getWMSThemeDefinition(name, parser);
        if (wmstdef == null) {
            return null;
        }
        wmstdef.setDataSourceName(this.mDataSource);
        this.commonAttrs.updateThemeDefinitionCustomTags(wmstdef);
        return wmstdef;
    }

    private ThemeDefinition getWMTSTheme(String name, XMLDOMParser parser) {
        WMTSThemeDefinition wmtstdef = this.getWMTSThemeDefinition(name, parser);
        if (wmtstdef == null) {
            return null;
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(wmtstdef);
        return wmtstdef;
    }

    private ThemeDefinition getLRSTheme(String name, XMLDOMParser parser, Node root) {
        LRSThemeDefinition lrsDef = this.getLRSThemeDefinition(name, parser, root);
        if (lrsDef == null) {
            return null;
        }
        if (this.commonAttrs.identifiableColumns != null) {
            Field[] attrs = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < attrs.length; ++i) {
                Field col = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                col.setDisplayName(this.commonAttrs.identifiableNames[i]);
                attrs[i] = col;
            }
            lrsDef.setIdentifiableColumns(attrs);
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(lrsDef);
        lrsDef.setResourceClassName(this.commonAttrs.resourceClass);
        return lrsDef;
    }

    public WMTSThemeDefinition getWMTSThemeDefinition(String name, XMLDOMParser parser) {
        String toplefty;
        String topleftx;
        int i;
        String[] str;
        String WMTS_ServiceURLPrefix = null;
        String WMTS_Version = "1.0.0";
        String WMTS_Format = "image/png";
        String WMTS_Style = null;
        String WMTS_Layer = null;
        String WMTS_tilematrixset = null;
        String WMTS_user = null;
        String WMTS_pwd = null;
        double WMTS_TopLeftCornerX = Double.NaN;
        double WMTS_TopLeftCornerY = Double.NaN;
        String[] WMTS_DimIDs = null;
        String[] WMTS_DimVals = null;
        String aParamValue = ThemeTable.getElementNodeValue(parser, "service_url");
        if (aParamValue == null) {
            log.severe("WMTS service URL parameter must be defined");
            return null;
        }
        WMTS_ServiceURLPrefix = aParamValue;
        aParamValue = ThemeTable.getElementNodeValue(parser, "user");
        if (aParamValue != null) {
            WMTS_user = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "password")) != null) {
            WMTS_pwd = aParamValue.length() >= 32 ? ChecksumHelper.decAsc((String)aParamValue) : aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "layer")) == null) {
            log.severe("Layer parameter must be defined");
            return null;
        }
        WMTS_Layer = aParamValue;
        aParamValue = ThemeTable.getElementNodeValue(parser, "version");
        if (aParamValue != null) {
            WMTS_Version = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "format")) != null) {
            WMTS_Format = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "matrix_set_id")) != null) {
            WMTS_tilematrixset = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "style")) != null) {
            WMTS_Style = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "dimension_ids")) != null) {
            str = aParamValue.split(",");
            WMTS_DimIDs = new String[str.length];
            for (i = 0; i < str.length; ++i) {
                WMTS_DimIDs[i] = str[i].trim();
            }
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "dimension_values")) != null) {
            str = aParamValue.split(",");
            WMTS_DimVals = new String[str.length];
            for (i = 0; i < str.length; ++i) {
                WMTS_DimVals[i] = str[i].trim();
            }
        }
        if (WMTS_DimIDs != null && WMTS_DimVals != null && WMTS_DimIDs.length != WMTS_DimVals.length) {
            log.severe("# of entries for WMTS Dimension IDs/Values do not match.");
        }
        if ((topleftx = ThemeTable.getElementNodeValue(parser, "top_left_corner_x")) != null && topleftx.trim().length() > 0) {
            try {
                WMTS_TopLeftCornerX = Double.parseDouble(topleftx.trim());
            }
            catch (Exception ex) {
                WMTS_TopLeftCornerX = Double.NaN;
            }
        }
        if ((toplefty = ThemeTable.getElementNodeValue(parser, "top_left_corner_y")) != null && toplefty.trim().length() > 0) {
            try {
                WMTS_TopLeftCornerY = Double.parseDouble(toplefty.trim());
            }
            catch (Exception ex) {
                WMTS_TopLeftCornerY = Double.NaN;
            }
        }
        WMTSThemeDefinition wmtstdef = new WMTSThemeDefinition(name, this.mDataSource, WMTS_ServiceURLPrefix, WMTS_Version, WMTS_Style, WMTS_Layer, WMTS_Format, WMTS_tilematrixset, WMTS_DimIDs, WMTS_DimVals);
        aParamValue = ThemeTable.getElementNodeValue(parser, "capabilities_url");
        if (aParamValue != null && aParamValue.trim().length() > 0 && wmtstdef != null) {
            wmtstdef.setCapabilitiesUrlPrefix(aParamValue.trim());
        }
        wmtstdef.setAuthentication(WMTS_user, WMTS_pwd);
        if (wmtstdef.hasAuthentication()) {
            WSAuthenticator authenticator = WSAuthenticator.getInstance();
            if (WMTS_ServiceURLPrefix.endsWith("?")) {
                authenticator.addProtectedURL(WMTS_ServiceURLPrefix.substring(0, WMTS_ServiceURLPrefix.length() - 1), wmtstdef.getUserName(), wmtstdef.getPassword());
            } else {
                authenticator.addProtectedURL(WMTS_ServiceURLPrefix, wmtstdef.getUserName(), wmtstdef.getPassword());
            }
            if (wmtstdef.getCapabilitiesUrlPrefix() != null) {
                if (wmtstdef.getCapabilitiesUrlPrefix().endsWith("?")) {
                    authenticator.addProtectedURL(wmtstdef.getCapabilitiesUrlPrefix().substring(0, wmtstdef.getCapabilitiesUrlPrefix().length() - 1), wmtstdef.getUserName(), wmtstdef.getPassword());
                } else {
                    authenticator.addProtectedURL(wmtstdef.getCapabilitiesUrlPrefix(), wmtstdef.getUserName(), wmtstdef.getPassword());
                }
            }
        }
        if (!Double.isNaN(WMTS_TopLeftCornerX) && !Double.isNaN(WMTS_TopLeftCornerY)) {
            wmtstdef.setTopLeftCornerX(WMTS_TopLeftCornerX);
            wmtstdef.setTopLeftCornerY(WMTS_TopLeftCornerY);
        }
        return wmtstdef;
    }

    public static WMSMapThemeDefinition getWMSThemeDefinition(String name, XMLDOMParser parser) {
        ArrayList vsps;
        Node vspNodes;
        String WMS_ServiceURLPrefix = null;
        String WMS_Version = "1.1.1";
        boolean WMS_Transparent = true;
        String WMS_SRS = "EPSG:4326";
        String WMS_Format = "image/png";
        String WMS_BgColor = "0xffffff";
        String WMS_Exceptions = "application/vnd.ogc.se_xml";
        String[][] WMS_VendorSpecificParameters = null;
        String[] WMS_Styles = null;
        String[] WMS_Layers = null;
        String WMS_user = null;
        String WMS_pwd = null;
        String aParamValue = ThemeTable.getElementNodeValue(parser, "service_url");
        if (aParamValue == null) {
            log.severe("WMS service URL parameter must be defined");
            return null;
        }
        WMS_ServiceURLPrefix = aParamValue;
        aParamValue = ThemeTable.getElementNodeValue(parser, "user");
        if (aParamValue != null) {
            WMS_user = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "password")) != null) {
            WMS_pwd = aParamValue.length() >= 32 ? ChecksumHelper.decAsc((String)aParamValue) : aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "layers")) == null) {
            log.severe("Layers parameter must be defined");
            return null;
        }
        WMS_Layers = ThemeTable.parseCommaSeparatedList(aParamValue);
        if (WMS_Layers == null) {
            log.severe("Layers parameters must be defined");
            return null;
        }
        aParamValue = ThemeTable.getElementNodeValue(parser, "version");
        if (aParamValue != null) {
            WMS_Version = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "format")) != null) {
            WMS_Format = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "srs")) != null) {
            WMS_SRS = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "transparent")) != null && aParamValue.trim().equalsIgnoreCase("false")) {
            WMS_Transparent = false;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "exceptions")) != null) {
            WMS_Exceptions = aParamValue;
        } else if (WMS_Version.equalsIgnoreCase("1.3.0")) {
            WMS_Exceptions = "XML";
        }
        aParamValue = ThemeTable.getElementNodeValue(parser, "bgcolor");
        if (aParamValue != null) {
            WMS_BgColor = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "styles")) != null) {
            WMS_Styles = ThemeTable.parseCommaSeparatedList(aParamValue);
        }
        if ((vspNodes = parser.getElementNode("vendor_specific_parameters")) != null && (vsps = XMLDOMParser.getRealChildNodes(vspNodes)) != null) {
            String[][] theVendorSpecificParameters = new String[2][vsps.size()];
            for (int j = 0; j < vsps.size(); ++j) {
                Node vspNode = (Node)vsps.get(j);
                String vspName = XMLDOMParser.getElementValue(XMLDOMParser.getSubElement(vspNode, "name"));
                String vspValue = XMLDOMParser.getElementValue(XMLDOMParser.getSubElement(vspNode, "value"));
                theVendorSpecificParameters[0][j] = vspName != null && vspName.trim().length() > 0 ? vspName : "";
                theVendorSpecificParameters[1][j] = vspValue != null && vspValue.trim().length() > 0 ? vspValue : "";
            }
            WMS_VendorSpecificParameters = theVendorSpecificParameters;
        }
        WMSMapThemeDefinition wmstdef = new WMSMapThemeDefinition(name, WMS_ServiceURLPrefix, WMS_Version, WMS_Layers, WMS_Styles, WMS_SRS, WMS_Format, WMS_Transparent, WMS_BgColor, WMS_Exceptions, WMS_VendorSpecificParameters);
        aParamValue = ThemeTable.getElementNodeValue(parser, "capabilities_url");
        if (aParamValue != null && aParamValue.trim().length() > 0 && wmstdef != null) {
            wmstdef.setCapabilitiesUrlPrefix(aParamValue.trim());
        }
        wmstdef.setAuthentication(WMS_user, WMS_pwd);
        if (wmstdef.hasAuthentication()) {
            WSAuthenticator authenticator = WSAuthenticator.getInstance();
            if (WMS_ServiceURLPrefix.endsWith("?")) {
                authenticator.addProtectedURL(WMS_ServiceURLPrefix.substring(0, WMS_ServiceURLPrefix.length() - 1), wmstdef.getUserName(), wmstdef.getPassword());
            } else {
                authenticator.addProtectedURL(WMS_ServiceURLPrefix, wmstdef.getUserName(), wmstdef.getPassword());
            }
            if (wmstdef.getCapabilitiesUrlPrefix() != null) {
                if (wmstdef.getCapabilitiesUrlPrefix().endsWith("?")) {
                    authenticator.addProtectedURL(wmstdef.getCapabilitiesUrlPrefix().substring(0, wmstdef.getCapabilitiesUrlPrefix().length() - 1), wmstdef.getUserName(), wmstdef.getPassword());
                } else {
                    authenticator.addProtectedURL(wmstdef.getCapabilitiesUrlPrefix(), wmstdef.getUserName(), wmstdef.getPassword());
                }
            }
        }
        return wmstdef;
    }

    private static String getElementNodeValue(XMLDOMParser parser, String nodeElem) {
        String aParamValue;
        if (parser == null || nodeElem == null) {
            return null;
        }
        Node node = parser.getElementNode(nodeElem);
        if (node != null && (aParamValue = XMLDOMParser.getElementValue(node)) != null && aParamValue.trim().length() > 0) {
            return aParamValue.trim();
        }
        return null;
    }

    private static String[] parseCommaSeparatedList(String theCSList) {
        String[] theStringArray = null;
        if (theCSList != null && theCSList.length() > 0) {
            ArrayList list = Util.splitBy(theCSList.trim(), ",");
            if (list != null && list.size() > 0) {
                theStringArray = list.toArray(new String[list.size()]);
            }
            for (int i = 0; i < theStringArray.length; ++i) {
                theStringArray[i] = theStringArray[i].trim();
            }
        }
        return theStringArray;
    }

    public static ThemeDefinition getCustomGeomTheme(String name, XMLDOMParser parser, Node root, CommonThemeAttrs commonAttrs) {
        ArrayList nlist;
        String key = XMLDOMParser.getAttribute(root, "key_column");
        if (key != null && key.trim().length() > 0) {
            key = key.trim();
            log.finest("key_column specified by user: " + key + " for Custom Geom theme.");
        } else {
            key = null;
        }
        String provider_id = XMLDOMParser.getAttribute(root, "provider_id");
        provider_id = provider_id != null && provider_id.trim().length() > 0 ? provider_id.trim() : null;
        int srid = 0;
        String sridstr = XMLDOMParser.getAttribute(root, "srid");
        if (sridstr != null && sridstr.trim().length() > 0) {
            try {
                srid = Integer.parseInt(sridstr);
                if (srid < 0) {
                    srid = 0;
                }
            }
            catch (Exception e) {
                srid = 0;
            }
        }
        Node n = XMLDOMParser.getSubElement(root, "parameters");
        Properties initProp = new Properties();
        Properties customProp = new Properties();
        ArrayList<String> encryptedParameters = new ArrayList<String>();
        if (n != null && (nlist = XMLDOMParser.getSubElements(n, "parameter")) != null) {
            for (int i = 0; i < nlist.size(); ++i) {
                Node nd = (Node)nlist.get(i);
                String pname = XMLDOMParser.getAttribute(nd, "name");
                String value = XMLDOMParser.getAttribute(nd, "value");
                String encrypted = XMLDOMParser.getAttribute(nd, "encrypted");
                if (pname == null || pname.trim().length() <= 0 || value == null || value.trim().length() <= 0) continue;
                value = value.trim();
                if (encrypted != null && encrypted.equalsIgnoreCase("true") && value.length() >= 32) {
                    encryptedParameters.add(pname);
                    value = ChecksumHelper.decAsc((String)value);
                }
                customProp.put(pname.trim(), value);
            }
        }
        CustomGeomThemeDefinition cgtd = new CustomGeomThemeDefinition(name, provider_id, initProp, srid, commonAttrs.styleRules, key);
        cgtd.setRuntimeProperties(customProp);
        cgtd.setEncryptedParameters(encryptedParameters);
        if (commonAttrs.identifiableColumns != null) {
            Field[] attrs = new Field[commonAttrs.identifiableColumns.length];
            for (int i = 0; i < attrs.length; ++i) {
                Field col = new Field("").setName(commonAttrs.identifiableColumns[i]);
                col.setDisplayName(commonAttrs.identifiableNames[i]);
                attrs[i] = col;
            }
            cgtd.setIdentifiableColumns(attrs);
        }
        commonAttrs.updateThemeDefinitionCustomTags(cgtd);
        return cgtd;
    }

    private ThemeDefinition getAnnotationTheme(String name, XMLDOMParser parser, Node root) {
        AnnotationTextThemeDefinition aTd = new AnnotationTextThemeDefinition(name, this.mDataSource, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, this.commonAttrs.styleRules, this.mSRID);
        if (this.commonAttrs.identifiableColumns != null) {
            Field[] attrs = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < attrs.length; ++i) {
                Field col = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                col.setDisplayName(this.commonAttrs.identifiableNames[i]);
                attrs[i] = col;
            }
            aTd.setIdentifiableColumns(attrs);
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(aTd);
        return aTd;
    }

    @Override
    public int update() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        this.initUpdateStatement();
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.mUpdateStatement.setString(4, this.mName.toUpperCase());
        this.mUpdateStatement.setString(1, this.mDescription);
        this.mUpdateStatement.setString(2, this.mBaseTable);
        this.mUpdateStatement.setString(3, this.mSpatialColumn);
        int res = this.mUpdateStatement.executeUpdate();
        Statement stmt = this.mConnection.createStatement();
        this.mResultSet = stmt.executeQuery("SELECT * FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' FOR UPDATE");
        if (!this.mResultSet.next()) {
            stmt.close();
            this.mConnection.setAutoCommit(autoCommit);
            this.close();
            return res;
        }
        Clob mStylingRulesCLOB = this.mResultSet.getClob("STYLING_RULES");
        try {
            Util.putClobContents(mStylingRulesCLOB, this.mStylingRulesData.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mConnection.commit();
        this.mResultSet.close();
        stmt.close();
        this.mConnection.setAutoCommit(autoCommit);
        this.close();
        return res;
    }

    @Override
    public int insert() throws SQLException {
        int res;
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.initInsertStatement();
        this.mConnection.setAutoCommit(false);
        this.mInsertStatement.setString(1, this.mName.toUpperCase());
        this.mInsertStatement.setString(2, this.mDescription);
        this.mInsertStatement.setString(3, this.mBaseTable);
        this.mInsertStatement.setString(4, this.mSpatialColumn);
        if (this.mDBtypename == null || this.mDBtypename.equalsIgnoreCase("ORACLE")) {
            res = this.mInsertStatement.executeUpdate();
            this.mConnection.commit();
            Statement stmt = this.mConnection.createStatement();
            this.mResultSet = stmt.executeQuery("SELECT * FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' FOR UPDATE");
            if (!this.mResultSet.next()) {
                stmt.close();
                this.mConnection.setAutoCommit(autoCommit);
                this.close();
                return res;
            }
            Clob mStylingRulesCLOB = this.mResultSet.getClob("STYLING_RULES");
            try {
                Util.putClobContents(mStylingRulesCLOB, this.mStylingRulesData.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mConnection.commit();
            this.mResultSet.close();
            stmt.close();
        } else {
            String stylingRules = null;
            if (this.mStylingRulesData != null) {
                stylingRules = this.mStylingRulesData.toString();
            }
            if (stylingRules == null) {
                this.mInsertStatement.setClob(5, (Clob)null);
            } else {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                try {
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)b, "UTF8"));
                    w.write(stylingRules);
                    w.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                byte[] ba = b.toByteArray();
                ByteArrayInputStream barray = new ByteArrayInputStream(ba);
                this.mInsertStatement.setAsciiStream(5, (InputStream)barray, ba.length);
            }
            res = this.mInsertStatement.executeUpdate();
            this.mConnection.commit();
        }
        this.mConnection.setAutoCommit(autoCommit);
        this.close();
        return res;
    }

    @Override
    public int delete() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean autoCommit = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initDeleteStatement();
        this.mDeleteStatement.setString(1, this.mName.toUpperCase());
        int res = this.mDeleteStatement.executeUpdate();
        this.mConnection.commit();
        this.mConnection.setAutoCommit(autoCommit);
        this.mName = null;
        this.mDescription = null;
        this.mBaseTable = null;
        this.mSpatialColumn = null;
        this.mSRID = 0;
        this.mStylingRulesData.delete(0, this.mStylingRulesData.length());
        this.close();
        return res;
    }

    @Override
    protected void initDeleteStatement() throws SQLException {
        if (this.mDeleteStatement == null) {
            this.mDeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + this.mTableName + " WHERE name = ?");
        }
    }

    @Override
    protected void initInsertStatement() throws SQLException {
        if (this.mInsertStatement == null) {
            this.mInsertStatement = this.mDBtypename == null || this.mDBtypename.equalsIgnoreCase("ORACLE") ? this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + " VALUES (?, ?, ?, ?,  empty_clob()) ") : this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + " VALUES (?, ?, ?, ?, ?) ");
        }
    }

    @Override
    protected void initUpdateStatement() throws SQLException {
        if (this.mUpdateStatement == null) {
            this.mUpdateStatement = this.mDBtypename == null || this.mDBtypename.equalsIgnoreCase("ORACLE") ? this.mConnection.prepareStatement("UPDATE " + this.mTableName + " set DESCRIPTION=?, BASE_TABLE =?,  " + " GEOMETRY_COLUMN = ?, " + " STYLING_RULES = empty_clob() WHERE name = ?") : this.mConnection.prepareStatement("UPDATE " + this.mTableName + " set DESCRIPTION=?, BASE_TABLE =?,  " + " GEOMETRY_COLUMN = ?, " + " STYLING_RULES = ? WHERE name = ?");
        }
    }

    @Override
    protected void updateLocalData() throws SQLException {
        this.mBaseTableOwner = null;
        this.mName = this.mResultSet.getString("NAME");
        this.mDescription = this.mResultSet.getString("DESCRIPTION");
        this.mBaseTable = this.mResultSet.getString("BASE_TABLE");
        int idx = this.mBaseTable.indexOf(46);
        if (idx > 0) {
            this.mBaseTableOwner = this.mBaseTable.substring(0, idx);
            this.mBaseTableOwner = this.mBaseTableOwner != null && this.mBaseTableOwner.length() > 0 ? this.mBaseTableOwner.toUpperCase() : null;
        }
        this.mSpatialColumn = this.mResultSet.getString("GEOMETRY_COLUMN");
        Clob mStylingRulesCLOB = this.mResultSet.getClob("STYLING_RULES");
        try {
            this.mStylingRulesData = new StringBuffer(mStylingRulesCLOB.getSubString(1L, (int)mStylingRulesCLOB.length()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.mStylingRulesData = null;
        }
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getSrid(String name) {
        String spCol = this.mSpatialColumn.toUpperCase();
        String user = this.mBaseTableOwner == null ? this.mUser : this.mBaseTableOwner;
        String table = this.mBaseTableOwner == null ? this.mBaseTable.toUpperCase() : this.mBaseTable.substring(this.mBaseTable.indexOf(46) + 1).toUpperCase();
        String sql = "select SRID from ALL_SDO_GEOM_METADATA where TABLE_NAME=? and (COLUMN_NAME=? OR COLUMN_NAME=? or COLUMN_NAME=?) and OWNER=?";
        Statement pstmt = null;
        try {
            String cs;
            Integer isrid2;
            AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            String key = user.toUpperCase() + "_" + table + "_" + spCol;
            Hashtable ht = ds.getOwnerTableSridCache();
            if (ht != null && (isrid2 = (Integer)ht.get(key)) != null) {
                this.mSRID = isrid2;
                log.finer("Got SRID for base table " + table + " from data source cache");
                this.metadataExists = true;
                boolean bl = true;
                return bl;
            }
            this.mConnection = ds.getConnection();
            if (this.mConnection.getMetaData().getDatabaseProductName().toUpperCase().indexOf("ORACLE") < 0) {
                this.mSRID = 0;
                this.metadataExists = true;
                boolean isrid2 = false;
                return isrid2;
            }
            if (this.mBaseTableOwner == null && (cs = Util.getCurrentSchema(this.mConnection, null)) != null) {
                user = cs;
            }
            pstmt = this.mConnection.prepareStatement(sql);
            pstmt.setString(1, table);
            pstmt.setString(2, spCol);
            pstmt.setString(3, spCol + ".SPATIALEXTENT");
            pstmt.setString(4, spCol + ".PRIVATEENVELOPE");
            pstmt.setString(5, user);
            this.query((PreparedStatement)pstmt);
            if (this.mResultSet.next()) {
                this.mSRID = this.mResultSet.getInt(1);
                ht.put(key, new Integer(this.mSRID));
                this.metadataExists = true;
            } else {
                log.warning("Metadata for user [" + user + "], table [" + table + "] and column [" + spCol + "] " + "does not exist in ALL_SDO_GEOM_METADATA.");
                this.mSRID = 0;
                this.metadataExists = false;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01023") + " [" + name + "]\n" + sql);
            log.log(Level.SEVERE, ex.getMessage(), ex);
            this.mSRID = 0;
            this.metadataExists = false;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                this.closeQuery();
            }
            catch (Exception ex2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSridFromUser(String name) {
        block17: {
            log.finer("looking at USER_SDO_GEOM_METADATA for srid of theme: " + name);
            String spCol = this.mSpatialColumn.toUpperCase();
            Statement pstmt = null;
            try {
                Integer isrid;
                String sql = "select SRID from USER_SDO_GEOM_METADATA where TABLE_NAME=? and (COLUMN_NAME=? OR COLUMN_NAME=? or COLUMN_NAME=?)";
                AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(this.mDataSource);
                String key = this.mUser.toUpperCase() + "_" + this.mBaseTable.toUpperCase() + "_" + spCol;
                Hashtable ht = ds.getOwnerTableSridCache();
                if (ht != null && (isrid = (Integer)ht.get(key)) != null) {
                    this.mSRID = isrid;
                    log.finer("Got SRID for base table " + this.mBaseTable.toUpperCase() + " from data source cache");
                    this.metadataExists = true;
                    return;
                }
                this.mConnection = ds.getConnection();
                pstmt = this.mConnection.prepareStatement(sql);
                pstmt.setString(1, this.mBaseTable.toUpperCase());
                pstmt.setString(2, spCol);
                pstmt.setString(3, spCol + ".SPATIALEXTENT");
                pstmt.setString(4, spCol + ".PRIVATEENVELOPE");
                this.query((PreparedStatement)pstmt);
                if (this.mResultSet.next()) {
                    this.mSRID = this.mResultSet.getInt(1);
                    ht.put(key, new Integer(this.mSRID));
                    this.metadataExists = true;
                    break block17;
                }
                log.warning("Metadata for table [" + this.mBaseTable.toUpperCase() + "] and column [" + spCol + "] " + "does not exist in USER_SDO_GEOM_METADATA.");
                this.mSRID = 0;
                this.metadataExists = false;
            }
            catch (Exception ex) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01023") + " [" + name + "]");
                log.log(Level.SEVERE, ex.getMessage(), ex);
                this.mSRID = 0;
                this.metadataExists = false;
                return;
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    this.closeQuery();
                }
                catch (Exception ex2) {}
            }
        }
        return;
    }

    public ThemeDefinition getThemeDefinition(String name, String description, String baseTable, String spatialColumn, StringBuffer stylingRules, int srid) {
        ThemeDefinition td;
        if (name == null || baseTable == null || spatialColumn == null || stylingRules == null) {
            return null;
        }
        this.mName = name;
        this.mDescription = description;
        this.mBaseTable = baseTable;
        this.mSpatialColumn = spatialColumn;
        this.mStylingRulesData = stylingRules;
        this.mSRID = srid;
        int idx = this.mBaseTable.indexOf(46);
        if (idx > 0) {
            this.mBaseTableOwner = this.mBaseTable.substring(0, idx);
            this.mBaseTableOwner = this.mBaseTableOwner != null && this.mBaseTableOwner.length() > 0 ? this.mBaseTableOwner.toUpperCase() : null;
        }
        if ((td = this.parseStylingRules(name, baseTable, spatialColumn, stylingRules)) != null) {
            td.setDescription(this.mDescription);
            td.setFetchSize(this.commonAttrs.fetchSize);
            td.setScaleType(this.commonAttrs.scaleType);
            td.setMinRenderScale(this.commonAttrs.minRenderScale);
            td.setMaxRenderScale(this.commonAttrs.maxRenderScale);
            td.setMinLabelScale(this.commonAttrs.minLabelScale);
            td.setMaxLabelScale(this.commonAttrs.maxLabelScale);
            td.setMetadataRegistered(true);
        }
        return td;
    }

    private ThemeDefinition parseStylingRules(String name, String baseTable, String spatialColumn, StringBuffer stylingRules) {
        try {
            XMLDOMParser parser = new XMLDOMParser();
            if (!parser.parse(stylingRules.toString())) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01014") + " [" + name + "]");
                return null;
            }
            Node root = parser.getElementNode("styling_rules");
            if (root == null) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01016") + " [" + name + "]");
                return null;
            }
            this.commonAttrs.getAttributes(name, parser, root, baseTable, spatialColumn);
            String type = XMLDOMParser.getAttribute(root, "theme_type");
            type = type == null || type.length() == 0 ? "GEOMETRY" : type.toUpperCase();
            ThemeDefinition td = null;
            if (type.equals("GEOMETRY")) {
                td = this.getGeometryTheme(name, parser, root);
                if (td != null && this.commonAttrs.highlightStyleName != null) {
                    ((VectorThemeDefinition)td).setHighlightStyleName(this.commonAttrs.highlightStyleName);
                }
            } else if (type.equals("IMAGE")) {
                td = this.getImageTheme(name, parser, root);
            } else if (type.equals("GEORASTER")) {
                td = this.getGeoRasterTheme(name, parser, root);
            } else if (type.equals("NETWORK")) {
                td = this.getNetworkTheme(name, parser, root);
            } else if (type.equals("SHADED_RELIEF")) {
                td = this.getShadedReliefTheme(name, parser, root);
            } else if (type.equals("TOPOLOGY")) {
                td = this.getTopologyTheme(name, parser, root);
            } else if (type.equals("WFS")) {
                td = this.getWFSTheme(name, parser, root);
            } else if (type.equals("GEOM_CUSTOM")) {
                td = ThemeTable.getCustomGeomTheme(name, parser, root, this.commonAttrs);
                if (td != null) {
                    td.setDataSourceName(this.mDataSource);
                }
            } else if (type.equals("ANNOTATION")) {
                td = this.getAnnotationTheme(name, parser, root);
            } else if (type.equals("WMS")) {
                td = this.getWMSTheme(name, parser);
            } else if (type.equals("WMTS")) {
                td = this.getWMTSTheme(name, parser);
            } else if (type.equals("LRS")) {
                td = this.getLRSTheme(name, parser, root);
            } else {
                log.warning("Invalid theme type specified: " + type + ". Will treat as geometry theme.");
                td = this.getGeometryTheme(name, parser, root);
                if (td != null && this.commonAttrs.highlightStyleName != null) {
                    ((VectorThemeDefinition)td).setHighlightStyleName(this.commonAttrs.highlightStyleName);
                }
            }
            return td;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public LRSThemeDefinition getLRSThemeDefinition(String name, XMLDOMParser parser, Node root) {
        String LRS_user = null;
        String LRS_pwd = null;
        String keyColumn = null;
        String joinTable = null;
        String startMeasure = null;
        String endMeasure = null;
        String measure = null;
        String lrsTableLink = null;
        String joinTableLink = null;
        keyColumn = XMLDOMParser.getAttribute(root, "key_column");
        Node nl = parser.getElementNode("join_table");
        String tmp = XMLDOMParser.getAttribute(nl, "name").trim();
        if (tmp == null || tmp.length() <= 0) {
            log.severe("In <join_table>, name attribute not found.");
            return null;
        }
        joinTable = tmp;
        tmp = XMLDOMParser.getAttribute(nl, "start_measure");
        if (tmp != null && tmp.trim().length() > 0) {
            startMeasure = tmp;
            tmp = XMLDOMParser.getAttribute(nl, "end_measure");
            if (tmp != null && tmp.trim().length() > 0) {
                endMeasure = tmp;
            } else {
                log.warning("attribute end_measure is not defined in <join_table>, start_measure is assigned to it.");
                endMeasure = startMeasure;
            }
        } else {
            tmp = XMLDOMParser.getAttribute(nl, "measure");
            if (tmp != null && tmp.trim().length() > 0) {
                measure = tmp;
            } else {
                log.severe("Attribute \"measure\" not defined in the <join_table> element.");
                return null;
            }
        }
        String aParamValue = ThemeTable.getElementNodeValue(parser, "user");
        if (aParamValue != null) {
            LRS_user = aParamValue;
        }
        if ((aParamValue = ThemeTable.getElementNodeValue(parser, "password")) != null) {
            LRS_pwd = aParamValue.length() >= 32 ? ChecksumHelper.decAsc((String)aParamValue) : aParamValue;
        }
        if ((tmp = XMLDOMParser.getAttribute(nl = parser.getElementNode("join_columns"), "lrs_table_column").trim()) == null || tmp.length() <= 0) {
            log.severe("lrs_table_column attribute not found.");
            return null;
        }
        lrsTableLink = tmp;
        tmp = XMLDOMParser.getAttribute(nl, "join_table_column").trim();
        if (tmp == null || tmp.length() <= 0) {
            log.severe("join_table_column attribute not found.");
            return null;
        }
        joinTableLink = tmp;
        StylingRule[] rules = null;
        NodeList nodeList = parser.getElementNodes("rule");
        if (nodeList.getLength() > 0) {
            rules = new StylingRule[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                rules[i] = new StylingRule(this.mBaseTable, this.mSpatialColumn, parser, nodeList.item(i));
            }
        }
        if (startMeasure == null) {
            if (measure == null) {
                log.warning("Attributes pair \"start_measure\" and \"end_measure\" or single attribute \"measure\" was not found in join_table element.");
                return null;
            }
            startMeasure = measure;
            endMeasure = measure;
        }
        LRSThemeDefinition td = new LRSThemeDefinition(name, this.mDataSource, this.mBaseTable, this.mSpatialColumn, keyColumn, joinTable, startMeasure, endMeasure, lrsTableLink, joinTableLink, this.mSRID, rules);
        return td;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getThemeBaseTables(String descriptionTag, String[] themes) {
        Statement pstmt = null;
        ArrayList<String> v = new ArrayList<String>(32);
        HashSet<String> lookup = new HashSet<String>();
        try {
            AbstractDBDataSource ds = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = ds.getConnection();
            for (int x = 0; x < themes.length; ++x) {
                String name;
                pstmt = descriptionTag == null || descriptionTag.length() == 0 ? this.mConnection.prepareStatement("select base_table from " + this.mTableName + " where name='" + themes[x] + "'") : this.mConnection.prepareStatement("select base_table from " + this.mTableName + " where description like '%" + descriptionTag + "%'" + " and name='" + themes[x] + "'");
                this.query((PreparedStatement)pstmt);
                if (!this.mResultSet.next() || (name = this.mResultSet.getString(1)) == null || lookup.contains(name)) continue;
                lookup.add(name);
                v.add(name);
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            e.printStackTrace(System.err);
            List list = null;
            return list;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                this.closeQuery();
            }
            catch (SQLException e2) {}
        }
        return v;
    }
}

