/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import oracle.mapviewer.share.ext.NsDpInfo;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.sdovis.DataException;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.VisContext;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.ThemeDefinition;

public abstract class Theme
implements Cloneable {
    protected ThemeDecorator decorator = new ThemeDecorator();
    protected ThemeDefinition definition = null;
    protected ThemeDataProducer producer = null;
    int[] userClick = null;
    String[] selectList = null;
    String highlightStyleName = null;
    String report = null;
    boolean isClickable = false;
    boolean needLegend = false;
    boolean showLabels = true;
    int windowBuffer = 0;

    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        if (vc.isInterrupted()) {
            return 0;
        }
        return this.getProducer().prepareData(queryWin, vc);
    }

    public void postPreparation(VisContext vc) {
        this.getProducer().postPreparation(vc);
    }

    public void abortPreparation() {
        this.getProducer().abort();
    }

    public abstract void destroy();

    public abstract boolean isTextLabelPresent();

    public String getName() {
        return this.definition.getName();
    }

    public void setName(String name) {
        this.definition.setName(name);
    }

    public String getDataSourceName() {
        return this.definition.getDataSourceName();
    }

    public void setDataSourceName(String dsrc) {
        this.definition.setDataSourceName(dsrc);
    }

    public ThemeDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(ThemeDecorator deco) {
        if (deco != null) {
            this.decorator = deco.clone();
        }
    }

    public ThemeDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(ThemeDefinition def) {
        this.definition = def;
    }

    public ThemeDataProducer getProducer() {
        return this.producer;
    }

    public void setProducer(ThemeDataProducer prod) {
        this.producer = prod;
    }

    public int getSRID() {
        if (this.definition == null) {
            return 0;
        }
        return this.definition.getSrid();
    }

    public void setSRID(int s) {
        if (this.definition != null) {
            this.definition.setSrid(s);
        }
    }

    public int size() {
        return this.getProducer().size();
    }

    public StyledFeatureI getStyledFeature(int idx) {
        return this.getProducer().getStyledFeature(idx);
    }

    public StyledFeatureI[] getStyledFeatures() {
        return this.getProducer().getStyledFeatures();
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        return this.getProducer().getSelectedFeaturesAsTheme(window, name);
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        return this.getProducer().getSelectedFeatures(window);
    }

    public double[] getDataMBR() {
        return this.getProducer().getDataMBR();
    }

    public void setShowLabels(boolean labels) {
        this.showLabels = labels;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public String[] getRenderingStyles() {
        if (this.definition == null) {
            return null;
        }
        return this.definition.getRenderingStyles();
    }

    public String[] getLabelingStyles() {
        if (this.definition == null) {
            return null;
        }
        return this.definition.getLabelingStyles();
    }

    public int getFetchSize() {
        if (this.decorator == null && this.definition == null) {
            return 100;
        }
        if (this.decorator != null && this.decorator.getFetchSize() != 100) {
            return this.decorator.getFetchSize();
        }
        if (this.definition != null) {
            return this.definition.getFetchSize();
        }
        return 100;
    }

    public static NsDpHandler getNsdpHandler(VisContext vc, String theme) {
        if (vc == null) {
            return null;
        }
        Vector v = vc.getNsDpHandlers();
        if (v == null) {
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            NsDpHandler handler = (NsDpHandler)v.get(i);
            NsDpInfo temp = handler.getDef();
            String themeName = temp.getTheme();
            if (themeName == null || !themeName.equalsIgnoreCase(theme)) continue;
            return handler;
        }
        return null;
    }

    public String getScaleType() {
        if (this.decorator == null && this.definition == null) {
            return "MAPVIEWER_NATIVE";
        }
        if (this.decorator != null && (this.decorator.getMinScale() != Double.POSITIVE_INFINITY || this.decorator.getMaxScale() != Double.NEGATIVE_INFINITY || this.decorator.getLabelMinScale() != Double.POSITIVE_INFINITY || this.decorator.getLabelMaxScale() != Double.NEGATIVE_INFINITY)) {
            return this.decorator.getScaleType();
        }
        if (this.definition != null) {
            return this.definition.getScaleType();
        }
        return "MAPVIEWER_NATIVE";
    }

    public double getMinRenderScale() {
        if (this.decorator == null && this.definition == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.decorator != null && this.decorator.getMinScale() != Double.POSITIVE_INFINITY) {
            return this.decorator.getMinScale();
        }
        if (this.definition != null) {
            return this.definition.getMinRenderScale();
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getMaxRenderScale() {
        if (this.decorator == null && this.definition == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.decorator != null && this.decorator.getMaxScale() != Double.NEGATIVE_INFINITY) {
            return this.decorator.getMaxScale();
        }
        if (this.definition != null) {
            return this.definition.getMaxRenderScale();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getMinLabelScale() {
        if (this.decorator == null && this.definition == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.decorator != null && this.decorator.getLabelMinScale() != Double.POSITIVE_INFINITY) {
            return this.decorator.getLabelMinScale();
        }
        if (this.definition != null) {
            return this.definition.getMinLabelScale();
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getMaxLabelScale() {
        if (this.decorator == null && this.definition == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.decorator != null && this.decorator.getLabelMaxScale() != Double.NEGATIVE_INFINITY) {
            return this.decorator.getLabelMaxScale();
        }
        if (this.definition != null) {
            return this.definition.getMaxLabelScale();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean withinRenderScaleLimits(double scale) {
        if (scale == Double.NEGATIVE_INFINITY || scale == Double.POSITIVE_INFINITY || scale == 0.0) {
            return true;
        }
        return scale > this.getMaxRenderScale() && scale <= this.getMinRenderScale();
    }

    public boolean withinLabelScaleLimits(double scale) {
        if (scale == Double.NEGATIVE_INFINITY || scale == Double.POSITIVE_INFINITY || scale == 0.0) {
            return true;
        }
        return scale > this.getMaxLabelScale() && scale <= this.getMinLabelScale();
    }
}

