/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ext.NSDataProvider;
import oracle.mapviewer.share.ext.NSDataSet;
import oracle.mapviewer.share.ext.NSRow;
import oracle.mapviewer.share.ext.NsDpInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.NSDataProviderMgr;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.VectorThemeDefinition;

public class NsDpHandler {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private NsDpInfo def;
    private boolean prepared;
    private NSDataSet data;
    private NSDataLoader thread;
    private String keyColumn = null;

    public NsDpHandler(NsDpInfo info) {
        this.def = info;
    }

    public void startThread() {
        this.thread = new NSDataLoader();
        this.thread.start();
    }

    public boolean waitForThread() throws Exception {
        if (this.thread == null) {
            return false;
        }
        this.thread.join(300000L);
        if (this.thread.getException() == null) {
            return true;
        }
        throw this.thread.getException();
    }

    public void destroy() {
        if (this.thread != null) {
            this.thread = null;
        }
        if (this.data != null) {
            this.data.close();
        }
    }

    public void setDef(NsDpInfo def) {
        this.def = def;
    }

    public NsDpInfo getDef() {
        return this.def;
    }

    public void setData(NSDataSet data) {
        this.data = data;
    }

    public NSDataSet getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDataJoin(VisContext vc) {
        if (this.def.isProcessed()) {
            return;
        }
        Theme theme = vc.getThemeList().getLastMatchingTheme(this.def.getTheme());
        if (theme == null) {
            log.severe("NSDataHandler: cannot find referenced theme: " + this.def.getTheme());
            this.def.setProcessed(true);
            return;
        }
        ThemeDefinition themeDef = theme.getDefinition();
        if (themeDef instanceof VectorThemeDefinition) {
            this.keyColumn = ((VectorThemeDefinition)themeDef).getKeyColumn();
        }
        try {
            StyledFeatureI[] matchedFeatures = this.doJoin(theme.getStyledFeatures(), this.data, this.def.getCustomRenderStyle());
            if (matchedFeatures != null && matchedFeatures.length > 0) {
                theme.getProducer().setStyledFeatures(matchedFeatures);
            } else {
                log.info("NSDataHandler: no matching feature found.");
                if (!this.def.isShowUnmatched()) {
                    matchedFeatures = new StyledFeature[]{};
                    theme.getProducer().setStyledFeatures(matchedFeatures);
                }
            }
        }
        catch (Exception ex) {
            log.severe("NSDataHandler: failure joining theme: " + this.def.getTheme());
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            this.def.setProcessed(true);
        }
    }

    private StyledFeatureI[] doJoin(StyledFeatureI[] feats, NSDataSet nsd, String customRenderStyle) {
        long t1 = System.currentTimeMillis();
        if (feats == null) {
            log.severe("No renderable features found during NSDP join.");
            return new StyledFeature[0];
        }
        if (nsd == null) {
            log.severe("No non-spatial data found during NSDP join.");
            return new StyledFeature[0];
        }
        int numFeats = feats.length;
        int numNsd = nsd.size();
        Vector<StyledFeatureI> matches = new Vector<StyledFeatureI>();
        Hashtable<String, NSRow> index = new Hashtable<String, NSRow>((int)((double)numNsd * 1.2));
        NSRow[] data = nsd.getRows();
        if (data == null) {
            data = new NSRow[]{};
        }
        for (int i = 0; i < data.length; ++i) {
            NSRow row = data[i];
            Field keyAttr = row.getKeyAttribute();
            if (keyAttr == null) {
                log.warning("cannot find a primary key attribute.");
                continue;
            }
            String key = "" + keyAttr.getValue();
            NSRow o = index.put(key.toUpperCase(), row);
            if (o == null) continue;
            log.warning("duplicate NSRow found: " + key);
        }
        String regionKeyCol = this.def.getJoinColumnSpatial();
        for (int i = 0; i < numFeats; ++i) {
            StyledFeatureI sf = feats[i];
            String keyValue = this.findKeyValue(sf, regionKeyCol);
            if (keyValue == null) {
                log.info("cannot find a key value in the styled feature.");
                continue;
            }
            NSRow row = (NSRow)index.get(keyValue.toUpperCase());
            if (row == null) {
                if (i != 0) continue;
                log.finer("Cannot find any matching NSRow for key (from spatial table): " + keyValue);
                continue;
            }
            this.modifyFeature(sf, row, customRenderStyle);
            sf.setNsdpMetaInfo(nsd.getMetadata());
            RenderingRule[] rr = nsd.getCustomRenderingRules();
            if (rr != null && rr.length > 0) {
                sf.setFeatureStyleName(rr[0].getStyleName());
                sf.setRenderingRules(rr);
            }
            matches.add(sf);
        }
        log.finest("Time spent on NSDP join:" + (System.currentTimeMillis() - t1) + "ms. Matches found: " + matches.size() + ".");
        if (this.def.isShowUnmatched()) {
            return feats;
        }
        return matches.toArray(new StyledFeatureI[matches.size()]);
    }

    private String findKeyValue(StyledFeatureI sf, String regionKeyCol) {
        Field ac;
        int i;
        if (regionKeyCol.equalsIgnoreCase(this.keyColumn)) {
            return sf.getID();
        }
        Field[] idAttrs = sf.getIdentifiableAttributes();
        Field[] rdAttrs = sf.getRenderableAttributes();
        String label = sf.getLabel();
        String keyValue = null;
        if (idAttrs != null && idAttrs.length > 0) {
            for (i = 0; i < idAttrs.length; ++i) {
                ac = idAttrs[i];
                if (ac == null || !regionKeyCol.equalsIgnoreCase(ac.getName()) && !regionKeyCol.equalsIgnoreCase(ac.getDisplayName())) continue;
                keyValue = "" + ac.toString();
                keyValue = keyValue.toUpperCase();
                break;
            }
        }
        if (keyValue == null && rdAttrs != null && rdAttrs.length > 0) {
            for (i = 0; i < rdAttrs.length; ++i) {
                ac = rdAttrs[i];
                if (ac == null || !regionKeyCol.equalsIgnoreCase(ac.getName()) && !regionKeyCol.equalsIgnoreCase(ac.getDisplayName())) continue;
                keyValue = "" + ac.toString();
                keyValue = keyValue.toUpperCase();
                break;
            }
        }
        if (keyValue == null && label != null) {
            keyValue = label;
        }
        if (keyValue == null) {
            keyValue = sf.getID();
        }
        return keyValue;
    }

    private void modifyFeature(StyledFeatureI sf, NSRow row, String crStyle) {
        int numValues = row.size() - 1;
        if (row.getLabelAttribute() != null) {
            --numValues;
        }
        Field[] idas = sf.getIdentifiableAttributes();
        Vector<Field> v = new Vector<Field>();
        if (idas != null && idas.length > 0) {
            for (int i = 0; i < idas.length; ++i) {
                v.add(idas[i]);
            }
        }
        Field[] rdcs = new Field[numValues];
        Field label = null;
        int k = 0;
        for (int i = 0; i < row.size(); ++i) {
            Field a = row.get(i);
            if (a.isKey() || a.isLabelText()) {
                if (a.isLabelText()) {
                    label = a;
                }
                v.add(a);
                continue;
            }
            rdcs[k++] = (Field)a.clone();
        }
        sf.setRenderableAttributes(rdcs);
        sf.setIdentifiableAttributes(v.toArray(new Field[v.size()]));
        if (crStyle != null && crStyle.length() > 0) {
            sf.setFeatureStyle(null);
            sf.setFeatureStyleName(crStyle);
        }
        if (label != null) {
            sf.setLabel(label.getString());
        }
    }

    public class NSDataLoader
    extends Thread {
        Exception ex;
        NSDataSet nsdata;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (NsDpHandler.this.def.isProcessed()) {
                return;
            }
            NSDataProvider datap = NSDataProviderMgr.getProvider(NsDpHandler.this.def.getDpId());
            if (datap == null) {
                this.ex = new Exception("cannot find NS data provider for: " + NsDpHandler.this.def.getDpId());
                return;
            }
            try {
                long t1 = System.currentTimeMillis();
                Properties params = NsDpHandler.this.def.getDpParams();
                Hashtable<String, String> ht = NsDpHandler.this.def.getContextObjects();
                if (ht == null) {
                    ht = new Hashtable<String, String>(11);
                }
                Enumeration<?> enumer = params.propertyNames();
                while (enumer.hasMoreElements()) {
                    String propName = (String)enumer.nextElement();
                    String propValue = (String)params.get(propName);
                    ht.put(propName, propValue);
                }
                log.finest("NsDpHandler: begin building NS data set...");
                this.nsdata = datap.buildDataSet(ht);
                NsDpHandler.this.data = this.nsdata;
                log.finest("Time spent getting NSDP data: " + (System.currentTimeMillis() - t1) + "ms.");
            }
            catch (Exception ex2) {
                this.ex = ex2;
                log.log(Level.SEVERE, ex2.getMessage(), ex2);
                this.nsdata = null;
            }
            finally {
                NsDpHandler.this.prepared = true;
            }
        }

        public Exception getException() {
            return this.ex;
        }

        public NSDataSet getNSDataSet() {
            return this.nsdata;
        }
    }
}

