/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.PrintStream;
import java.io.PrintWriter;

public class DataException
extends Exception {
    public static final String MESSAGE_ABORTED = "Aborted by user.";
    public static final String MESSAGE_OUT_OF_MEMORY = "Out of memory.";
    public String description = "";
    public Throwable detail = null;

    public DataException() {
    }

    public DataException(Throwable ex) {
        this.detail = ex;
    }

    public DataException(String message) {
        super(message);
    }

    public DataException(String message, Throwable ex) {
        super(message);
        this.detail = ex;
    }

    public boolean isAbortedByUser() {
        return MESSAGE_ABORTED.equals(this.getMessage());
    }

    @Override
    public String toString() {
        String val = "Message:" + this.getMessage() + "\n";
        val = val + "Description: " + this.description;
        if (this.detail != null) {
            val = val + "Nested exception is:\n" + this.detail.toString();
        }
        return val;
    }

    public boolean isOutOfMemory() {
        return MESSAGE_OUT_OF_MEMORY.equals(this.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        if (this.detail == null) {
            super.printStackTrace(ps);
        } else {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(this);
                this.detail.printStackTrace(ps);
            }
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        if (this.detail == null) {
            super.printStackTrace(pw);
        } else {
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.println(this);
                this.detail.printStackTrace(pw);
            }
        }
    }
}

