/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.awt.Color;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.BucketSeries;

public class ColorSchemeStyleModel
extends AbstractBucketStyleModel {
    static final long serialVersionUID = -5145336353321496194L;
    Color baseColor = null;
    Color strokeColor = null;
    float strokeWidth = 1.0f;

    public ColorSchemeStyleModel() {
        this.type = 9;
        this.bucketSeries = new BucketSeries();
        this.baseColor = Color.black;
        this.strokeColor = Color.blue;
    }

    public ColorSchemeStyleModel(BucketSeries bs) {
        this.type = 9;
        this.bucketSeries = bs;
        this.baseColor = Color.black;
        this.strokeColor = Color.blue;
    }

    @Override
    public Object clone() {
        ColorSchemeStyleModel obj = (ColorSchemeStyleModel)super.clone();
        return obj;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    @Override
    public String toXMLString() {
        String xmlDef = "<?xml version=\"1.0\" ?>\n";
        xmlDef = xmlDef + "<AdvancedStyle>\n   <ColorSchemeStyle";
        if (this.baseColor != null) {
            xmlDef = xmlDef + " basecolor=\"" + StyleUtils.getHexidecimalString(this.baseColor) + "\"";
            if (this.baseColor.getAlpha() != 255) {
                xmlDef = xmlDef + " basecolor_opacity=\"" + this.baseColor.getAlpha() + "\"";
            }
        }
        if (this.strokeColor != null) {
            xmlDef = xmlDef + " strokecolor=\"" + StyleUtils.getHexidecimalString(this.strokeColor) + "\"";
            if (this.strokeColor.getAlpha() != 255) {
                xmlDef = xmlDef + " strokecolor_opacity=\"" + this.strokeColor.getAlpha() + "\"";
            }
            if (this.strokeWidth > 1.0f) {
                xmlDef = xmlDef + " strokewidth=\"" + this.strokeWidth + "\"";
            }
        }
        xmlDef = xmlDef + ">\n";
        xmlDef = xmlDef + this.getBucketSeries().toXMLString();
        xmlDef = xmlDef + "\n   </ColorSchemeStyle>\n</AdvancedStyle>\n";
        return xmlDef;
    }

    public void setBaseColor(Color baseColor) {
        this.baseColor = baseColor;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth < 1.0f ? 1.0f : strokeWidth;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }
}

