/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.util.ArrayList;
import java.util.Collection;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.sdovis.util.Util;

public class CollectionBucket
extends Bucket {
    static final long serialVersionUID = -1138763220227156473L;
    Collection members = null;
    String delimiter = ",";
    String type = "string";
    boolean keepWhiteSpace = false;

    public CollectionBucket(String id) {
        super(id);
    }

    public CollectionBucket(String id, Collection col) {
        super(id);
        this.members = col;
        if (col.contains(new Field("#DEFAULT#")) || col.contains(new Field("#default#"))) {
            this.setDefaultBucket(true);
        }
    }

    @Override
    public Object clone() {
        CollectionBucket bkt = (CollectionBucket)super.clone();
        if (this.members != null && this.members.size() > 0) {
            bkt.members = new ArrayList(this.members);
        }
        return bkt;
    }

    public void setMembers(Collection col) {
        this.members = col;
    }

    public void setMembers(Field[] values) {
        this.members = new ArrayList(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.members.add(values[i]);
        }
    }

    public Collection getMembers() {
        return this.members;
    }

    public Field[] getMembersAsArray() {
        if (this.members == null) {
            return null;
        }
        return this.members.toArray(new Field[this.members.size()]);
    }

    public String getMembersAsString() {
        if (this.members == null || this.members.size() == 0) {
            return null;
        }
        Field[] fields = this.members.toArray(new Field[this.members.size()]);
        String membersStr = fields[0].toString();
        for (int i = 1; i < this.members.size(); ++i) {
            membersStr = membersStr + this.delimiter + fields[i].toString();
        }
        return membersStr;
    }

    public void setMembersAsString(String membersStr) {
        this.setMembers(membersStr);
    }

    public void setMembers(String membersStr) {
        if (membersStr == null || membersStr.length() == 0) {
            this.members = null;
        } else {
            ArrayList items = Util.splitBy(membersStr, this.delimiter);
            if (items == null || items.size() == 0) {
                this.members = null;
            } else {
                this.members = new ArrayList(items.size());
                for (int i = 0; i < items.size(); ++i) {
                    Field f = null;
                    f = this.type != null && this.type.equalsIgnoreCase("integer") ? new Field().setInt(Integer.parseInt(items.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("double") ? new Field().setDouble(Double.parseDouble(items.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("float") ? new Field().setFloat(Float.parseFloat(items.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("long") ? new Field().setLong(Long.parseLong(items.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("short") ? new Field().setShort(Short.parseShort(items.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("char") ? new Field(items.get(i).toString()) : (this.type != null && this.type.equalsIgnoreCase("date") ? Field.createField(items.get(i).toString(), "date") : new Field(items.get(i).toString())))))));
                    if (f == null) continue;
                    this.members.add(f);
                }
            }
        }
    }

    @Override
    public boolean contains(Field v) {
        try {
            for (Field field : this.members) {
                if (field.compareTo(v) != 0) continue;
                return true;
            }
        }
        catch (ClassCastException e) {
            v = Field.createField(v.getString(), "string");
            for (Field field : this.members) {
                if (field.compareTo(v) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delim) {
        this.delimiter = delim == null ? "," : delim;
    }

    public void setKeepWhiteSpace(boolean keep) {
        this.keepWhiteSpace = keep;
    }

    public boolean getKeepWhiteSpace() {
        return this.keepWhiteSpace;
    }

    public void print() {
        if (this.members.size() > 0) {
            Object[] objs = this.members.toArray();
            System.out.println("Collection Bucket members");
            for (int i = 0; i < this.members.size(); ++i) {
                if (objs[i].toString() != null) {
                    System.out.println("Element: " + i + "= " + objs[i].toString());
                    continue;
                }
                System.out.println("Element: " + i + "= null");
            }
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }
}

