/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import java.awt.Font;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class TextStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 2449144528089711618L;
    public static final float MIN_HALO_SIZE = 1.5f;
    private static Font defaultFont = new Font("Serif", 0, 18);
    Font font = defaultFont;
    SizeDefinition2D fontSize = new SizeDefinition2D(12.0, -1.0, null);
    String embeddedTTFont = null;
    Color color = Color.black;
    Color background = null;
    Color haloColor = Color.white;
    SizeDefinition haloWidth = new SizeDefinition(-1.0, null);
    LabelingHints labelingHints = new LabelingHints(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER);
    boolean sticky = false;
    boolean honorNewline = false;
    boolean autoTextWrap = false;
    int wrappingWidth = 400;
    float letterSpacing = 0.0f;
    boolean smartPathFollowing = false;
    public static String TEXT_DECORATION_NONE = "NONE";
    public static String TEXT_DECORATION_UNDERLINE = "UNDERLINE";
    public static String TEXT_DECORATION_LINETHROUGH = "LINETHROUGH";
    public static String TEXT_DECORATION_OVERLINE = "OVERLINE";
    String textDecoration = TEXT_DECORATION_NONE;
    float multilineSpacing = 0.0f;
    float wordSpacing = 0.0f;
    Color strokeColor = null;
    boolean straightLineLabeling = false;
    boolean applyOHintTosimplepoints = false;

    public TextStyleModel() {
        this.type = 5;
        this.labelingHints.put(LabelingHints.KEY_OPOINT_HALIGN, LabelingHints.VALUE_OPOINT_HALIGN_CENTER);
        this.labelingHints.put(LabelingHints.KEY_LINE_VALIGN, LabelingHints.VALUE_LINE_VALIGN_BASELINE);
    }

    @Override
    public Object clone() {
        TextStyleModel obj = (TextStyleModel)super.clone();
        obj.setFontSizes(this.fontSize);
        obj.setHaloWidth(this.haloWidth);
        return obj;
    }

    @Override
    public String getTypeName() {
        return "TEXT";
    }

    public void setFont(Font font) {
        this.font = font == null ? defaultFont : font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setHalo(float size, Color color) {
        this.setHaloWidth(size);
        this.setHaloColor(color);
    }

    public void setHaloColor(Color haloColor) {
        this.haloColor = haloColor;
    }

    public Color getHaloColor() {
        return this.haloColor;
    }

    public SizeDefinition getHaloSize() {
        return this.haloWidth;
    }

    public void setHaloWidth(SizeDefinition hwidth) {
        this.haloWidth = new SizeDefinition(-1.0, null);
        if (hwidth == null) {
            return;
        }
        this.haloWidth.setValue(hwidth.getValue());
        this.haloWidth.setUnit(hwidth.getUnit());
    }

    public void setHaloWidth(float haloWidth) {
        this.haloWidth.setValue(haloWidth);
    }

    public float getHaloWidth() {
        return (float)this.haloWidth.getValue();
    }

    public void setHaloWidthUnit(String unit) {
        this.haloWidth.setUnit(unit);
    }

    public String getHaloWidthUnit() {
        return this.haloWidth.getUnit();
    }

    public float getFontSizeValue() {
        return (float)this.fontSize.getWidth();
    }

    public void setFontSizeValue(float size) {
        this.fontSize.setWidth(size);
    }

    public void setFontSizes(SizeDefinition2D fsize) {
        this.fontSize = new SizeDefinition2D(12.0, -1.0, null);
        if (fsize == null) {
            return;
        }
        this.fontSize.setWidth(fsize.getWidth());
        this.fontSize.setHeight(fsize.getHeight());
        this.fontSize.setUnit(fsize.getUnit());
    }

    public void setFontSize(float size, String unit) {
        this.fontSize.setWidth(size);
        this.fontSize.setUnit(unit);
    }

    public SizeDefinition2D getFontSizes() {
        return this.fontSize;
    }

    public void setFontSizeUnit(String unit) {
        this.fontSize.setUnit(unit);
    }

    public String getFontSizeUnit() {
        return this.fontSize.getUnit();
    }

    public float getMinFontSize() {
        return (float)this.fontSize.getHeight();
    }

    public void setMinFontSize(float size) {
        this.fontSize.setHeight(size);
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public static float getMinimumHaloSize() {
        return 1.5f;
    }

    public boolean haloEnabled() {
        if (this.haloWidth.isPixelUnit()) {
            return this.haloWidth.getValue() >= 1.5;
        }
        return this.haloWidth.getValue() > 0.0;
    }

    @Override
    public String toXMLString() {
        Font textFont = null;
        textFont = this.font == null ? defaultFont : this.font;
        int style = textFont.getStyle();
        String styleName = "plain";
        if (textFont.isItalic()) {
            styleName = "italic";
        }
        String familyName = null;
        String embttf = "";
        if (this.embeddedTTFont == null) {
            familyName = this.font.getFamily();
        } else {
            familyName = this.embeddedTTFont;
            embttf = " embedded-ttf=\"true\" ";
        }
        float size = this.getFontSizeValue();
        String sizeStr = String.valueOf(size);
        if (this.fontSize.isPixelUnit()) {
            sizeStr = String.valueOf((int)size);
        }
        String minSizeStr = "";
        if (this.getMinFontSize() > 0.0f) {
            float minSize = this.getMinFontSize();
            minSizeStr = ";min-font-size:" + String.valueOf(minSize);
            if (this.fontSize.isPixelUnit()) {
                minSizeStr = ";min-font-size:" + String.valueOf((int)minSize);
            }
        }
        String sizeUnit = "";
        if (this.fontSize.getUnit() != null && !this.fontSize.getUnit().equalsIgnoreCase("px")) {
            sizeUnit = this.fontSize.getUnit();
            if (this.getMinFontSize() > 0.0f) {
                minSizeStr = minSizeStr + this.fontSize.getUnit();
            }
        }
        String weight = "";
        if (textFont.isBold()) {
            weight = "font-weight:bold;";
        }
        String floatwidth = "";
        String floatwidthunit = "";
        if (this.haloWidth.getUnit() != null && !this.haloWidth.getUnit().equalsIgnoreCase("px")) {
            floatwidthunit = this.haloWidth.getUnit();
        }
        String hwdStr = StyleUtils.getUSLocaleFormat(this.haloWidth.getValue());
        String hwStr = StyleUtils.cleanDecimalZeros(hwdStr, 1);
        if (this.haloWidth.isPixelUnit()) {
            hwStr = StyleUtils.cleanDecimalZeros(hwdStr, 0);
        }
        if (this.haloColor != null && (this.haloWidth.getValue() > 0.0 && !this.haloWidth.isPixelUnit() || this.haloWidth.getValue() >= 1.0 && this.haloWidth.isPixelUnit())) {
            floatwidth = " float-width=\"" + hwStr + floatwidthunit + "\"";
            if (this.haloColor != Color.white) {
                floatwidth = floatwidth + " float-color=\"" + StyleUtils.getHexidecimalString(this.haloColor) + "\"";
                if (this.haloColor.getAlpha() != 255) {
                    floatwidth = floatwidth + " float-color-opacity=\"" + this.haloColor.getAlpha() + "\"";
                }
            }
        }
        String spacing = "";
        if (this.letterSpacing > 0.0f) {
            spacing = " letter-spacing=\"" + this.letterSpacing + "\"";
        }
        String stickyS = this.sticky ? " sticky=\"true\" " : "";
        String wrap = this.autoTextWrap ? "\n        auto-wrap=\"true\" wrapping-width=\"" + this.wrappingWidth + "\" " : "";
        String newLine = this.honorNewline ? " honor-newline=\"true\" " : "";
        String mlSpacing = this.multilineSpacing > 0.0f ? " multiline-spacing=\"" + this.multilineSpacing + "\"" : "";
        Object mta = this.labelingHints.get(LabelingHints.KEY_MULTILINE_TEXT_ALIGN);
        String tAlign = "text-align:" + (LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER == mta ? "center" : (LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_RIGHT == mta ? "right" : "left")) + ";";
        String tdecoration = "";
        if (!this.textDecoration.equalsIgnoreCase(TEXT_DECORATION_NONE)) {
            tdecoration = "text-decoration:" + this.textDecoration.toLowerCase() + ";";
        }
        String fillopacity = "";
        if (this.color.getAlpha() != 255) {
            fillopacity = ";fill-opacity:" + this.color.getAlpha();
        }
        String fullstyle = "";
        String backcolor = "";
        String backopacity = "";
        if (this.background != null) {
            backcolor = "background:" + StyleUtils.getHexidecimalString(this.background);
            if (this.background.getAlpha() != 255) {
                backopacity = ";background-opacity: " + this.background.getAlpha();
            }
            fullstyle = "font-style:" + styleName + ";font-family:" + familyName + ";font-size:" + sizeStr + sizeUnit + minSizeStr + ";" + weight + tAlign + tdecoration + "fill:" + StyleUtils.getHexidecimalString(this.color) + fillopacity + ";" + backcolor + backopacity + "\"> Hello World!\n";
        } else {
            fullstyle = "font-style:" + styleName + ";font-family:" + familyName + ";font-size:" + sizeStr + sizeUnit + minSizeStr + ";" + weight + tAlign + tdecoration + "fill:" + StyleUtils.getHexidecimalString(this.color) + fillopacity + "\"> Hello World!\n";
        }
        String xmlDef = "<?xml version=\"1.0\" standalone=\"yes\"?>\n  <svg width=\"1in\" height=\"1in\" >\n  <desc></desc>\n";
        xmlDef = this.haloWidth.getValue() > 0.0 ? xmlDef + "    <g class=\"text\"" + embttf + floatwidth + stickyS + wrap + newLine + spacing + mlSpacing + " \n        style=\"" + fullstyle : xmlDef + "    <g class=\"text\"" + embttf + stickyS + wrap + newLine + spacing + " \n        style=\"" + fullstyle;
        xmlDef = xmlDef + this.getOrientedPointHintsXml();
        xmlDef = xmlDef + this.getPathTextHintsXml();
        xmlDef = xmlDef + "    </g>\n  </svg>\n";
        return xmlDef;
    }

    private String getOrientedPointHintsXml() {
        String h;
        Object halign = this.labelingHints.get(LabelingHints.KEY_OPOINT_HALIGN);
        Object valign = this.labelingHints.get(LabelingHints.KEY_OPOINT_VALIGN);
        if (halign == null && valign == null) {
            return "";
        }
        if (halign == null) {
            halign = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
        }
        if (valign == null) {
            valign = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
        }
        String string = halign == LabelingHints.VALUE_OPOINT_HALIGN_CENTER ? "center" : (h = halign == LabelingHints.VALUE_OPOINT_HALIGN_START ? "start" : "end");
        String v = valign == LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE ? "middle" : (valign == LabelingHints.VALUE_OPOINT_VALIGN_TOP ? "top" : (valign == LabelingHints.VALUE_OPOINT_VALIGN_BOTTOM ? "bottom" : "baseline"));
        String applySimplePoints = "";
        if (this.applyOHintTosimplepoints) {
            applySimplePoints = " apply-to-simple-points=\"true\"";
        }
        String res = "        <opoint halign=\"" + h + "\" valign=\"" + v + "\"" + applySimplePoints + "/>\n";
        return res;
    }

    private String getPathTextHintsXml() {
        String v = "";
        Object valign = this.labelingHints.get(LabelingHints.KEY_LINE_VALIGN);
        if (valign != null) {
            v = " valign=\"" + (valign == LabelingHints.VALUE_LINE_VALIGN_MIDDLE ? "middle" : (valign == LabelingHints.VALUE_LINE_VALIGN_TOP ? "top" : (valign == LabelingHints.VALUE_LINE_VALIGN_BOTTOM ? "bottom" : "baseline"))) + "\"";
        }
        String h = "";
        Object halign = this.labelingHints.get(LabelingHints.KEY_LINE_HALIGN);
        if (halign != null) {
            h = " halign=\"" + (halign == LabelingHints.VALUE_LINE_HALIGN_START ? "start" : (halign == LabelingHints.VALUE_LINE_HALIGN_END ? "end" : "center")) + "\"";
        }
        String spf = this.smartPathFollowing ? " smart-path-following=\"true\"" : "";
        String stf = this.straightLineLabeling ? " straight-line-labeling=\"true\"" : "";
        String res = "        <text-along-path" + h + v + spf + stf + "/>\n";
        return res;
    }

    public static void setDefaultFont(Font df) {
        defaultFont = df;
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public void setHonorNewline(boolean honorNewline) {
        this.honorNewline = honorNewline;
    }

    public boolean isHonorNewline() {
        return this.honorNewline;
    }

    public void setAutoTextWrap(boolean autoTextWrap) {
        this.autoTextWrap = autoTextWrap;
    }

    public boolean isAutoTextWrap() {
        return this.autoTextWrap;
    }

    public void setWrappingWidth(int wrappingWidth) {
        this.wrappingWidth = wrappingWidth;
    }

    public int getWrappingWidth() {
        return this.wrappingWidth;
    }

    public void setLabelingHints(LabelingHints labelingHints) {
        this.labelingHints = labelingHints;
    }

    public LabelingHints getLabelingHints() {
        return this.labelingHints;
    }

    public Object getLabelingHint(LabelingHints.Key hintKey) {
        return this.labelingHints.get(hintKey);
    }

    public void setLabelingHint(LabelingHints.Key hintKey, Object hintValue) {
        this.labelingHints.put(hintKey, hintValue);
    }

    public void setLetterSpacing(float letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    public float getLetterSpacing() {
        return this.letterSpacing;
    }

    public void setSmartPathFollowing(boolean smartPathFollowing) {
        this.smartPathFollowing = smartPathFollowing;
    }

    public boolean isSmartPathFollowing() {
        return this.smartPathFollowing;
    }

    public String getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(String decoration) {
        this.textDecoration = decoration == null || !decoration.equalsIgnoreCase(TEXT_DECORATION_UNDERLINE) && !decoration.equalsIgnoreCase(TEXT_DECORATION_LINETHROUGH) && !decoration.equalsIgnoreCase(TEXT_DECORATION_OVERLINE) ? TEXT_DECORATION_NONE : decoration.toUpperCase();
    }

    public float getMultilineSpacing() {
        return this.multilineSpacing;
    }

    public void setMultilineSpacing(float spacing) {
        this.multilineSpacing = spacing < 0.0f ? 0.0f : spacing;
    }

    public void setStraightLineLabeling(boolean param) {
        this.straightLineLabeling = param;
    }

    public boolean isStraightLineLabeling() {
        return this.straightLineLabeling;
    }

    public void setEmbeddedTTFont(String ttfFont) {
        this.embeddedTTFont = ttfFont != null && ttfFont.trim().length() == 0 ? null : ttfFont;
    }

    public String getEmbeddedTTFont() {
        return this.embeddedTTFont;
    }

    public Font deriveFont(float size) {
        if (size < 1.0f) {
            return this.getFont();
        }
        return this.getFont().deriveFont(size);
    }

    @Override
    public String[] getStyleDependency() {
        String[] deps = null;
        if (this.embeddedTTFont != null) {
            deps = new String[]{this.embeddedTTFont};
        }
        return deps;
    }

    public boolean getApplyOPointsHintsToSimplePoints() {
        return this.applyOHintTosimplepoints;
    }

    public void setApplyOPointsHintsToSimplePoints(boolean apply) {
        this.applyOHintTosimplepoints = apply;
    }
}

