/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;

public class MapScale
implements Serializable {
    static final long serialVersionUID = -4247221798280913249L;
    public static final String TYPE_MAPVIEWER = "MAPVIEWER_NATIVE";
    public static final String TYPE_RATIO = "RATIO";
    double nativeScale = Double.NEGATIVE_INFINITY;
    long denominator = 0L;

    public MapScale() {
    }

    public MapScale(String ratioForm) {
        this.setScale(ratioForm);
    }

    public void setScale(String ratioForm) {
        if (ratioForm == null || ratioForm.indexOf(":") < 0) {
            throw new IllegalArgumentException("invalid map scale.");
        }
        try {
            this.denominator = Long.parseLong(ratioForm.substring(ratioForm.indexOf(58)));
            this.nativeScale = Double.NEGATIVE_INFINITY;
        }
        catch (Exception e) {
            this.denominator = 0L;
        }
    }

    public void setNative(double nativeScale) {
        this.nativeScale = nativeScale;
    }

    public double getNative() {
        return this.nativeScale;
    }

    public long getRatioDenominator() {
        return this.denominator;
    }

    public String getScaleString() {
        return "1:" + this.denominator;
    }
}

