/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;

public class MapBounds
implements Serializable,
Cloneable {
    static final long serialVersionUID = 2154217047200597000L;
    public static final int TYPE_NOBOUNDS = 0;
    public static final int TYPE_RECT = 1;
    public static final int TYPE_CENTERSIZE = 2;
    public static final int TYPE_BOUNDINGTHEMES = 3;
    public static final int TYPE_CENTERSCALE = 4;
    protected int srid;
    protected int type = 0;
    protected double[] rect = null;
    protected boolean rectKeepAspectRatio = false;
    protected double[] centerSize = null;
    protected String[] boundingThemes = null;
    protected float boundingThemeBorderMargin = 0.05f;
    protected boolean boundingThemeKeepAspectRatio = true;
    protected double boundingThemeSizeHint = 0.0;
    protected long scale;

    public MapBounds() {
        this.type = 0;
        this.srid = 0;
    }

    public MapBounds(double minX, double minY, double maxX, double maxY, int srid) {
        this.type = 1;
        this.srid = srid;
        this.rect = new double[4];
        this.rect[0] = Math.min(minX, maxX);
        this.rect[1] = Math.min(minY, maxY);
        this.rect[2] = Math.max(maxX, minX);
        this.rect[3] = Math.max(maxY, minY);
    }

    public MapBounds(double minX, double minY, double maxX, double maxY) {
        this(minX, minY, maxX, maxY, 0);
    }

    public MapBounds(double minX, double minY, double maxX, double maxY, int srid, boolean preserveAspectRatio) {
        this(minX, minY, maxX, maxY, srid);
        this.rectKeepAspectRatio = preserveAspectRatio;
    }

    public MapBounds(double minX, double minY, double maxX, double maxY, boolean preserveAspectRatio) {
        this(minX, minY, maxX, maxY, 0, preserveAspectRatio);
    }

    public MapBounds(double centerX, double centerY, double size, int srid) {
        this.type = 2;
        this.srid = srid;
        this.centerSize = new double[3];
        this.centerSize[0] = centerX;
        this.centerSize[1] = centerY;
        this.centerSize[2] = size;
    }

    public MapBounds(double centerX, double centerY, double size) {
        this(centerX, centerY, size, 0);
    }

    public MapBounds(String[] boundingThemes, float margin, boolean keepAspectRatio, double sizeHint, int srid) {
        if (boundingThemes == null || boundingThemes.length == 0) {
            throw new IllegalArgumentException("invalid param for bounding themes.");
        }
        this.type = 3;
        this.srid = srid;
        this.boundingThemeBorderMargin = margin;
        this.boundingThemeKeepAspectRatio = keepAspectRatio;
        this.boundingThemeSizeHint = sizeHint;
        this.boundingThemes = new String[boundingThemes.length];
        for (int i = 0; i < boundingThemes.length; ++i) {
            this.boundingThemes[i] = boundingThemes[i];
        }
    }

    public MapBounds(String[] boundingThemes) {
        this(boundingThemes, 0.05f, true, 0.0, 0);
    }

    public MapBounds(String[] boundingThemes, float margin, boolean keepAspectRatio) {
        this(boundingThemes, 0.05f, keepAspectRatio, 0.0, 0);
    }

    public MapBounds(double centerX, double centerY, long scale, int srid) {
        this.type = 4;
        this.srid = srid;
        this.centerSize = new double[2];
        this.centerSize[0] = centerX;
        this.centerSize[1] = centerY;
        this.scale = scale;
    }

    public Object clone() {
        try {
            MapBounds mb = (MapBounds)super.clone();
            if (this.centerSize != null) {
                mb.centerSize = new double[this.centerSize.length];
                System.arraycopy(this.centerSize, 0, mb.centerSize, 0, this.centerSize.length);
            }
            if (this.boundingThemes != null) {
                mb.boundingThemes = new String[this.boundingThemes.length];
                System.arraycopy(this.boundingThemes, 0, mb.boundingThemes, 0, this.boundingThemes.length);
            }
            if (this.rect != null) {
                mb.rect = new double[this.rect.length];
                System.arraycopy(this.rect, 0, mb.rect, 0, this.rect.length);
            }
            return mb;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public int getType() {
        return this.type;
    }

    public int getSrid() {
        return this.srid;
    }

    public double[] getRect() {
        return this.rect;
    }

    public double[] getCenterSize() {
        return this.centerSize;
    }

    public String[] getBoundingThemes() {
        return this.boundingThemes;
    }

    public float getBoundingThemeBorderMargin() {
        return this.boundingThemeBorderMargin;
    }

    public boolean isBoundingThemeKeepAspectRatio() {
        return this.boundingThemeKeepAspectRatio;
    }

    public double getBoundingThemeSizeHint() {
        return this.boundingThemeSizeHint;
    }

    public long getScale() {
        return this.scale;
    }

    public boolean isUniverse() {
        return this.type == 0;
    }

    public boolean isKeepBoxAspectRatio() {
        return this.type == 1 && this.rectKeepAspectRatio;
    }
}

