/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.ui.FontManager;

public final class FontSizeOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
DocumentListener,
ItemListener {
    private JCheckBox checkBox_showFixedOnly;
    private JComboBox comboBox_fontFamily;
    private JComboBox comboBox_fontSize;
    private JTextField textField_sampleText;
    private JLabel label_normalFont;
    private JLabel label_boldFont;
    private JLabel label_italicFont;
    private JLabel label_boldItalicFont;
    private static String DEFAULT_FONT = "DialogInput";

    public FontSizeOptionsPanel() {
        this.setHelpID("f1_idedidesetfonts_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        FontSizeOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        FontSizeOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private FontSizeOptions findOptions(TraversableContext tc) {
        FontSizeOptions options = FontSizeOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        FontSizeOptions options = this.findOptions(tc);
        FontSizeOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(FontSizeOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        String fontFamily = options.getFontFamily();
        int fontSize = options.getFontSize();
        properties.setBaseFont(fontFamily, fontSize);
    }

    void loadSettingsFrom(FontSizeOptions options) {
        String fontFamily = options.getFontFamily();
        int fontSize = options.getFontSize();
        boolean showOnlyFixedWidth = options.getShowOnlyFixedWidth();
        this.updateFontCombo(showOnlyFixedWidth);
        this.setSelectedFontFamily(fontFamily);
        this.comboBox_fontSize.setSelectedItem(fontSize);
        this.checkBox_showFixedOnly.setSelected(showOnlyFixedWidth);
    }

    void saveSettingsTo(FontSizeOptions options) {
        String fontFamily = this.comboBox_fontFamily.getSelectedItem().toString();
        Integer fontSizeInteger = (Integer)this.comboBox_fontSize.getSelectedItem();
        int fontSize = fontSizeInteger;
        boolean showOnlyFixedWidth = this.checkBox_showFixedOnly.isSelected();
        options.setFontFamily(fontFamily);
        options.setFontSize(fontSize);
        options.setShowOnlyFixedWidth(showOnlyFixedWidth);
    }

    private void initializeComponent() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        String fontFamilyText = OptionsArb.getString(42);
        JLabel label_fontFamily = new JLabel();
        Object[] families = new String[]{DEFAULT_FONT};
        NonNullableComboBoxModel fontModel = new NonNullableComboBoxModel(families);
        this.comboBox_fontFamily = new JComboBox(fontModel);
        this.comboBox_fontFamily.setEditable(false);
        this.comboBox_fontFamily.setSelectedItem(families[0]);
        this.comboBox_fontFamily.addItemListener(this);
        ResourceUtils.resLabel((JLabel)label_fontFamily, (Component)this.comboBox_fontFamily, (String)fontFamilyText);
        String fontSizeText = OptionsArb.getString(43);
        JLabel label_fontSize = new JLabel();
        Object[] sizes = new Integer[]{7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
        NonNullableComboBoxModel sizeModel = new NonNullableComboBoxModel(sizes);
        this.comboBox_fontSize = new JComboBox(sizeModel);
        this.comboBox_fontSize.setEditable(false);
        this.comboBox_fontSize.setSelectedItem(sizes[0]);
        this.comboBox_fontSize.addItemListener(this);
        ResourceUtils.resLabel((JLabel)label_fontSize, (Component)this.comboBox_fontSize, (String)fontSizeText);
        String sampleText = OptionsArb.getString(44);
        String initialSampleText = OptionsArb.getString(45);
        JLabel label_sampleText = new JLabel();
        this.textField_sampleText = new JTextField(initialSampleText);
        Document fieldDocument = this.textField_sampleText.getDocument();
        fieldDocument.addDocumentListener(this);
        ResourceUtils.resLabel((JLabel)label_sampleText, (Component)this.textField_sampleText, (String)sampleText);
        String renderedText = OptionsArb.getString(46);
        JLabel label_renderedText = new JLabel(renderedText, 2);
        this.label_normalFont = new JLabel(initialSampleText);
        this.label_boldFont = new JLabel(initialSampleText);
        this.label_italicFont = new JLabel(initialSampleText);
        this.label_boldItalicFont = new JLabel(initialSampleText);
        Box sampleBox = Box.createVerticalBox();
        sampleBox.add(this.label_normalFont);
        sampleBox.add(this.label_boldFont);
        sampleBox.add(this.label_italicFont);
        sampleBox.add(this.label_boldItalicFont);
        JPanel samplePanel = new JPanel(new BorderLayout());
        samplePanel.add((Component)sampleBox, "Center");
        JScrollPane sampleScroller = new JScrollPane(samplePanel);
        String fixedOnlyText = FontManager.isFontInfoComplete() ? OptionsArb.getString(48) : OptionsArb.getString(47);
        this.checkBox_showFixedOnly = new JCheckBox();
        this.checkBox_showFixedOnly.setSelected(false);
        this.checkBox_showFixedOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = FontSizeOptionsPanel.this.checkBox_showFixedOnly.isSelected();
                FontSizeOptionsPanel.this.updateFontCombo(isSelected);
            }
        });
        ResourceUtils.resButton((AbstractButton)this.checkBox_showFixedOnly, (String)fixedOnlyText);
        Insets defaultInsets = new Insets(0, 0, 5, 5);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_fontFamily, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.comboBox_fontFamily, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkBox_showFixedOnly, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_fontSize, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.comboBox_fontSize, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_sampleText, constraints);
        constraints = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.textField_sampleText, constraints);
        constraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0);
        this.add(label_renderedText, constraints);
        constraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 1, defaultInsets, 0, 0);
        this.add(sampleScroller, constraints);
    }

    private void setSelectedFontFamily(String fontFamily) {
        ComboBoxModel model = this.comboBox_fontFamily.getModel();
        int numItems = model.getSize();
        for (int i = 0; i < numItems; ++i) {
            Object element = model.getElementAt(i);
            if (!element.equals(fontFamily)) continue;
            this.comboBox_fontFamily.setSelectedItem(fontFamily);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.updateSampleLabelText();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.updateSampleLabelText();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    private void updateSampleLabelText() {
        String labelText = this.textField_sampleText.getText();
        this.label_normalFont.setText(labelText);
        this.label_boldFont.setText(labelText);
        this.label_italicFont.setText(labelText);
        this.label_boldItalicFont.setText(labelText);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        int selected;
        Object source = event.getSource();
        if ((source == this.comboBox_fontFamily || source == this.comboBox_fontSize) && (selected = event.getStateChange()) == 1) {
            this.updateSampleFonts();
        }
    }

    private void updateFontCombo(boolean isSelected) {
        Object[] families = isSelected ? FontManager.getFixedWidthFamilies() : FontManager.getAllFontFamilies();
        NonNullableComboBoxModel fontModel = new NonNullableComboBoxModel(families);
        Object selected = this.comboBox_fontFamily.getSelectedItem();
        this.comboBox_fontFamily.setModel(fontModel);
        this.setSelectedFontFamily(DEFAULT_FONT);
        this.setSelectedFontFamily((String)selected);
    }

    private void updateSampleFonts() {
        String fontFamily = this.comboBox_fontFamily.getSelectedItem().toString();
        Integer fontSizeInteger = (Integer)this.comboBox_fontSize.getSelectedItem();
        int fontSize = fontSizeInteger;
        Font normalFont = new Font(fontFamily, 0, fontSize);
        Font boldFont = normalFont.deriveFont(1);
        Font italicFont = normalFont.deriveFont(2);
        Font boldItalicFont = normalFont.deriveFont(3);
        this.label_normalFont.setFont(normalFont);
        this.label_boldFont.setFont(boldFont);
        this.label_italicFont.setFont(italicFont);
        this.label_boldItalicFont.setFont(boldItalicFont);
    }
}

