/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.Caret;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.BreadcrumbsPlugin;
import oracle.ide.ceditor.CEditor;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeDestination;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorConstants;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.ceditor.CodeEditorHelpableProvider;
import oracle.ide.ceditor.CodeEditorHook;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.ceditor.keymap.EditorKeyStrokes;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.ceditor.options.GutterOptionsPanel;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.EditorSelectionWrap;
import oracle.javatools.editor.Selection;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;

public class CodeEditorController
implements Controller,
CodeMenuConstants,
ContextMenuListener {
    private static final int TOGGLE_LINE_NUMBER_CMD_ID = Ide.findOrCreateCmdID((String)"ceditor.ToggleLineNumbers");
    private static final int PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.Preferences");
    private static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.ToggleToolbar");
    private static final int TOGGLE_BREADCRUMBS_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.ToggleBreadcrumbs");
    private static final int FOCUS_BREADCRUMBS_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.FocusBreadcrumbs");
    private static final int TOGGLE_WHITESPACE_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.ToggleWhitespace");
    private static final int SHOW_DOC_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.ShowDoc");
    private static final int MULTI_SELECT_CLEAR_ID = Ide.findOrCreateCmdID((String)"CodeEditor.MultiSelectClear");
    private static final int MULTI_SELECT_ABOVE_ID = Ide.findOrCreateCmdID((String)"CodeEditor.MultiSelectAbove");
    private static final int MULTI_SELECT_BELOW_ID = Ide.findOrCreateCmdID((String)"CodeEditor.MultiSelectBelow");
    private static final int NAVIGATE_HIERARCHY_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.NavigateHierarchy");
    private static final int NAVIGATE_HIERARCHY_UP_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.NavigateHierarchyUp");
    private static final int NAVIGATE_HIERARCHY_DOWN_CMD_ID = Ide.findOrCreateCmdID((String)"CodeEditor.NavigateHierarchyDown");
    private static int TOGGLE_COMMENTS_CMD_ID;
    private static int BLOCK_INDENT_CMD_ID;
    private static int BLOCK_OUTDENT_CMD_ID;
    private static int TRIM_WHITESPACE_CMD_ID;
    private static int JOIN_LINE_CMD_ID;
    private static int DELETE_LINE_CMD_ID;
    private static int SORT_LINES_CMD_ID;
    private static int TABS_TO_SPACES_ID;
    private static int SPACES_TO_TABS_CMD_ID;
    private static int TO_LOWER_CMD_ID;
    private static int TO_UPPER_CMD_ID;
    private static int MOVE_UP_CMD_ID;
    private static int MOVE_DOWN_CMD_ID;
    @Deprecated
    public static final int EDIT_SELECTED_ONLY_CMD_ID;
    @Deprecated
    public static final String CATEGORY_SOURCE_MENU;
    @Deprecated
    public static final int UNDO_WRAPPER_MSG;
    private IdeAction ideCutAction;
    private IdeAction ideCopyAction;
    private final Listener _listener = new Listener();
    private static final int UPDATE_INTERVAL = 250;
    private final Timer _delayedUpdateTimer = new Timer(250, this._listener);
    private static boolean editorMenuListenerAdded;
    private static boolean gutterMenuListenerAdded;
    static CodeEditorController _singleton;

    private void initializeActions() {
        if (this.ideCutAction == null) {
            this.ideCutAction = IdeAction.find((int)17);
            this.ideCopyAction = IdeAction.find((int)18);
        }
    }

    public static synchronized CodeEditorController getDefaultController() {
        if (_singleton == null) {
            new CodeEditorController();
        }
        return _singleton;
    }

    static synchronized void disposeDefaultController() {
        if (_singleton != null) {
            _singleton.dispose();
            _singleton = null;
        }
    }

    private CodeEditorController() {
        ContextMenu menu;
        ContextMenu menu2;
        EditorManager editorManager;
        if (_singleton != null) {
            return;
        }
        _singleton = this;
        if (!editorMenuListenerAdded && (editorManager = EditorManager.getEditorManager()) != null && (menu2 = editorManager.getContextMenu()) != null) {
            menu2.addContextMenuListener((ContextMenuListener)this);
            editorMenuListenerAdded = true;
        }
        if (!gutterMenuListenerAdded && (menu = CodeEditorGutter.getGutterContextMenu()) != null) {
            menu.addContextMenuListener((ContextMenuListener)this);
            gutterMenuListenerAdded = true;
        }
        this.initializeActions();
        this.initializeSourceActions();
    }

    void dispose() {
        ContextMenu menu;
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null && (menu = editorManager.getContextMenu()) != null) {
            menu.removeContextMenuListener((ContextMenuListener)this);
        }
        if ((menu = CodeEditorGutter.getGutterContextMenu()) != null) {
            menu.removeContextMenuListener((ContextMenuListener)this);
        }
    }

    public void checkCommandsAfterNavigation(Context context) {
        this._delayedUpdateTimer.stop();
        this._delayedUpdateTimer.start();
    }

    public static final CodeEditor getCodeEditorFromContext(Context context) {
        CodeEditor codeEditor = null;
        View view = context.getView();
        if (view != null) {
            if (view instanceof CodeEditor) {
                codeEditor = (CodeEditor)view;
            } else if (view instanceof CodeEditorGutterView) {
                codeEditor = (CodeEditor)view.owner();
            }
        }
        return codeEditor;
    }

    public static final BasicEditorPane getEditorPaneFromContext(Context context) {
        BasicEditorPane ret = null;
        CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            ret = codeEditor.getFocusedEditorPane();
        } else if (context.getView() instanceof BasicEditorPaneContainer) {
            ret = ((BasicEditorPaneContainer)context.getView()).getFocusedEditorPane();
        }
        return ret;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 22) {
            action.setEnabled(true);
        } else if (cmdId == 17) {
            boolean canDo = this.whenCut(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == 18) {
            boolean canDo = this.whenCopy(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == 19) {
            boolean canDo = this.whenPaste(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == 20) {
            boolean canDo = this.whenDelete(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == 82) {
            boolean canDo = this.whenDuplicateSelection(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == MULTI_SELECT_CLEAR_ID) {
            boolean canDo = this.whenMultiSelectClear(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == MULTI_SELECT_ABOVE_ID) {
            boolean canDo = this.whenMultiSelectAbove(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == MULTI_SELECT_BELOW_ID) {
            boolean canDo = this.whenMultiSelectBelow(context, false);
            action.setEnabled(canDo);
        } else if (cmdId == TOGGLE_COMMENTS_CMD_ID || cmdId == BLOCK_INDENT_CMD_ID || cmdId == BLOCK_OUTDENT_CMD_ID || cmdId == JOIN_LINE_CMD_ID || cmdId == DELETE_LINE_CMD_ID || cmdId == SPACES_TO_TABS_CMD_ID || cmdId == TABS_TO_SPACES_ID) {
            boolean canDo = true;
            action.setEnabled(canDo);
        } else if (cmdId == TOGGLE_TOOLBAR_CMD_ID) {
            Preferences preferences = Preferences.getPreferences();
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)preferences);
            boolean showToolbar = editorOptions.getShowToolbar();
            action.setState(showToolbar);
        } else if (cmdId == TOGGLE_BREADCRUMBS_CMD_ID) {
            Preferences preferences = Preferences.getPreferences();
            action.setState(DisplayOptions.getInstance((PropertyStorage)preferences).getShowBreadcrumbs());
        } else if (cmdId == FOCUS_BREADCRUMBS_CMD_ID) {
            BasicEditorPane editor;
            BreadcrumbsPlugin breadcrumbs;
            CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
            boolean state = false;
            if (codeEditor != null && (breadcrumbs = (BreadcrumbsPlugin)(editor = codeEditor.getFocusedEditorPane()).getProperty("BREADCRUMB_PLUGIN_PROPERTY")) != null && breadcrumbs.breadcrumbs.isShowing()) {
                state = true;
            }
            action.setState(state);
        } else if (cmdId == TOGGLE_WHITESPACE_CMD_ID) {
            Preferences preferences = Preferences.getPreferences();
            action.setState(DisplayOptions.getInstance((PropertyStorage)preferences).getShowWhitespaceChars());
        } else if (cmdId == CodeEditorConstants.EDIT_SELECTED_ONLY_CMD_ID) {
            CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
            if (codeEditor != null) {
                BasicEditorPane editor = codeEditor.getFocusedEditorPane();
                int startLimit = editor.getValidOffsetStart();
                int endLimit = editor.getValidOffsetEnd();
                action.setState(startLimit != -1 && endLimit != -1);
            }
        } else if (cmdId == 81) {
            boolean canDo = false;
            BasicEditorPane editorComponent = CodeEditorController.getEditorPaneFromContext(context);
            if (editorComponent != null && editorComponent.getCaret() instanceof BasicCaret) {
                canDo = EditorSelectionColumns.isEditorFixedWidthFont((BasicEditorPane)editorComponent);
                BasicCaret caret = (BasicCaret)editorComponent.getCaret();
                action.setState(caret.getEditorSelection() instanceof EditorSelectionColumns);
            }
            action.setEnabled(canDo);
        } else if (cmdId == TRIM_WHITESPACE_CMD_ID) {
            action.setEnabled(this.whenTrimWhitespace(context, false));
        } else if (cmdId == SORT_LINES_CMD_ID) {
            BasicEditorPane editor = CodeEditorController.getEditorPaneFromContext(context);
            if (editor != null) {
                int endLine;
                int startLine = editor.getLineFromOffset(editor.getSelectionStart());
                action.setEnabled(startLine != (endLine = editor.getLineFromOffset(editor.getSelectionEnd())));
            } else {
                action.setEnabled(false);
            }
        } else if (cmdId == TO_UPPER_CMD_ID || cmdId == TO_LOWER_CMD_ID) {
            BasicEditorPane editor = CodeEditorController.getEditorPaneFromContext(context);
            if (editor != null) {
                action.setEnabled(editor.getSelectionStart() != editor.getSelectionEnd());
            } else {
                action.setEnabled(false);
            }
        } else if (cmdId == MOVE_UP_CMD_ID) {
            BasicEditorPane editor = CodeEditorController.getEditorPaneFromContext(context);
            if (editor != null) {
                int selStart = Math.min(editor.getSelectionStart(), editor.getSelectionEnd());
                int line = editor.getLineFromOffset(selStart);
                action.setEnabled(line > 0);
            } else {
                action.setEnabled(false);
            }
        } else if (cmdId == MOVE_DOWN_CMD_ID) {
            BasicEditorPane editor = CodeEditorController.getEditorPaneFromContext(context);
            if (editor != null) {
                int selStart = Math.min(editor.getSelectionStart(), editor.getSelectionEnd());
                int line = editor.getLineFromOffset(selStart);
                action.setEnabled(line < editor.getLineCount() - 1);
            } else {
                action.setEnabled(false);
            }
        } else if (cmdId == SHOW_DOC_CMD_ID) {
            CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
            if (codeEditor != null) {
                Node node = context.getNode();
                String filename = context.getNode().getURL().getFile();
                int dotIndex = filename.lastIndexOf(".");
                if (dotIndex > -1 && dotIndex < filename.length()) {
                    String extension = filename.substring(dotIndex + 1);
                    Collection<CodeEditorHelpableProvider> helpableProviders = CodeEditorHook.get().codeEditorHelpableProviders(extension, node);
                    for (CodeEditorHelpableProvider helpableProvider : helpableProviders) {
                        if (!helpableProvider.hasHelpInfo(codeEditor, codeEditor.getCaretPosition())) continue;
                        action.setEnabled(true);
                        return true;
                    }
                }
                action.setEnabled(false);
            } else {
                action.setEnabled(false);
            }
        } else if (cmdId == NAVIGATE_HIERARCHY_UP_CMD_ID || cmdId == NAVIGATE_HIERARCHY_DOWN_CMD_ID || cmdId == NAVIGATE_HIERARCHY_CMD_ID) {
            CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
            action.setEnabled(codeEditor != null);
        } else {
            return false;
        }
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_TOOLBAR_CMD_ID) {
            EditorOptions editorOptions;
            Preferences preferences = Preferences.getPreferences();
            boolean showToolbar = (editorOptions = EditorOptions.getInstance((PropertyStorage)preferences)).getShowToolbar();
            editorOptions.setShowToolbar(!showToolbar);
            return true;
        }
        if (cmdId == TOGGLE_BREADCRUMBS_CMD_ID) {
            DisplayOptions displayOptions;
            Preferences preferences = Preferences.getPreferences();
            displayOptions.setShowBreadcrumbs(!(displayOptions = DisplayOptions.getInstance((PropertyStorage)preferences)).getShowBreadcrumbs());
            return true;
        }
        if (cmdId == FOCUS_BREADCRUMBS_CMD_ID) {
            BreadcrumbsModel model;
            BasicEditorPane editor;
            BreadcrumbsPlugin breadcrumbs;
            CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
            if (codeEditor != null && (breadcrumbs = (BreadcrumbsPlugin)(editor = codeEditor.getFocusedEditorPane()).getProperty("BREADCRUMB_PLUGIN_PROPERTY")) != null && breadcrumbs.breadcrumbs.isShowing() && (model = breadcrumbs.breadcrumbs.getModel()) != null) {
                breadcrumbs.breadcrumbs.setFocusedBreadcrumb(model.getBreadcrumbCount() - 1);
            }
            return true;
        }
        if (cmdId == TOGGLE_WHITESPACE_CMD_ID) {
            Preferences preferences = Preferences.getPreferences();
            DisplayOptions displayOptions = DisplayOptions.getInstance((PropertyStorage)preferences);
            boolean showWhitespaceChars = !displayOptions.getShowWhitespaceChars();
            displayOptions.setShowWhitespaceChars(showWhitespaceChars);
            EditorProperties properties = EditorProperties.getProperties();
            properties.putBooleanProperty("show-whitespace-chars", showWhitespaceChars);
            return true;
        }
        if (action.getCommandId() == CodeEditorConstants.EDIT_SELECTED_ONLY_CMD_ID) {
            for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                if (!(editor instanceof CodeEditor)) continue;
                CodeEditor ce = (CodeEditor)editor;
                ce.setLimitView(action.getState());
            }
            return true;
        }
        if (action.getCommandId() == 81) {
            this.whenBlockSelection(CodeEditorController.getCodeEditorFromContext(context), action.getState());
            return true;
        }
        CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
        if (codeEditor == null && (cmdId == TOGGLE_COMMENTS_CMD_ID || cmdId == BLOCK_INDENT_CMD_ID || cmdId == BLOCK_OUTDENT_CMD_ID)) {
            return true;
        }
        BasicEditorPane editorComponent = CodeEditorController.getEditorPaneFromContext(context);
        if (editorComponent == null) {
            return true;
        }
        if (!(cmdId != TOGGLE_COMMENTS_CMD_ID && cmdId != BLOCK_INDENT_CMD_ID && cmdId != BLOCK_OUTDENT_CMD_ID || editorComponent.isEditable())) {
            editorComponent.makeEditable();
        }
        if (cmdId == 17) {
            this.whenCut(context, true);
        } else if (cmdId == 18) {
            this.whenCopy(context, true);
        } else if (cmdId == 19) {
            this.whenPaste(context, true);
        } else if (cmdId == 82) {
            this.whenDuplicateSelection(context, true);
        } else if (cmdId == 20) {
            this.whenDelete(context, true);
        } else if (cmdId == 22) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("select-all");
        } else if (cmdId == MULTI_SELECT_CLEAR_ID) {
            this.whenMultiSelectClear(context, true);
        } else if (cmdId == MULTI_SELECT_ABOVE_ID) {
            this.whenMultiSelectAbove(context, true);
        } else if (cmdId == MULTI_SELECT_BELOW_ID) {
            this.whenMultiSelectBelow(context, true);
        } else if (cmdId == TOGGLE_COMMENTS_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("toggle-java-comments");
        } else if (cmdId == BLOCK_INDENT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("block-indent");
        } else if (cmdId == BLOCK_OUTDENT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("block-outdent");
        } else if (cmdId == JOIN_LINE_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("join-line");
        } else if (cmdId == DELETE_LINE_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("delete-line");
        } else if (cmdId == SORT_LINES_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("sort-selected-lines");
        } else if (cmdId == TO_LOWER_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("downcase-selection");
        } else if (cmdId == TO_UPPER_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("upcase-selection");
        } else if (cmdId == SPACES_TO_TABS_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("tabify");
        } else if (cmdId == TABS_TO_SPACES_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("untabify");
        } else if (cmdId == MOVE_UP_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("move-up");
        } else if (cmdId == MOVE_DOWN_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("move-down");
        } else if (cmdId == TOGGLE_LINE_NUMBER_CMD_ID) {
            DisplayOptions options;
            boolean showing = (options = DisplayOptions.getInstance((PropertyStorage)Preferences.getPreferences())).getShowLineNumbers();
            options.setShowLineNumbers(!showing);
            GutterOptionsPanel.applyOptions(options);
            editorComponent.requestFocus();
        } else if (cmdId == PREFERENCES_CMD_ID) {
            View view = context.getView();
            String[] path = view instanceof CodeEditorGutterView ? new String[]{CEditor.get("LABEL_EDITOR_OPTIONS"), CEditor.get("LABEL_GUTTER_OPTIONS")} : new String[]{CEditor.get("LABEL_EDITOR_OPTIONS")};
            IdeSettings settings = Ide.getSettings();
            settings.showDialog((Frame)Ide.getMainWindow(), path);
            editorComponent.requestFocus();
        } else if (cmdId == TRIM_WHITESPACE_CMD_ID) {
            this.whenTrimWhitespace(context, true);
        } else if (cmdId == SHOW_DOC_CMD_ID) {
            if (codeEditor != null) {
                Node node = context.getNode();
                String filename = context.getNode().getURL().getFile();
                int dotIndex = filename.lastIndexOf(".");
                if (dotIndex > -1 && dotIndex < filename.length()) {
                    String extension = filename.substring(dotIndex + 1);
                    Collection<CodeEditorHelpableProvider> helpableProviders = CodeEditorHook.get().codeEditorHelpableProviders(extension, node);
                    for (CodeEditorHelpableProvider helpableProvider : helpableProviders) {
                        HelpInfo helpInfo = helpableProvider.getHelpInfo(codeEditor, codeEditor.getCaretPosition());
                        if (helpInfo == null) continue;
                        HelpSystem.getHelpSystem().showHelp(helpInfo);
                        break;
                    }
                }
            }
        } else if (cmdId == NAVIGATE_HIERARCHY_UP_CMD_ID || cmdId == NAVIGATE_HIERARCHY_DOWN_CMD_ID) {
            if (codeEditor != null) {
                int line = codeEditor.getCaretLine();
                CodeDestination.Direction dir = cmdId == NAVIGATE_HIERARCHY_UP_CMD_ID ? CodeDestination.Direction.UP : CodeDestination.Direction.DOWN;
                codeEditor.getGutter().getDestinationController().navigate(line, dir);
            }
        } else if (cmdId == NAVIGATE_HIERARCHY_CMD_ID) {
            if (codeEditor != null) {
                codeEditor.getGutter().getDestinationController().showDestinationPopup();
            }
        } else {
            return false;
        }
        return true;
    }

    public void menuWillShow(ContextMenu popup) {
        if (popup.getContext().getView() instanceof CodeEditor) {
            this.addSourceSubMenu(popup);
        }
    }

    private void addSourceSubMenu(final ContextMenu popup) {
        final Context context = popup.getContext();
        View view = context.getView();
        float menuSection = view instanceof Editor ? CodeMenuConstants.SECTION_SOURCE_CTXT_MENU : CodeMenuConstants.SECTION_SOURCE_CTXT_MENU_NON_EDITOR;
        String sourceMenuLabel = CEditorArb.getString(6);
        String menuLabel = StringUtils.stripMnemonic((String)sourceMenuLabel);
        int mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)sourceMenuLabel);
        final JMenu sourceMenu = popup.createSubMenu(menuLabel, Integer.valueOf(mnemonicKeyCode), Float.MAX_VALUE, menuSection);
        popup.add((Component)sourceMenu, menuSection);
        sourceMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                sourceMenu.removeMenuListener(this);
                CodeEditorController.this.createContextSubmenu(context, sourceMenu);
                popup.removeDuplicateActions();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private void createContextSubmenu(Context context, JMenu menu) {
        JMenuBar menubar = Ide.getMainWindow().getJMenuBar();
        String sourceMenuLabel = StringUtils.stripMnemonic((String)CEditorArb.getString(6));
        JMenu sourceMenu = null;
        for (int i = 0; i < menubar.getMenuCount(); ++i) {
            JMenu aMenu = menubar.getMenu(i);
            if (!aMenu.getText().equals(sourceMenuLabel)) continue;
            sourceMenu = aMenu;
            Ide.getMenubar().sortContainer((Container)sourceMenu);
            break;
        }
        if (sourceMenu != null) {
            this.copyMenu(context, sourceMenu, menu);
        }
    }

    private void copyMenu(Context context, JMenu sourceMenu, JMenu destMenu) {
        Menubar ideMenuManager = Ide.getMenubar();
        float section = 0.0f;
        for (Component menuComponent : sourceMenu.getMenuComponents()) {
            if (menuComponent instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)menuComponent;
                IdeAction action = (IdeAction)menuItem.getAction();
                if (action != null) {
                    action.updateAction(context);
                    if (!action.isEnabled()) continue;
                    JMenuItem newMenuItem = ideMenuManager.createMenuItem((ToggleAction)action);
                    ideMenuManager.add((Component)newMenuItem, destMenu, section);
                    continue;
                }
                if (!(menuItem instanceof JMenu)) continue;
                JMenu newMenu = ideMenuManager.createSubMenu(menuItem.getText(), Integer.valueOf(menuItem.getMnemonic()));
                ideMenuManager.add((Component)newMenu, destMenu, section);
                this.copyMenu(context, (JMenu)menuItem, newMenu);
                continue;
            }
            section += 1.0f;
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private static void updateActionName(IdeAction action, String name) {
        int mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        action.putValue("Name", (Object)StringUtils.stripMnemonic((String)name));
        action.putValue("MnemonicKey", (Object)mnemonic);
    }

    private void initializeSourceActions() {
        KeymapManager keymapManager = KeymapManager.getInstance();
        EditorKeyStrokes editorContext = keymapManager.getEditorKeyStrokes();
        TOGGLE_COMMENTS_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "toggle-java-comments", 25);
        BLOCK_INDENT_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "block-indent", 26);
        BLOCK_OUTDENT_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "block-outdent", 27);
        TRIM_WHITESPACE_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "trim-whitespace", 59);
        JOIN_LINE_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "join-line", -1);
        DELETE_LINE_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "delete-line", -1);
        SORT_LINES_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "sort-selected-lines", -1);
        TO_UPPER_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "upcase-selection", -1);
        TO_LOWER_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "downcase-selection", -1);
        SPACES_TO_TABS_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "tabify", -1);
        TABS_TO_SPACES_ID = CodeEditorController.initializeSourceAction(editorContext, "untabify", -1);
        MOVE_UP_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "move-up", -1);
        MOVE_DOWN_CMD_ID = CodeEditorController.initializeSourceAction(editorContext, "move-down", -1);
    }

    private static int initializeSourceAction(EditorKeyStrokes editorContext, String actionName, int arbKey) {
        IdeAction action = editorContext.lookupAction(actionName);
        int ret = action.getCommandId();
        if (arbKey != -1) {
            CodeEditorController.updateActionName(action, CEditorArb.getString(arbKey));
        }
        return ret;
    }

    private boolean whenCut(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == editorPane && editorPane.canCopy() && editorPane.isEnabled()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("cut-to-clipboard");
            }
        }
        return ret;
    }

    private boolean whenCopy(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == editorPane && editorPane.canCopy()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("copy-to-clipboard");
            }
        }
        return ret;
    }

    private boolean whenPaste(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == editorPane && editorPane.isValidClipboardContent()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("paste-from-clipboard");
            }
        }
        return ret;
    }

    private boolean whenDelete(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && editorPane.isEditable()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("delete-next");
            }
        }
        return ret;
    }

    private boolean whenDuplicateSelection(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && editorPane.isEditable()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("duplicate-selection");
            }
        }
        return ret;
    }

    private boolean whenTrimWhitespace(Context context, boolean doit) {
        boolean ret = false;
        BasicEditorPane editorPane = CodeEditorController.getEditorPaneFromContext(context);
        if (editorPane != null && editorPane.isEditable()) {
            ret = true;
            if (doit) {
                editorPane.requestFocus();
                editorPane.invokeAction("trim-whitespace");
            }
        }
        return ret;
    }

    private void whenBlockSelection(CodeEditor editor, boolean shouldBlock) {
        BasicEditorPane editorPane = editor.getFocusedEditorPane();
        if (editorPane.getCaret() instanceof BasicCaret) {
            EditorSelectionColumns editorSelection;
            BasicCaret caret = (BasicCaret)editorPane.getCaret();
            caret.getEditorSelection().deinstall();
            if (shouldBlock) {
                editorSelection = new EditorSelectionColumns();
                editorPane.putIntegerProperty("caret-editor-selection-type", 21);
            } else {
                editorSelection = new EditorSelectionWrap();
                editorPane.putIntegerProperty("caret-editor-selection-type", 20);
            }
            caret.setEditorSelection((EditorSelection)editorSelection);
            editorSelection.install(editorPane);
        }
    }

    private boolean whenMultiSelectClear(Context context, boolean doIt) {
        boolean hasMultiSelection;
        CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
        if (codeEditor == null) {
            return false;
        }
        BasicEditorPane editorPane = codeEditor.getFocusedEditorPane();
        boolean bl = hasMultiSelection = !editorPane.getMultiSelections().isEmpty();
        if (doIt && hasMultiSelection) {
            editorPane.clearMultiSelections();
        }
        return !editorPane.getMultiSelections().isEmpty();
    }

    private boolean whenMultiSelectAbove(Context context, boolean doIt) {
        CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
        if (codeEditor == null) {
            return false;
        }
        BasicEditorPane editorPane = codeEditor.getFocusedEditorPane();
        Caret caret = editorPane.getCaret();
        int firstPos = caret.getDot();
        for (Selection sel : editorPane.getMultiSelections()) {
            firstPos = Math.min(firstPos, sel.getDot());
        }
        int line = editorPane.getLineFromOffset(firstPos);
        if (line < 1) {
            return false;
        }
        if (doIt) {
            int column = caret.getDot() - editorPane.getLineStartOffset(editorPane.getLineFromOffset(caret.getDot()));
            int lineAboveStart = editorPane.getLineStartOffset(line - 1);
            int lineAboveEnd = editorPane.getLineEndOffset(line - 1) - 1;
            int offset = Math.min(lineAboveStart + column, lineAboveEnd);
            editorPane.addMultiSelection(new Selection(offset, offset));
        }
        return true;
    }

    private boolean whenMultiSelectBelow(Context context, boolean doIt) {
        CodeEditor codeEditor = CodeEditorController.getCodeEditorFromContext(context);
        if (codeEditor == null) {
            return false;
        }
        BasicEditorPane editorPane = codeEditor.getFocusedEditorPane();
        Caret caret = editorPane.getCaret();
        int lastPos = caret.getDot();
        for (Selection sel : editorPane.getMultiSelections()) {
            lastPos = Math.max(lastPos, sel.getDot());
        }
        int line = editorPane.getLineFromOffset(lastPos);
        if (line >= editorPane.getLineCount() - 1) {
            return false;
        }
        if (doIt) {
            int column = caret.getDot() - editorPane.getLineStartOffset(editorPane.getLineFromOffset(caret.getDot()));
            int lineBelowStart = editorPane.getLineStartOffset(line + 1);
            int lineBelowEnd = editorPane.getLineEndOffset(line + 1) - 1;
            int offset = Math.min(lineBelowStart + column, lineBelowEnd);
            editorPane.addMultiSelection(new Selection(offset, offset));
        }
        return true;
    }

    static {
        EDIT_SELECTED_ONLY_CMD_ID = CodeEditorConstants.EDIT_SELECTED_ONLY_CMD_ID;
        CATEGORY_SOURCE_MENU = CodeEditorConstants.CATEGORY_SOURCE_MENU;
        UNDO_WRAPPER_MSG = CodeEditorConstants.UNDO_WRAPPER_MSG;
        editorMenuListenerAdded = false;
        gutterMenuListenerAdded = false;
        _singleton = null;
    }

    class Listener
    implements ActionListener {
        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeEditorController.this._delayedUpdateTimer.stop();
            CodeEditorController.this.ideCopyAction.updateAction();
            CodeEditorController.this.ideCutAction.updateAction();
        }
    }
}

