/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.CustomNode;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.ObjectElement;
import oracle.dbtools.raptor.navigator.db.ObjectTypeFolder;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.ChildFolder;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.SchemaObject;

public final class DBObject
extends BasicDBObject {
    private static Logger LOGGER = Logger.getLogger(DBObject.class.getName());
    public static final String DBOBJECT_KEY = "DB_OBJECT";
    public static final String OBJECT_NAME_KEY = "OBJECT_NAME";
    public static final String OBJECT_TYPE_KEY = "OBJECT_TYPE";
    public static final String OBJECT_FOLDER_TYPE_KEY = "OBJECT_FOLDER_TYPE";
    public static final String OBJECT_OWNER_KEY = "OBJECT_OWNER";
    public static final String COLUMN_NAME_KEY = "COLUMN_NAME";
    public static final String OBJECT_ID_KEY = "OBJECT_ID";
    public static final String CHILD_NAME_KEY = "CHILD_NAME";
    public static final String CONN_TYPE_KEY = "CONN_TYPE";
    public static final String CONNECTION_NAME = "CONNECTION_NAME";
    public static final String NEW_OBJECTVIEWER_FLAG = "NEW_OBJECTVIEWER_FLAG";
    private String m_id;
    private Element<?, ?> m_node;
    private SchemaObject m_schemaObject;
    private Map<String, Object> m_dict;
    private boolean m_isValid;
    private boolean m_loaded = false;

    public static DBObject getDBObjectForName(String string, Database database) {
        String string2 = Connections.getInstance().getConnectionName(database);
        return DBObject.getDBObjectForName(string, string2);
    }

    public static DBObject getDBObjectForName(String string, String string2) {
        return DBObject.getDBObjectForName(string, string2, false);
    }

    public static DBObject getDBObjectForName(String string, String string2, boolean bl) {
        Map map;
        DBObject dBObject = null;
        if (string != null && string.trim().length() > 0 && (map = DBUtil.getInstance((String)string2).resolveName(string, false, bl)) != null) {
            URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, (String)map.get("OWNER"), (String)map.get(OBJECT_TYPE_KEY));
            uRL = DBURLFormatHelper.getURL(uRL, (String)map.get(OBJECT_NAME_KEY));
            LOGGER.info("Found:" + (String)map.get("OWNER") + "." + (String)map.get(OBJECT_TYPE_KEY) + "." + (String)map.get(OBJECT_NAME_KEY));
            LOGGER.info("Found URL:" + uRL);
            dBObject = new DBObject(uRL);
        }
        return dBObject;
    }

    public static boolean tryCheckForChanges(Context context) {
        try {
            DBObject dBObject = new DBObject((Element<?, ?>)context.getNode());
            if (dBObject.isValid()) {
                dBObject.getSchemaObject();
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getMessage(), exception);
            return false;
        }
    }

    public DBObject(URL uRL) {
        super(uRL);
        this.m_loaded = true;
    }

    public DBObject(Element<?, ?> element) {
        this.m_node = element instanceof IViewerNode ? ((IViewerNode)element).getBaseNode() : element;
    }

    public Map<String, Object> getDictionary() {
        if (this.m_dict == null) {
            String string;
            Iterator<String> iterator;
            Object object;
            this.loadDBData();
            this.m_dict = new HashMap<String, Object>();
            if (this.m_node instanceof DatabaseNode && (object = ((DatabaseNode)this.m_node).getNodeInstance()) != null) {
                iterator = object.getPropertyKeys().iterator();
                while (iterator.hasNext()) {
                    string = iterator.next();
                    this.m_dict.put(string, object.getProperty(string));
                }
            }
            if (this.m_node instanceof ObjectFolder) {
                object = ((ObjectFolder)this.m_node).getFolderInstance();
                iterator = object.getPropertyKeys().iterator();
                while (iterator.hasNext()) {
                    string = iterator.next();
                    this.m_dict.put(string, object.getProperty(string));
                }
            }
            if ((iterator = ObjectFactory.getFactory((String)(object = this.getConnectionName()), this.getConnection())) != null) {
                this.m_dict.putAll(((ObjectFactory)((Object)iterator)).getGlobalBindMap());
            }
            if (this.m_node instanceof CustomNode && ((CustomNode)this.m_node).getDict() != null) {
                this.m_dict.putAll(((CustomNode)this.m_node).getDict());
            }
            string = this.getObjectName();
            if (this.m_type != null && this.m_type.equals("CONNECTION")) {
                this.m_dict.put(OBJECT_NAME_KEY, Connections.getConnectionName(string));
            } else {
                this.m_dict.put(OBJECT_NAME_KEY, string);
            }
            this.m_dict.put(OBJECT_TYPE_KEY, this.getObjectType());
            this.m_dict.put(OBJECT_OWNER_KEY, this.getSchemaName());
            String string2 = this.getChildName();
            this.m_dict.put(COLUMN_NAME_KEY, string2);
            this.m_dict.put(CHILD_NAME_KEY, string2);
            this.m_dict.put(OBJECT_FOLDER_TYPE_KEY, this.m_folderType);
            this.m_dict.put(CONNECTION_NAME, Connections.getConnectionName((String)object));
            this.m_dict.put(OBJECT_ID_KEY, this.m_id);
        }
        return this.m_dict;
    }

    public Map<String, Object> getObjectBinds(String string) {
        this.loadDBData();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string.indexOf(":OBJECT_NAME") > 0) {
            hashMap.put(OBJECT_NAME_KEY, this.getObjectName());
        }
        if (string.indexOf(":OBJECT_OWNER") > 0) {
            hashMap.put(OBJECT_OWNER_KEY, this.getSchemaName());
        }
        if (string.indexOf(":OBJECT_ID") > 0) {
            hashMap.put(OBJECT_ID_KEY, this.getObjectId());
        }
        if (string.indexOf(":OBJECT_TYPE") > 0) {
            hashMap.put(OBJECT_TYPE_KEY, this.getObjectType());
        }
        return hashMap;
    }

    public boolean isValid() {
        this.loadDBData();
        return this.m_isValid;
    }

    public synchronized void reloadDBData() {
        this.m_loaded = false;
        this.getElement();
        this.loadDBData();
    }

    public synchronized void loadDBData() {
        if (!this.m_loaded) {
            this.m_isValid = true;
            if (this.m_node instanceof DatabaseNode) {
                this.processObjectNode((DatabaseNode)this.m_node);
            } else if (this.m_node instanceof ObjectFolder) {
                this.processObjectFolder((ObjectFolder)this.m_node);
            } else if (this.m_node instanceof OtherSchemasFolder) {
                this.processOtherSchemasFolder((OtherSchemasFolder)this.m_node);
            } else if (this.m_node instanceof DatabaseConnection) {
                this.processConnectionNode((DatabaseConnection)this.m_node);
            } else if (this.m_node instanceof SchemaFolder) {
                this.processSchemaFolder((SchemaFolder)this.m_node);
            } else if (this.m_node instanceof CategoryFolder) {
                this.processCategoryFolder((CategoryFolder)this.m_node);
            } else if (this.m_node instanceof ObjectNode) {
                this.processObjectNode((ObjectNode)this.m_node);
            } else if (this.m_node instanceof CustomNode) {
                this.processCustomNode((CustomNode)this.m_node);
            } else if (this.m_node instanceof ChildObjectElement) {
                this.processChild((ChildObjectElement)this.m_node);
            } else if (this.m_node instanceof ChildFolder) {
                this.processChildFolder((ChildFolder)this.m_node);
            } else if (this.m_node instanceof CatalogFolder) {
                this.processCatalogFolder((CatalogFolder)this.m_node);
            } else if (this.m_node instanceof ObjectElement) {
                this.processObjectElement((ObjectElement)this.m_node);
            } else if (this.m_node instanceof ObjectTypeFolder) {
                this.processObjectTypeFolder((ObjectTypeFolder)this.m_node);
            } else {
                this.m_isValid = false;
            }
            if (this.m_node instanceof DatabaseElement) {
                DatabaseElement databaseElement = (DatabaseElement)this.m_node;
                if (this.m_connType == null) {
                    this.m_connType = (String)databaseElement.getProperty("ConnectionType");
                }
                String string = this.m_id = databaseElement.getProperty(OBJECT_ID_KEY) != null ? databaseElement.getProperty(OBJECT_ID_KEY).toString() : null;
            }
            if (this.m_type != null && this.m_type.equals("PUBLIC_SYNONYM")) {
                this.m_schema = "PUBLIC";
            }
            if (this.m_type != null && this.m_type.equals("PUBLIC DATABASE LINK")) {
                this.m_schema = "PUBLIC";
            }
            if (this.m_node instanceof Locatable) {
                this.m_url = ((Locatable)this.m_node).getURL();
            }
            this.m_loaded = true;
        }
    }

    private void processObjectElement(ObjectElement objectElement) {
        this.m_type = objectElement.getTypeName();
        this.m_name = objectElement.getName();
    }

    private void processObjectTypeFolder(ObjectTypeFolder objectTypeFolder) {
        this.m_type = objectTypeFolder.getTypeName();
        this.m_folderType = objectTypeFolder.getFolderType();
        this.m_connName = objectTypeFolder.getConnectionName();
    }

    private void processCatalogFolder(CatalogFolder catalogFolder) {
        this.m_folderType = this.m_type = "CATALOG";
        this.m_url = catalogFolder.getURL();
        this.m_connName = DBURLFormatHelper.getConnectionName(this.m_url);
        this.m_connType = catalogFolder.getCatalogInstance().getObjectFactory().getConnectionType();
        this.m_name = DBURLFormatHelper.getCatalog(this.m_url);
        this.m_catalog = DBURLFormatHelper.getCatalog(this.m_url);
    }

    private void processChild(ChildObjectElement childObjectElement) {
        this.m_name = (String)childObjectElement.getProperty(OBJECT_NAME_KEY);
        this.m_schema = (String)childObjectElement.getProperty("SCHEMA");
        this.m_folderType = this.m_type = (String)childObjectElement.getProperty("TYPE");
        this.m_connName = DBURLFormatHelper.getConnectionName(childObjectElement.getURL());
        this.m_connType = (String)childObjectElement.getProperty("ConnectionType");
        this.m_catalog = (String)childObjectElement.getProperty("CATALOG");
        this.m_childName = (String)childObjectElement.getProperty("NAME");
    }

    private void processChildFolder(ChildFolder childFolder) {
        this.m_folderType = childFolder.getObjectType();
        this.m_type = DBObject.createFolderType((String)this.m_folderType);
        this.m_connName = (String)childFolder.getProviderIdentifier();
        this.m_schema = childFolder.getSchemaName();
    }

    private void processCustomNode(CustomNode customNode) {
        this.m_folderType = this.m_type = customNode.getObjectType();
        this.m_connType = customNode.getConnType();
        this.m_connName = customNode.getConnectionName();
        this.m_name = customNode.getObjectName();
        this.m_schema = customNode.getSchemaName();
        this.m_conn = customNode.getConn();
    }

    private void processConnectionNode(DatabaseConnection databaseConnection) {
        this.m_folderType = this.m_type = "CONNECTION";
        this.m_name = databaseConnection.getQualifiedConnectionName();
        this.m_connName = databaseConnection.getQualifiedConnectionName();
        try {
            if (databaseConnection.isConnectionOpen()) {
                ObjectFactory objectFactory = ObjectFactory.getFactory(this.m_connName, (Connection)databaseConnection.getConnection());
                this.m_connType = objectFactory.getConnectionType();
                this.m_schema = objectFactory.getSchema();
            } else {
                Properties properties = Connections.getInstance().getConnectionInfo(this.m_connName);
                if (properties != null) {
                    this.m_schema = properties.getProperty("user");
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.severe("Could not read node:" + iOException.getMessage());
        }
    }

    private void processOtherSchemasFolder(OtherSchemasFolder otherSchemasFolder) {
        this.m_folderType = this.m_type = "USER_FOLDER";
        this.m_connName = otherSchemasFolder.getConnectionName();
    }

    private void processSchemaFolder(SchemaFolder schemaFolder) {
        this.m_folderType = this.m_type = "USER";
        this.m_connName = (String)schemaFolder.getProperty("ConnectionName");
        this.m_schema = (String)schemaFolder.getProperty("SCHEMA");
    }

    private void processCategoryFolder(CategoryFolder categoryFolder) {
        this.m_folderType = this.m_type = categoryFolder.getCategory();
        this.m_connName = (String)categoryFolder.getProperty("ConnectionName");
        this.m_schema = (String)categoryFolder.getProperty("SCHEMA");
    }

    private void processObjectFolder(ObjectFolder objectFolder) {
        this.m_type = DBObject.createFolderType((String)objectFolder.getObjectType());
        this.m_folderType = objectFolder.getObjectType();
        this.m_connName = (String)objectFolder.getProperty("ConnectionName");
        this.m_schema = (String)objectFolder.getProperty("SCHEMA");
    }

    private static Connection getConnection(String string, boolean bl) {
        try {
            return Connections.getInstance().getConnection(string, bl);
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Throwable)dBException);
            return null;
        }
    }

    private void processObjectNode(DatabaseNode databaseNode) {
        this.m_name = (String)databaseNode.getProperty("NAME");
        this.m_schema = (String)databaseNode.getProperty("SCHEMA");
        this.m_folderType = this.m_type = (String)databaseNode.getProperty("TYPE");
        this.m_connName = (String)databaseNode.getProperty("ConnectionName");
        this.m_connType = (String)databaseNode.getProperty("ConnectionType");
        this.m_catalog = (String)databaseNode.getProperty("CATALOG");
        if (this.m_type != null) {
            if (this.m_type.equalsIgnoreCase("materialized view log")) {
                this.m_childName = (String)databaseNode.getProperty("MASTER");
            }
        } else {
            this.m_isValid = false;
        }
    }

    public Node getNode() {
        Element<?, ?> element = this.getElement();
        return element instanceof Node ? (Node)element : null;
    }

    public Element<?, ?> getElement() {
        if (this.m_node == null && this.m_url != null) {
            this.m_node = DatabaseNavigatorElementFactory.getObjectNode(this.m_url);
        }
        return this.m_node;
    }

    public void setNode(Node node) {
        this.m_node = node;
        this.loadDBData();
    }

    public String getObjectId() {
        DBObjectID dBObjectID;
        SchemaObject schemaObject;
        this.loadDBData();
        if (this.m_id == null && (schemaObject = this.getSchemaObject()) != null && (dBObjectID = schemaObject.getID()) instanceof IdentifierBasedID) {
            this.m_id = ((IdentifierBasedID)dBObjectID).getIdentifier().toString();
        }
        return this.m_id;
    }

    public SchemaObject getSchemaObject() {
        this.loadDBData();
        if (this.m_schemaObject == null) {
            try {
                Database database = this.getDatabase();
                if (database != null) {
                    this.m_schemaObject = database.getObject(this.m_type, database.getSchema(this.m_schema), this.m_name);
                }
            }
            catch (Exception exception) {
                LOGGER.severe("Could not get schema Object:" + exception.getMessage());
            }
        }
        return this.m_schemaObject;
    }

    public Database getDatabase() {
        this.loadDBData();
        Database database = null;
        try {
            database = Connections.getInstance().getDatabase(this.m_connName);
        }
        catch (DBException dBException) {
            LOGGER.log(Level.FINE, "", dBException);
        }
        return database;
    }

    public Connection getConnection() {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean bl) {
        this.loadDBData();
        this.m_conn = DBObject.getConnection(this.m_connName, bl);
        return this.m_conn;
    }

    public boolean isConnected() {
        return Connections.getInstance().isConnectionOpen(this.getConnectionName());
    }

    public boolean isOracle() {
        this.loadDBData();
        String string = this.getConnectionType();
        return string != null ? "Oracle".equals(string) : this.isOracleImpl();
    }

    private boolean isOracleImpl() {
        this.loadDBData();
        return Connections.getInstance().isOracle(this.getConnectionName());
    }

    public String getConnectionType() {
        this.loadDBData();
        if (this.m_connType == null) {
            Properties properties;
            if (this.isOracleImpl()) {
                this.m_connType = "Oracle";
            } else if (this.getConnectionName() != null && (properties = Connections.getInstance().getConnectionInfo(this.getConnectionName())) != null) {
                this.m_connType = properties.getProperty("RaptorConnectionType");
            }
        }
        return this.m_connType;
    }

    public boolean isTimesTen() {
        this.loadDBData();
        return Connections.getInstance().isTimesTen(this.getConnectionName());
    }

    public String getDBVersion() {
        this.loadDBData();
        try {
            return RaptorVersionTracker.getDbVersion(Connections.getInstance().getConnection(this.getConnectionName())).toCanonicalString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean checkVals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public boolean checkQualifiedNameEquals(DBObject dBObject) {
        this.loadDBData();
        if (dBObject == null) {
            return false;
        }
        return DBObject.checkVals(String.valueOf(dBObject.getURL()), String.valueOf(this.getURL())) && DBObject.checkVals(dBObject.getObjectName(), this.getObjectName()) && DBObject.checkVals(dBObject.getConnectionName(), this.getConnectionName()) && DBObject.checkVals(dBObject.getSchemaName(), this.getSchemaName());
    }

    public boolean isActionAllowed() {
        return !DBStarterFactory.isDebugSessionActive(this.m_connName);
    }
}

