/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.dbtools.raptor.support.MetaXMLReference;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.net.JarUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractFolderedXml {
    protected static Logger LOGGER = Logger.getLogger(AbstractFolderedXml.class.getName());
    private XMLDocument _document;
    private DOMParser parser;

    public abstract void openFolder(String var1, String var2, String var3, MetaXMLReference var4, XLIFFHelper var5);

    public abstract void closeFolder();

    public abstract void newItem(MetaXMLReference var1, XLIFFHelper var2);

    public void newNode(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
    }

    private void processFolder(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
        Node node = metaXMLReference.getNode();
        String string = XMLHelper.getNodeValue((Node)node, (String)"name");
        String string2 = XMLHelper.getNodeValue((Node)node, (String)"description");
        String string3 = XMLHelper.getNodeValue((Node)node, (String)"tip");
        string = xLIFFHelper.getTranslation(string);
        string2 = xLIFFHelper.getTranslation(string2);
        string3 = xLIFFHelper.getTranslation(string3);
        this.openFolder(string, string2, string3, metaXMLReference, xLIFFHelper);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string4 = node2.getNodeName();
            if (string4.equalsIgnoreCase("folder")) {
                this.processFolder(MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)node2), xLIFFHelper);
                continue;
            }
            if (string4.equalsIgnoreCase("item")) {
                this.newItem(MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)node2), xLIFFHelper);
                continue;
            }
            if (string4.equalsIgnoreCase("description") || string4.equalsIgnoreCase("name") || string4.equalsIgnoreCase("#comment") || string4 == null) continue;
            LOGGER.finer("Folder:Unsupported node in xml:" + string4);
        }
    }

    private void processNode(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
        Node node = metaXMLReference.getNode();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("folder")) {
                this.processFolder(MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)node2), xLIFFHelper);
                this.closeFolder();
                continue;
            }
            if (string.equalsIgnoreCase("item")) {
                this.newItem(MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)node2), xLIFFHelper);
                continue;
            }
            if (string.equalsIgnoreCase("#comment")) continue;
            this.newNode(MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)node2), xLIFFHelper);
        }
    }

    private XLIFFHelper createXLIFFHelper(MetaURLReference metaURLReference) {
        URL uRL;
        Object object = null;
        URL uRL2 = metaURLReference.getURL();
        if (uRL2 != null && (object = JarUtil.getJarEntry((URL)(uRL = FileUtils.resolveURL((URL)uRL2)))) != null && !((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        return new XLIFFHelper(metaURLReference.getReferenceClassLoader(), (String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXML(MetaURLReference metaURLReference) throws Exception {
        XLIFFHelper xLIFFHelper = this.createXLIFFHelper(metaURLReference);
        if (this.parser == null) {
            this.parser = new DOMParser();
        } else {
            this.parser.reset();
        }
        this.parser.setPreserveWhitespace(false);
        InputStream inputStream = metaURLReference.openInputStream();
        try {
            this.parser.parse(inputStream);
            this._document = this.parser.getDocument();
            NodeList nodeList = this._document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.processNode(MetaXMLReference.createXMLReference((Node)nodeList.item(i), (ClassLoader)metaURLReference.getReferenceClassLoader()), xLIFFHelper);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, metaURLReference.getURL().toString() + "-" + exception.getMessage(), exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public Document getDocument() {
        return this._document;
    }

    public static void main(String[] stringArray) {
    }
}

