/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.ide.Ide;

public class FilePathActionControlPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_ONLY = 0;
    public static final int FILES_AND_DIRECTORIES = 2;
    private JFormattedTextField _field;
    private JButton _button;
    private String _defaultPath;
    private int _dialogType = 1;
    private int _fileSelectionMode = 0;

    public FilePathActionControlPanel(String string, int n, int n2) {
        this._defaultPath = string;
        this._dialogType = n;
        this._defaultPath = string;
        this._fileSelectionMode = n2;
        this._field = new JFormattedTextField();
        this._button = new JButton(UiResources.getString("SELECT_LABEL"));
        this.reset();
        this._field.setName("Field");
        this._button.setName("Button");
        this._button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilePathActionControlPanel.this.showFileSelectionDialog();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this._field, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 0, 0, 5), 0, 0));
        this.add((Component)this._button, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void reset() {
        this.setPath(this._defaultPath);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this._field.setName(string + "_Field");
        this._button.setName(string + "_Button");
    }

    public String getPath() {
        return this._field.getText();
    }

    public void setPath(String string) {
        this._field.setText(string);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this._field.addKeyListener(keyListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this._field.getDocument().addDocumentListener(documentListener);
    }

    private void showFileSelectionDialog() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        try {
            File file = new File(this._field.getText());
            if (file.isFile()) {
                uRLFileChooser.setSelectedFile(file);
            } else {
                uRLFileChooser.setCurrentDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        uRLFileChooser.setFileSelectionMode(this._fileSelectionMode);
        int n = 0;
        n = this._dialogType == 1 ? uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), UiResources.getString("SELECT_SAVE_DIALOG_TITLE")) : uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), UiResources.getString("SELECT_OPEN_DIALOG_TITLE"));
        if (n == 0) {
            String string = uRLFileChooser.getSelectedFile().toString();
            this._field.setText(string);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._field.setEnabled(bl);
        this._button.setEnabled(bl);
    }

    public void setEditable(boolean bl) {
        this._field.setEditable(bl);
        this._button.setEnabled(bl);
    }

    public Document getDocument() {
        return this._field.getDocument();
    }

    public void setDocument(Document document) {
        this._field.setDocument(document);
    }
}

