/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sftp;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.rt.json.JSONToMap;
import oracle.dbtools.transfer.TransferManager;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.OracleStorageCloudService;
import oracle.dbtools.transfer.location.SshLocation;
import oracle.dbtools.transfer.task.TransferTask;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.SimpleByteProgressMonitor;
import oracle.dbtools.util.Encryption;
import oracle.ide.Ide;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class SftpUtil {
    private static final Logger LOGGER = Logger.getLogger(SftpUtil.class.getName());
    boolean completed = false;
    int _timeout = 60000;
    boolean transferTaskDone = false;

    private static Map<String, String> getResults(HttpEntity httpEntity) {
        try {
            Map map = JSONToMap.read((InputStream)httpEntity.getContent());
            return map;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean SftpPut(SftpParms sftpParms, boolean bl) {
        File file = new File(sftpParms.getLocalFile());
        if (this.SftpPut(sftpParms)) {
            if (bl) {
                try {
                    this.createDeploymentRow(sftpParms, "DEPLOY", String.valueOf(file.length()));
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void createDeploymentRow(final SftpParms sftpParms, String string, String string2) throws Exception {
        if (!SftpUtil.isSchemaServiceConnection(sftpParms.getCloudConnectionName())) {
            return;
        }
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            boolean bl;
            Session session = CConnections.getInstance().getConnection(sftpParms.getCloudConnectionName(), true);
            HttpPost httpPost = session.createPost("/create_deploy_record/");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
            arrayList.add(new BasicNameValuePair("p_imp_name", sftpParms.getImportName()));
            arrayList.add(new BasicNameValuePair("p_file_name", sftpParms.getRemoteFile()));
            arrayList.add(new BasicNameValuePair("p_file_type", string));
            arrayList.add(new BasicNameValuePair("p_file_size", string2));
            arrayList.add(new BasicNameValuePair("service_name", session.getDefaultServiceURI().toString()));
            SessionInfo.OssInfo ossInfo = SftpUtil.getOssInfo(sftpParms.getCloudConnectionName());
            boolean bl2 = bl = ossInfo != null && ossInfo.isOssEnabled();
            if (bl) {
                String string3 = ossInfo.getOssServiceName();
                String string4 = ossInfo.getOssIdentityDomain();
                String string5 = "https://" + string3 + "-" + string4 + ".storage.oraclecloud.com";
                byte[] byArray = Encryption.generateSalt((String[])new String[]{string3, string4, string5});
                String string6 = Encryption.getRandomUUID();
                String string7 = Encryption.encrypt((char[])ossInfo.getOssPassword(), (String)string6, (byte[])byArray);
                String string8 = ossInfo.getOssServiceUrl();
                Object object = null;
                object = string8 != null && !string8.isEmpty() ? (string5.equals(string8) ? ossInfo.getOssUserName() : ossInfo.getOssUserName() + "@" + string8) : ossInfo.getOssUserName();
                arrayList.add(new BasicNameValuePair("p_oss_service_name", string3));
                arrayList.add(new BasicNameValuePair("p_oss_identity_domain", string4));
                arrayList.add(new BasicNameValuePair("p_oss_user", (String)object));
                arrayList.add(new BasicNameValuePair("p_oss_uoid", string6));
                arrayList.add(new BasicNameValuePair("p_oss_value", string7));
            } else {
                arrayList.add(new BasicNameValuePair("p_oss_service_name", null));
                arrayList.add(new BasicNameValuePair("p_oss_identity_domain", null));
                arrayList.add(new BasicNameValuePair("p_oss_user", null));
                arrayList.add(new BasicNameValuePair("p_oss_uoid", null));
                arrayList.add(new BasicNameValuePair("p_oss_value", sftpParms.getSftpFileDate()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            session.executeRequest((HttpUriRequest)httpPost, (HttpClientResponseHandler)new HttpClientResponseHandler<Object>(){

                public Object handleResponse(ClassicHttpResponse classicHttpResponse) throws IOException {
                    if (classicHttpResponse.getReasonPhrase().equals("OK")) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "################  Deployment Created Successfully  ################");
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), ExportWizArb.format("FTP_DONE_MSG", sftpParms.getCloudConnectionName()), ExportWizArb.getString("FTP_DONE_TITLE"), 1);
                        return null;
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, classicHttpResponse.getCode() + ":" + classicHttpResponse.getReasonPhrase());
                    throw new RuntimeException(ExportWizArb.getString("FTP_ERROR_WRITE_DEPLOY"));
                }
            });
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
            throw exception;
        }
    }

    public void updateDeploymentStatus(String string, String string2, String string3) {
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            Session session = CConnections.getInstance().getConnection(string, true);
            HttpPost httpPost = session.createPost("/update_deploy_status/");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
            arrayList.add(new BasicNameValuePair("p_imp_name", string2));
            arrayList.add(new BasicNameValuePair("p_status", string3));
            arrayList.add(new BasicNameValuePair("user_name", "user_name"));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            session.executeRequest((HttpUriRequest)httpPost, (HttpClientResponseHandler)new HttpClientResponseHandler<Object>(){

                public Object handleResponse(ClassicHttpResponse classicHttpResponse) throws IOException {
                    if (classicHttpResponse.getReasonPhrase().equals("OK")) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "################  Deployment Successfully Updated  ################");
                        return null;
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, classicHttpResponse.getReasonPhrase());
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
        }
    }

    public void clearDeploymentLogs(String string, String string2) {
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            Session session = CConnections.getInstance().getConnection(string, true);
            HttpPost httpPost = session.createPost("/clear_deploy_logs/");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
            arrayList.add(new BasicNameValuePair("p_imp_name", string2));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            session.executeRequest((HttpUriRequest)httpPost, (HttpClientResponseHandler)new HttpClientResponseHandler<Object>(){

                public Object handleResponse(ClassicHttpResponse classicHttpResponse) throws IOException {
                    if (classicHttpResponse.getReasonPhrase().equals("OK")) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "################  Deployment Logs Cleared Successfully  ################");
                        return null;
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, classicHttpResponse.getReasonPhrase());
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
        }
    }

    public boolean SftpTestConnection(SftpParms sftpParms) {
        SessionInfo.OssInfo ossInfo = SftpUtil.getOssInfo(sftpParms.getCloudConnectionName());
        boolean bl = ossInfo != null && ossInfo.isOssEnabled();
        boolean bl2 = true;
        SshLocation sshLocation = null;
        if (bl) {
            LOGGER.info("Testing oss Connection");
            var6_6 = ossInfo.getOssServiceName();
            String string = ossInfo.getOssIdentityDomain();
            String string2 = ossInfo.getOssUserName();
            char[] cArray = ossInfo.getOssPassword();
            String string3 = ossInfo.getOssServiceUrl();
            sshLocation = new OracleStorageCloudService(var6_6, string, string2, cArray, string3);
        } else {
            LOGGER.info("Testing sftp Connection");
            var6_6 = sftpParms.getHost();
            int n = sftpParms.getPort();
            String string = sftpParms.getUser();
            String string4 = sftpParms.getKeyFile();
            sshLocation = new SshLocation(var6_6, n, string, string4);
        }
        try {
            if (!bl) {
                sshLocation.setPassword(sftpParms.getPassString());
            }
            sshLocation.connect();
            sshLocation.disconnect();
        }
        catch (Exception exception) {
            LOGGER.severe(exception.getLocalizedMessage());
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SftpPut(SftpParms sftpParms) {
        String string;
        SessionInfo.OssInfo ossInfo = SftpUtil.getOssInfo(sftpParms.getCloudConnectionName());
        boolean bl = ossInfo != null && ossInfo.isOssEnabled();
        SshLocation sshLocation = null;
        if (sftpParms.getRemoteFile() == null) {
            string = Paths.get(sftpParms.getLocalFile(), new String[0]).getFileName().toString();
            sftpParms.setRemoteFile(string);
        }
        if (!bl) {
            string = sftpParms.getHost();
            int n = sftpParms.getPort();
            String string2 = sftpParms.getUser();
            String string3 = sftpParms.getKeyFile();
            sshLocation = new SshLocation(string, n, string2, string3);
            try {
                sshLocation.setPassword(sftpParms.getPassString());
                sshLocation.connect();
                File file = new File(sftpParms.getLocalFile());
                URL uRL = file.toURI().toURL();
                sshLocation.copy(uRL.openStream(), "upload/" + sftpParms.getRemoteFile(), (TransferTaskProgressMonitor)new SimpleByteProgressMonitor(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                boolean bl2 = true;
                return bl2;
            }
            catch (Throwable throwable) {
                LOGGER.severe(throwable.getLocalizedMessage());
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (sshLocation != null) {
                    sshLocation.disconnect();
                }
            }
        }
        string = ossInfo.getOssServiceName();
        String string4 = ossInfo.getOssIdentityDomain();
        String string5 = ossInfo.getOssUserName();
        Object object = ossInfo.getOssPassword();
        String string6 = ossInfo.getOssServiceUrl();
        sshLocation = new OracleStorageCloudService(string, string4, string5, object, string6);
        try {
            string = Location.getLocal();
            string4 = new FileSet();
            string4.add(sftpParms.getLocalFile());
            string4.setLocation((Location)string);
            string5 = sshLocation;
            this.transferTaskDone = false;
            this.completed = false;
            object = TransferManager.INSTANCE.createTransferTask("testTransferTask", IRaptorTaskRunMode.NO_GUI, (FileSet)string4, (Location)string5, "uploads");
            object.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((TransferTask)object, (FileSet)string4, (Location)string5){
                final /* synthetic */ TransferTask val$task;
                final /* synthetic */ FileSet val$fileSet;
                final /* synthetic */ Location val$realTransport;
                {
                    this.val$task = transferTask;
                    this.val$fileSet = fileSet;
                    this.val$realTransport = location;
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    super.taskFailed(raptorTaskEvent);
                    SftpUtil.this.completed = false;
                    LOGGER.info("FAILED: " + String.valueOf(this.val$task));
                    this.done();
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    super.taskFinished(raptorTaskEvent);
                    SftpUtil.this.completed = true;
                    LOGGER.info("FINISHED: " + String.valueOf(this.val$task));
                    this.done();
                }

                private void done() {
                    try {
                        this.val$fileSet.getLocation().disconnect();
                        this.val$realTransport.disconnect();
                    }
                    finally {
                        SftpUtil.this.transferTaskDone = true;
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)object);
            while (!this.transferTaskDone) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.warning(interruptedException.getLocalizedMessage());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.severe(exception.getLocalizedMessage());
        }
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String string, Path path, File file) throws Exception {
        block8: {
            boolean bl;
            SessionInfo.OssInfo ossInfo = SftpUtil.getOssInfo(string);
            boolean bl2 = bl = ossInfo != null && ossInfo.isOssEnabled();
            if (bl) {
                String string2 = ossInfo.getOssServiceName();
                String string3 = ossInfo.getOssIdentityDomain();
                String string4 = ossInfo.getOssUserName();
                char[] cArray = ossInfo.getOssPassword();
                String string5 = ossInfo.getOssServiceUrl();
                OracleStorageCloudService oracleStorageCloudService = new OracleStorageCloudService(string2, string3, string4, cArray, string5);
                oracleStorageCloudService.connect();
                try (InputStream inputStream = oracleStorageCloudService.asInputStream(path, 0L, 0L);
                     FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    int n;
                    byte[] byArray = new byte[4096];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                    break block8;
                }
            }
            throw new UnsupportedOperationException("Connection must be OSS");
        }
    }

    public static SessionInfo.OssInfo getOssInfo(String string) {
        if (null == string) {
            return null;
        }
        SessionInfo sessionInfo = null;
        if (SftpUtil.isSchemaServiceConnection(string)) {
            sessionInfo = CConnections.getInstance().getConnectionInfo(string);
        }
        SessionInfo.OssInfo ossInfo = null;
        if (sessionInfo != null) {
            ossInfo = sessionInfo.getOssInfo();
        } else {
            Properties properties = Connections.getInstance().getConnectionInfo(string);
            boolean bl = Boolean.valueOf(properties.getProperty("oss.enabled"));
            if (bl) {
                String string2 = properties.getProperty("oss.password");
                char[] cArray = null == string2 ? null : string2.toCharArray();
                ossInfo = new SessionInfo.OssInfo(bl, properties.getProperty("oss.service_name"), properties.getProperty("oss.identity_domain"), properties.getProperty("oss.username"), cArray, properties.getProperty("oss.service_url"));
            }
        }
        return ossInfo;
    }

    public static boolean isSchemaServiceConnection(String string) {
        boolean bl = false;
        for (String string2 : CConnections.getInstance().listConnections()) {
            if (!string.equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

