/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure.arbori;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.folding.TypedFoldingBlock;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriFoldingModel;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriLanguageSupport;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.AbstractCodeFoldingPlugin;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.icons.OracleIcons;

public class ArboriFoldingPlugin
extends AbstractCodeFoldingPlugin
implements CodeFoldingProvider {
    protected CodeFoldingProvider createProvider() {
        return this;
    }

    public CodeFoldingModel createModel(BasicEditorPane basicEditorPane) {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        ArboriLanguageSupport arboriLanguageSupport = (ArboriLanguageSupport)basicEditorPane.getLanguageSupport();
        return new ArboriFoldingModel(basicDocument, arboriLanguageSupport.parser);
    }

    public JPopupMenu getPopupMenu() {
        return ArboriFoldingPlugin.generateMenu((ArboriFoldingModel)this.getModel());
    }

    public static JPopupMenu generateMenu(final ArboriFoldingModel arboriFoldingModel) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.3"), OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)arboriFoldingModel.getRoot();
                for (TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode = typedFoldingBlock2.src;
                    if (parseNode == null || !parseNode.contains("rule")) continue;
                    typedFoldingBlock2.setExpanded(true);
                }
                arboriFoldingModel.reload();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.4"), OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)arboriFoldingModel.getRoot();
                for (TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode;
                    if (typedFoldingBlock2.getEndOffset() == typedFoldingBlock.getEndOffset() || (parseNode = typedFoldingBlock2.src) == null || !parseNode.contains("rule")) continue;
                    typedFoldingBlock2.setExpanded(false);
                }
                arboriFoldingModel.reload();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.ExpandComments"), OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)arboriFoldingModel.getRoot();
                for (TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode;
                    if (typedFoldingBlock2.getEndOffset() == typedFoldingBlock.getEndOffset() || (parseNode = typedFoldingBlock2.src) != null) continue;
                    typedFoldingBlock2.setExpanded(true);
                }
                arboriFoldingModel.reload();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("PlSqlFoldingPlugin.CollapseComments"), OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)arboriFoldingModel.getRoot();
                for (TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode;
                    if (typedFoldingBlock2.getEndOffset() == typedFoldingBlock.getEndOffset() || (parseNode = typedFoldingBlock2.src) != null) continue;
                    typedFoldingBlock2.setExpanded(false);
                }
                arboriFoldingModel.reload();
            }
        });
        return jPopupMenu;
    }

    public CodeFoldingMargin getCodeFoldingMargin() {
        return this.getMargin();
    }

    public void insertUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
        ArboriFoldingModel arboriFoldingModel = (ArboriFoldingModel)codeFoldingModel;
        arboriFoldingModel.reload(n, n2);
    }

    public void removeUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
        ArboriFoldingModel arboriFoldingModel = (ArboriFoldingModel)codeFoldingModel;
        arboriFoldingModel.reload(n, -n2);
    }
}

