/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.ui.RDockableWindow;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.Editor;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.javatools.icons.OracleIcons;

public class OutlineWindow
extends RDockableWindow
implements DockableFactory {
    static final String VIEW_TYPE = "OUTLINE_VIEW_TYPE";
    static final String VIEW_ID = "oracle-dbtools-raptor-plsql-structure-Window";
    private Controller _controller;
    private OutlinePanel _gui = new OutlinePanel();
    private static OutlineWindow _outlineWindow;

    public OutlineWindow() {
        super("OUTLINE_VIEW_TYPE.oracle-dbtools-raptor-plsql-structure-Window");
        _outlineWindow = this;
    }

    public static OutlineWindow getInstance() {
        if (_outlineWindow == null) {
            new OutlineWindow();
        }
        return _outlineWindow;
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new SController();
        }
        return this._controller;
    }

    public Component getGUI() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._gui, "f1_outlinestructure_html");
        return this._gui;
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public String getTabName() {
        return Messages.getString("CodeOutline");
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"structure.png");
    }

    public String getTitleName() {
        return Messages.getString("CodeOutline");
    }

    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        return context;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_outlinestructure_html");
    }

    public void refresh(Editor editor) {
        if (this._gui != null && this._gui.isShowing()) {
            this._gui.refresh(editor);
        }
    }

    public Dockable getDockable(ViewId viewId) {
        return this;
    }

    public void install() {
        if (RaptorExtensionConstants.isStandAlone()) {
            ExplorerManager explorerManager;
            DockingParam dockingParam = new DockingParam();
            DBNavigatorManager dBNavigatorManager = DBNavigatorManager.getInstance();
            if (dBNavigatorManager.getNavigatorWindow() != null) {
                dockingParam.setPosition((Dockable)dBNavigatorManager.getNavigatorWindow(), 3, 0);
            } else {
                explorerManager = ExplorerManager.getExplorerManager();
                Dockable dockable = null;
                if (explorerManager != null) {
                    ViewId viewId = explorerManager.getDefaultViewId();
                    dockable = DockStation.getDockStation().findDockable(viewId);
                }
                dockingParam.setPosition(dockable, 4, 0);
            }
            explorerManager = DockStation.getDockStation();
            explorerManager.dock((Dockable)this, dockingParam);
        }
    }

    class SController
    implements Controller {
        SController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    }
}

