/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.language;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.plsql.language.CustomSyntaxStyle;
import oracle.dbtools.raptor.plsql.language.PLSQLBlockRenderer;
import oracle.dbtools.raptor.plsql.language.PLSQLLanguageSupport;
import oracle.dbtools.raptor.plsql.language.PLSQLStyles;
import oracle.dbtools.util.Service;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.plsql.PlsqlTokens;
import oracle.javatools.parser.plsql.syntax.PlsqlLexer;

final class PLSQLDocumentRenderer
extends LexerDocumentRenderer
implements PlsqlTokens {
    PLSQLLanguageSupport support;
    private static Logger logger = Logger.getLogger(PLSQLDocumentRenderer.class.getName());

    PLSQLDocumentRenderer(LanguageSupport languageSupport) {
        super(languageSupport);
        this.support = (PLSQLLanguageSupport)languageSupport;
    }

    protected BlockRenderer createBlockRenderer() {
        TextBuffer textBuffer = this.getTextBuffer();
        return new PLSQLBlockRenderer(textBuffer);
    }

    public void renderRegion(StyledFragmentsList styledFragmentsList, int n, int n2) {
        if (n2 <= n) {
            return;
        }
        if (this.support != null && this.support.parser != null && this.support.parser.src != null && this.support.parser.increments.size() == 0) {
            long l;
            long l2;
            long l3 = System.currentTimeMillis();
            if (this.support.colorizer == null) {
                this.support.colorizer = new CustomSyntaxStyle(this.support);
            }
            if (this.support.oldRoot != this.support.parser.root) {
                if (this.support.parser.root != null) {
                    this.support.colorizer.doIt(new Parsed(this.support.parser.text, this.support.parser.src, this.support.parser.root));
                } else {
                    this.support.colorizer.resetStyles();
                }
                this.support.oldRoot = this.support.parser.root;
            }
            int n3 = 0;
            int n4 = n;
            for (LexerToken lexerToken : this.support.parser.allSrc) {
                n3 = lexerToken.begin + lexerToken.content.length();
                if (lexerToken.type == Token.COMMENT) {
                    n3 = lexerToken.end;
                }
                if (n3 == 665) {
                    n3 = 665;
                }
                if (n2 <= lexerToken.begin) break;
                if (n <= n3) {
                    String string = null;
                    switch (lexerToken.type) {
                        case IDENTIFIER: {
                            if (PLSQLStyles.isKeyword(lexerToken.content)) {
                                string = PLSQLStyles.plsqlKeywordStyle.getName();
                                break;
                            }
                            if (lexerToken.content.charAt(0) == '$') {
                                string = PLSQLStyles.plSqlMacrosStyle.getName();
                                break;
                            }
                            string = PLSQLStyles.plsqlIdentifierStyle.getName();
                            break;
                        }
                        case DIGITS: {
                            string = PLSQLStyles.plsqlNumberStyle.getName();
                            break;
                        }
                        case QUOTED_STRING: {
                            string = PLSQLStyles.plsqlStringStyle.getName();
                            break;
                        }
                        case OPERATION: {
                            if ("(".equals(lexerToken.content) || ")".equals(lexerToken.content)) {
                                string = PLSQLStyles.plsqlBraceStyle.getName();
                                break;
                            }
                            string = PLSQLStyles.plsqlOperatorStyle.getName();
                            break;
                        }
                        case LINE_COMMENT: 
                        case COMMENT: {
                            string = PLSQLStyles.plsqlCommentStyle.getName();
                            break;
                        }
                        default: {
                            string = PLSQLStyles.plsqlPlainStyle.getName();
                        }
                    }
                    try {
                        this.addFragment(styledFragmentsList, string, lexerToken.begin, n3);
                    }
                    catch (IllegalStateException illegalStateException) {
                        try {
                            this.addFragment(styledFragmentsList, PLSQLStyles.plsqlPlainStyle.getName(), n4, n2);
                        }
                        catch (IllegalStateException illegalStateException2) {
                            illegalStateException2.printStackTrace();
                        }
                        return;
                    }
                }
                n4 = n3;
            }
            if (n3 < n2 && n <= n3) {
                this.addFragment(styledFragmentsList, PLSQLStyles.plsqlCommentStyle.getName(), n3, n2);
            }
            if (30L < (l2 = (l = System.currentTimeMillis()) - l3)) {
                logger.log(Level.INFO, "renderRegion [" + n + "," + n2 + ")");
                logger.log(Level.INFO, "renderRegion time = " + l2);
                if (this.support.colorizer != null) {
                    logger.log(Level.INFO, "CustomSyntaxStyle.styles.size()=" + this.support.colorizer.styles.size());
                }
            }
        } else {
            super.renderRegion(styledFragmentsList, n, n2);
        }
    }

    private void addFragment(StyledFragmentsList styledFragmentsList, String string, int n, int n2) {
        String string2 = this.support.colorizer.styles.get(Service.lPair((int)n, (int)n2));
        if (string2 == null) {
            styledFragmentsList.add(string, n, n2);
        } else {
            styledFragmentsList.add(string2, n, n2);
        }
    }

    protected Lexer createLexer() {
        PlsqlLexer plsqlLexer = new PlsqlLexer();
        plsqlLexer.setSkipComments(false);
        return plsqlLexer;
    }

    public boolean isMultiLineToken(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 33: 
            case 48: 
            case 49: {
                return true;
            }
        }
        return false;
    }
}

