/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.language;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.raptor.config.SyntaxColorCustomOptions;
import oracle.dbtools.raptor.plsql.language.PLSQLLanguageSupport;
import oracle.dbtools.util.Service;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.language.StyleRegistry;

public class CustomSyntaxStyle {
    private static Logger logger = Logger.getLogger(CustomSyntaxStyle.class.getName());
    static final String path = "/oracle/dbtools/raptor/plsql/language/";
    SqlProgram programInstance = null;
    private static List<CustomSyntaxStyle> instances = new LinkedList<CustomSyntaxStyle>();
    private PLSQLLanguageSupport support;
    public static final String fname = "custom_syntax.arbori";
    StyleRegistry styleRegistry = null;
    HighlightRegistry highlightRegistry = null;
    public Map<Long, String> styles = new HashMap<Long, String>();

    public void resetProgramInstance() {
        this.programInstance = null;
    }

    public static void resetProgramInstances() {
        for (CustomSyntaxStyle customSyntaxStyle : instances) {
            customSyntaxStyle.resetProgramInstance();
            customSyntaxStyle.support.oldRoot = null;
        }
    }

    CustomSyntaxStyle(PLSQLLanguageSupport pLSQLLanguageSupport) {
        instances.add(this);
        this.support = pLSQLLanguageSupport;
    }

    void resetStyles() {
        this.styles = new HashMap<Long, String>();
    }

    public static URL getDefaultURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper");
        return URLFactory.newURL((URL)uRL, (String)fname);
    }

    public static String getActiveCustomSyntaxStyleProgram() throws IOException {
        if (SyntaxColorCustomOptions.arboriCode != null) {
            return SyntaxColorCustomOptions.arboriCode;
        }
        String string = Service.readFile(CustomSyntaxStyle.class, (String)"/oracle/dbtools/raptor/plsql/language/custom_syntax.arbori");
        try {
            String string2 = CustomSyntaxStyle.getDefaultURL().getFile();
            string = Service.readFile((String)string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public void doIt(Parsed parsed) {
        try {
            this.resetStyles();
            if (this.programInstance == null) {
                try {
                    String string = CustomSyntaxStyle.getActiveCustomSyntaxStyleProgram();
                    this.programInstance = new SqlProgram(string, this){};
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.programInstance.eval(parsed, (Object)this);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, throwable.getMessage());
        }
    }

    public void addStyle(Parsed parsed, ParseNode parseNode, String string) {
        EditorProperties editorProperties;
        if (parseNode == null) {
            logger.log(Level.SEVERE, "missing the node attribute in predicate  " + string);
            return;
        }
        if (this.styleRegistry == null) {
            editorProperties = EditorProperties.getProperties();
            this.styleRegistry = editorProperties.getStyleRegistry();
        }
        if (this.highlightRegistry == null) {
            editorProperties = EditorProperties.getProperties();
            this.highlightRegistry = editorProperties.getHighlightRegistry();
        }
        if (this.styleRegistry.lookupStyle(string) == null && this.highlightRegistry.lookupStyle(string) == null) {
            logger.log(Level.SEVERE, "missing color highlight  " + string);
            return;
        }
        for (int i = parseNode.from; i < parseNode.to; ++i) {
            LexerToken lexerToken = (LexerToken)parsed.getSrc().get(i);
            long l = Service.lPair((int)lexerToken.begin, (int)lexerToken.end);
            this.styles.put(l, string);
        }
    }

    public void addStyle(int n, int n2, String string) {
        EditorProperties editorProperties;
        if (this.styleRegistry == null) {
            editorProperties = EditorProperties.getProperties();
            this.styleRegistry = editorProperties.getStyleRegistry();
        }
        if (this.highlightRegistry == null) {
            editorProperties = EditorProperties.getProperties();
            this.highlightRegistry = editorProperties.getHighlightRegistry();
        }
        if (this.styleRegistry.lookupStyle(string) == null && this.highlightRegistry.lookupStyle(string) == null) {
            logger.log(Level.SEVERE, "missing color highlight  " + string);
            return;
        }
        long l = Service.lPair((int)n, (int)n2);
        this.styles.put(l, string);
    }

    public void PlSqlColTabAlases(Parsed parsed, Map<String, ParseNode> map) {
        ParseNode parseNode = map.get("node");
        this.addStyle(parsed, parseNode, "PlSqlColTabAlases");
    }

    public void PlSqlLogger(Parsed parsed, Map<String, ParseNode> map) {
        ParseNode parseNode = map.get("node");
        this.addStyle(parsed, parseNode, "PlSqlLogger");
    }
}

