/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.util.LinkedList;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.search.SearchIdeNode;
import oracle.dbtools.raptor.controls.search.SearchResultsEditor;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.plsql.InfoPanel;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;

public final class PinningTracker
implements EditorListener {
    private static LinkedList<Node> pinned = new LinkedList();
    static long dumpCount = 0L;

    public void editorActivated(Editor editor) {
        Node node;
        Context context = editor.getContext();
        Node node2 = node = context != null ? context.getNode() : null;
        if (node instanceof PlSqlNode || node instanceof TextNode && editor instanceof EquippedWithParser) {
            OutlineWindow.getInstance().refresh(editor);
        }
    }

    public void editorClosed(Editor editor) {
        pinned.remove(editor);
    }

    public void editorDeactivated(Editor editor) {
        Context context = editor.getContext();
        Node node = context != null ? context.getNode() : null;
    }

    public void editorOpened(Editor editor) {
        Node node;
        Context context = editor.getContext();
        Node node2 = node = context != null ? context.getNode() : null;
        if (editor instanceof InfoPanel || editor instanceof CodeEditor || editor instanceof SearchResultsEditor) {
            PinningTracker.closeUnpinnedEditors(editor);
        }
        if (node instanceof PlSqlNode) {
            OutlineWindow.getInstance().refresh(editor);
        }
    }

    private static void closeUnpinnedEditors(Editor editor) {
        int n;
        Object object;
        if ("true".equals(HiddenParameters.parameters.get("pinCount"))) {
            System.out.println("Pinned " + pinned.size() + " editors");
        }
        if ("true".equals(HiddenParameters.parameters.get("pinContent"))) {
            object = pinned.iterator();
            while (object.hasNext()) {
                Node node = (Node)object.next();
                System.out.println(" Pinned node " + node.getURL());
            }
        }
        if (49 <= (n = ((DBConfig)((Object)(object = DBConfig.getInstance()))).getInt("MAXOPENPLSQLEDITORS"))) {
            return;
        }
        PinningTracker.truncate(pinned, n);
        EditorManager editorManager = EditorManager.getEditorManager();
        LinkedList<Editor> linkedList = new LinkedList<Editor>();
        Context context = editor.getContext();
        Node node = context != null ? context.getNode() : null;
        for (Object e : editorManager.getAllEditors()) {
            Node node2;
            Context context2 = ((Editor)e).getContext();
            Node node3 = node2 = context2 != null ? context2.getNode() : null;
            if (!(node2 instanceof PlSqlNode) && !(node2 instanceof SearchIdeNode) || node == node2 || pinned.contains(node2) || node2.getURL() == null || node2.getClass() != node.getClass()) continue;
            linkedList.add((Editor)e);
        }
        editorManager.closeEditors(linkedList);
    }

    private static void truncate(LinkedList<Node> linkedList, int n) {
        if (linkedList.size() <= n) {
            return;
        }
        linkedList.removeFirst();
        PinningTracker.truncate(linkedList, n);
    }

    public static boolean isPinned(Node node) {
        return pinned.contains(node);
    }

    public static void pinNode(Node node) {
        DBConfig dBConfig = DBConfig.getInstance();
        int n = dBConfig.getInt("MAXOPENPLSQLEDITORS");
        if (49 <= n && dumpCount++ < 10L) {
            System.out.println("PinningTracker.pinNode(" + node.getURL() + ")");
            class PinningNodeStackTrace
            extends Exception {
                PinningNodeStackTrace() {
                }
            }
            new PinningNodeStackTrace().printStackTrace();
        }
        if (!PinningTracker.isPinned(node)) {
            pinned.add(node);
        }
    }

    public static void unpinNode(Node node) {
        pinned.remove(node);
    }
}

