/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.table.JTableHeader;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.editors.AbstractDBEditor;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorQueryUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public abstract class InfoPanel
extends AbstractDBEditor {
    private ResultSetTable _tbl;
    private IdeAction _refreshAction;
    private IdeAction _toolbarAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_Tbl_Editor");

    public void open() {
        Context context = this.getContext();
        PlSqlNode plSqlNode = (PlSqlNode)context.getNode();
        plSqlNode.addListener((Observer)this);
        this._refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Messages.getString("Refresh"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                try {
                    InfoPanel.this._tbl.refresh();
                }
                catch (ExecutionException executionException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
                }
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
    }

    public Component getGUI() {
        String string;
        Object object;
        PlSqlNode plSqlNode;
        if (this._tbl == null) {
            this._tbl = new ResultSetTable();
            this.loadDBData();
            plSqlNode = (PlSqlNode)this.getContext().getNode();
            object = plSqlNode.getConnectionName();
            if (object == null || !ModelUtil.hasLength((String)object)) {
                return this._tbl;
            }
            string = this.query();
            string = RaptorQueryUtils.promoteToDba(string, this.getConnection());
            List<String> list = this.scanBinds(string);
            this._tbl.setVerticalDisplay(this.isPivoted());
            this._tbl.setQuery((String)object, string, list, null);
            try {
                this._tbl.open(new RaptorGridTaskWrapper(MessageFormat.format(CompileArb.getString("OPENLABEL"), this.getDisplayName()), IRaptorTaskRunMode.MODAL, true, null, null, null));
            }
            catch (ExecutionException executionException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
            }
            Toolbar toolbar = this.getFixedTopMargin();
            if (toolbar.getComponentCount() == 0) {
                toolbar.add((ToggleAction)this._refreshAction);
            }
        }
        if (this._toolbarAction == null) {
            this._toolbarAction = XMLBasedObjectAction.getInstance().getIdeAction().newLocalAction((View)this);
            plSqlNode = (PlSqlNode)this.getContext().getNode();
            object = XMLBasedObjectAction.getInstance().getMenu(new DBObject(plSqlNode.getURL()));
            if (((Container)object).getComponentCount() > 0) {
                string = this.getFixedTopMargin().add((ToggleAction)this._toolbarAction);
                string.setName(this._toolbarAction.getValue("Name").toString());
                string.setText(Messages.getString("InfoPanel.Actions"));
                string.setIcon(OracleIcons.getIcon((String)"extras/dropdown.png"));
                string.setToolTipText(Messages.getString("InfoPanel.AvailableActions"));
                this._toolbarAction.putValue("BUTTON", (Object)string);
            }
        }
        return this._tbl;
    }

    private List<String> scanBinds(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = LexerToken.parse((String)string);
        boolean bl = false;
        for (LexerToken lexerToken : list) {
            if (bl) {
                if ("OBJECT_OWNER".equalsIgnoreCase(lexerToken.content) || "SCHEMA".equalsIgnoreCase(lexerToken.content)) {
                    arrayList.add(this.getSchemaName());
                } else if ("OBJECT_NAME".equalsIgnoreCase(lexerToken.content)) {
                    arrayList.add(this.getObjectName());
                } else if ("OBJECT_ID".equalsIgnoreCase(lexerToken.content)) {
                    var7_7 = this.getObjectId();
                    if (var7_7 == null) {
                        var7_7 = "-1";
                    }
                    arrayList.add(var7_7);
                } else if ("OBJECT_TYPE".equalsIgnoreCase(lexerToken.content)) {
                    var7_7 = this.getObjectType();
                    if ("EDITION_TRIGGER".equals(var7_7)) {
                        var7_7 = "TRIGGER";
                    }
                    arrayList.add(var7_7);
                }
            }
            bl = ":".equals(lexerToken.content);
        }
        return arrayList;
    }

    public Component getScrollableTopMargin() {
        JTableHeader jTableHeader = this._tbl.getTableHeader();
        return jTableHeader;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage == null) {
            this._tbl = null;
        }
    }

    public boolean isPivoted() {
        return false;
    }

    public int dbVersion() {
        PlSqlNode plSqlNode = (PlSqlNode)this.getContext().getNode();
        String string = plSqlNode.getConnectionName();
        try {
            Database database = Connections.getInstance().getDatabase(string, false);
            return database.getDatabaseVersion();
        }
        catch (DBException dBException) {
            throw new AssertionError((Object)"Failed to get dbversion");
        }
    }

    public abstract String query();
}

