/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.io.BufferedReader;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.phighlight.Issue;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.javatools.editor.BasicEditorPane;

public class ExpandAdvice
extends Issue {
    private static final String EXPANDSQL = Messages.getString("ExpandSqlStatement");
    private static final String ERROR = Messages.getString("Error");
    private static final String UNEXPECTED_ERROR = Messages.getString("UnexpectedError");
    private int length;
    static Map<String, Map<String, Issue>> expandCache = new HashMap<String, Map<String, Issue>>();

    ExpandAdvice(int n, int n2, String string, String string2) {
        super(n, n2, EXPANDSQL, Issue.Type.ADVISORY);
        this.replacement = string;
        this.length = string2.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Issue expandSQL(int n, int n2, String string, String string2) {
        Issue issue;
        Properties properties = System.getProperties();
        Object object = properties.get("sqldev.phighlight.expand");
        if (object != null) {
            return null;
        }
        Map<String, Issue> map = expandCache.get(string);
        if (map == null) {
            map = new HashMap<String, Issue>();
            expandCache.put(string, map);
        }
        if ((issue = map.get(string2)) != null) {
            if (issue instanceof ExpandAdvice) {
                ExpandAdvice expandAdvice = (ExpandAdvice)issue;
                if (string2.equals(expandAdvice.replacement)) {
                    return null;
                }
            }
            issue.from = n;
            issue.to = n2;
            return issue;
        }
        CallableStatement callableStatement = null;
        try {
            int n3;
            Connection connection = ChameleonConnection.getConnection((String)string);
            callableStatement = connection.prepareCall("begin\ndbms_utility.expand_sql_text\n( input_sql_text => :sql,\noutput_sql_text => :x );\nend;\n");
            callableStatement.setString(1, string2);
            callableStatement.registerOutParameter(2, 2005);
            callableStatement.execute();
            Clob clob = callableStatement.getClob(2);
            Reader reader = clob.getCharacterStream();
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(reader);
            while (-1 != (n3 = bufferedReader.read())) {
                stringBuilder.append((char)n3);
            }
            bufferedReader.close();
            String string3 = stringBuilder.toString();
            if (string3.length() < 50000) {
                string3 = CustomFormat.getInstance().format(string3);
                issue = new ExpandAdvice(n, n2, string3, string2);
                map.put(string3, issue);
            }
        }
        catch (SQLException sQLException) {
            issue = new Issue(n, n2, sQLException.getMessage(), true);
        }
        catch (Exception exception) {
            issue = new Issue(n, n2, exception.getMessage(), true);
        }
        finally {
            if (callableStatement != null) {
                try {
                    callableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        map.put(string2, issue);
        return issue;
    }

    @Override
    boolean isFixable() {
        return true;
    }

    @Override
    void doFix(BasicEditorPane basicEditorPane) {
        basicEditorPane.setSelectionStart(this.from);
        basicEditorPane.setSelectionEnd(this.from + this.length);
        basicEditorPane.replaceSelection(this.replacement);
    }
}

