/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.table;

import java.awt.Component;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLGenerator;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.parser.plsql.IdentifierDefinitionLookup;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.BasicFindToolbarController;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class DDLViewer
extends AsynchronousViewerEditor
implements BasicEditorPaneContainer,
EquippedWithParser,
DbEditor {
    protected BasicEditorPane _code;
    protected DBObject _lastdbObject;
    protected DBObject _dbObject;
    protected IdeAction _refreshAction;
    protected BasicFindToolbarController _findToolbarController;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");
    private KeyStrokeContext[] localContexts = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/raptor/oviewer/base/accelerators.xml")};
    private BackgroundParser parser = null;

    @Override
    protected Component getGUIComponent() {
        JComponent jComponent = (JComponent)super.getGUIComponent();
        if (null == jComponent) {
            this.setGUIComponent(this.createViewerUI());
            this.updateContent(true);
            this.setContentModelLoaded(true);
            this.getCodeArea().installPlugin((EditorPlugin)new IdentifierDefinitionLookup(this.getContext()));
        }
        return super.getGUIComponent();
    }

    @Override
    protected JComponent createViewerUI() {
        this.setCodeArea(EditorFactory.createIdeEditorPane((KeyStrokeContext[])this.localContexts));
        BasicDocument basicDocument = (BasicDocument)this.getCodeArea().getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
        this.getCodeArea().setEditable(false);
        this.getCodeArea().setCaretPosition(0);
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this.getCodeArea().installPlugin((EditorPlugin)lineGutterPlugin);
        JScrollPane jScrollPane = new JScrollPane((Component)this.getCodeArea(), 22, 32);
        jScrollPane.setRowHeaderView((Component)lineGutterPlugin);
        this._refreshAction = IdeAction.findOrCreate((int)REFRESH_EDITOR_CMD_ID, null, (String)Messages.getString("DDLViewer.2"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                DBObject.tryCheckForChanges(context);
                DDLViewer.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
        this.setPinEnabled(true);
        DDLViewer.invokeLaterAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                DDLViewer.this.buildToolbar();
            }
        });
        return jScrollPane;
    }

    private void buildToolbar() {
        Toolbar toolbar = (Toolbar)UIUtils.findFirstOfType((JComponent)((JComponent)this.getFixedTopMargin()), Toolbar.class);
        toolbar.add((ToggleAction)this._refreshAction.newLocalAction((View)this));
    }

    @Override
    protected List<JComponent> getAdditionalFixedTopMarginComponents() {
        this._findToolbarController = UIUtils.createFindToolbarController((BasicEditorPane)this.getCodeArea(), (boolean)false, (boolean)false);
        return Collections.singletonList(this._findToolbarController.getToolbarsComponent());
    }

    @Override
    protected void closeImpl(boolean bl) {
        if (this._findToolbarController != null) {
            this._findToolbarController.dispose();
            this._findToolbarController = null;
        }
        super.closeImpl(bl);
    }

    protected String getBinds() {
        return null;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    @Override
    protected void updateContent(boolean bl) {
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode != null) {
            this._dbObject = viewerNode.getDBObject();
        }
        if (bl || this._dbObject != null && (this._lastdbObject == null || this._lastdbObject.getObjectName() != this._dbObject.getObjectName())) {
            this.getCodeArea().setEditable(true);
            final Connection connection = this._dbObject.getConnection();
            RaptorTask<Object> raptorTask = new RaptorTask<Object>(Messages.getString("DDLViewer.5"), true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Connections.getInstance().lock(connection);
                    try {
                        CharSequence charSequence;
                        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
                        DDLFormat dDLFormat = new DDLFormat();
                        dDLGenerator.setFormating(dDLFormat);
                        Object object = "";
                        Object object2 = object = dDLFormat.getGrant() ? dDLGenerator.getDDL((BasicDBObject)DDLViewer.this._dbObject) + DDLViewer.this.getTerm() + dDLGenerator.getGrants((BasicDBObject)DDLViewer.this._dbObject) : dDLGenerator.getDDL((BasicDBObject)DDLViewer.this._dbObject);
                        if (DBConfig.getInstance().getBoolean("AUTO_READONLY_FORMAT").booleanValue()) {
                            object = CustomFormat.getInstance().format((String)object);
                        }
                        int n = ((String)object).trim().lastIndexOf("\n");
                        int n2 = ((String)object).trim().length();
                        if (n != -1 && n2 > n && ((StringBuilder)(charSequence = new StringBuilder(((String)object).substring(((String)object).trim().lastIndexOf("\n"), ((String)object).length())))).toString().contains("--")) {
                            charSequence = ((StringBuilder)charSequence).replace(((StringBuilder)charSequence).lastIndexOf(";"), ((StringBuilder)charSequence).lastIndexOf(";") + 1, "\n;");
                            object = ((String)object).substring(0, ((String)object).trim().lastIndexOf("\n")) + ((StringBuilder)charSequence).toString();
                        }
                        charSequence = object;
                        return charSequence;
                    }
                    catch (Exception exception) {
                        throw new TaskException((Throwable)exception);
                    }
                    finally {
                        Connections.getInstance().unlock(connection);
                    }
                }

                public boolean cancel() {
                    this.setMessage("--Generation of DDL was cancelled");
                    return true;
                }
            };
            raptorTask.setCancellable(true);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask){
                final /* synthetic */ RaptorTask val$task;
                {
                    this.val$task = raptorTask;
                }

                public void updateCodeArea(BasicEditorPane basicEditorPane, RaptorTaskEvent raptorTaskEvent) {
                    if (raptorTaskEvent.getTaskDescriptor().getStatus() == IRaptorTaskStatus.FINISHED || raptorTaskEvent.getTaskDescriptor().getStatus() == IRaptorTaskStatus.FAILED) {
                        basicEditorPane.setEditable(false);
                        basicEditorPane.setCaretPosition(0);
                        DDLViewer.this._lastdbObject = DDLViewer.this._dbObject;
                    }
                }

                public void taskCancelled(final RaptorTaskEvent raptorTaskEvent) {
                    final BasicEditorPane basicEditorPane = DDLViewer.this.getCodeArea();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            basicEditorPane.setEditable(true);
                            basicEditorPane.setText("--Generation of DDL was cancelled");
                            basicEditorPane.setEditable(false);
                            this.updateCodeArea(basicEditorPane, raptorTaskEvent);
                        }
                    });
                }

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    final BasicEditorPane basicEditorPane = DDLViewer.this.getCodeArea();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            basicEditorPane.setEditable(true);
                            basicEditorPane.setText("--Generation of DDL failed");
                            basicEditorPane.setEditable(false);
                            this.updateCodeArea(basicEditorPane, raptorTaskEvent);
                        }
                    });
                }

                public void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
                    final BasicEditorPane basicEditorPane = DDLViewer.this.getCodeArea();
                    try {
                        final Object object = this.val$task.getResult();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (object != null) {
                                    basicEditorPane.setEditable(true);
                                    basicEditorPane.setText(object.toString());
                                    basicEditorPane.setEditable(false);
                                } else {
                                    basicEditorPane.setText("--Generation of DDL was cancelled");
                                }
                                this.updateCodeArea(basicEditorPane, raptorTaskEvent);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, interruptedException.getMessage());
                    }
                    catch (ExecutionException executionException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, executionException.getMessage());
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    @Override
    public Object getPrintable() {
        return this.getCodeArea();
    }

    @Override
    protected void cleanUp() {
        this._lastdbObject = null;
        this._dbObject = null;
        this._refreshAction = null;
        if (this.parser != null) {
            this.parser.deinstall(this._code);
            this.parser = null;
        }
        this._code = null;
    }

    public Object getEditorAttribute(String string) {
        boolean bl = false;
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    private String getTerm() {
        return "\n";
    }

    protected void setCodeArea(BasicEditorPane basicEditorPane) {
        this._code = basicEditorPane;
    }

    protected BasicEditorPane getCodeArea() {
        return this._code;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_bdbtableviewer_html");
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this.getCodeArea();
    }

    @Override
    public BackgroundParser getParser() {
        if (this.parser == null) {
            this.parser = new BackgroundParser();
            this.parser.install(this.getCodeArea());
        }
        return this.parser;
    }

    @Override
    public String getConnectionName() {
        return this._dbObject.getConnectionName();
    }
}

