/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.search;

import java.awt.Component;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.oviewer.search.SearchWindow;
import oracle.dbtools.raptor.view.AbstractDockableFactory;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class NavSearchDockableFactory
extends AbstractDockableFactory {
    static final String VIEW_TYPE = "SEARCH_VIEW_TYPE";
    private static SearchWindow s_searchWindow;

    public DockableView getDockableImpl() {
        return NavSearchDockableFactory.getSearchWindow(null, null);
    }

    protected DockingParam createDockingParam() {
        DockingParam dockingParam = new DockingParam();
        DBNavigatorManager dBNavigatorManager = DBNavigatorManager.getInstance();
        if (dBNavigatorManager.getNavigatorWindow() != null) {
            dockingParam.setPosition((Dockable)dBNavigatorManager.getNavigatorWindow(), 3, 0);
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 4, 0);
        }
        return dockingParam;
    }

    protected ViewId getDefaultViewId() {
        return new ViewId(SearchWindow.getDefaultViewId());
    }

    public static SearchWindow getSearchWindow(String string, String string2) {
        if (s_searchWindow == null) {
            s_searchWindow = new SearchWindow();
        }
        if (string != null) {
            try {
                s_searchWindow.setConnectionAndInput(string, string2);
            }
            catch (DBException dBException) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)dBException.getMessage(), (String)ControlsArb.getString("ErrorEncountered"), null);
                try {
                    s_searchWindow.setConnectionAndInput("", null);
                }
                catch (DBException dBException2) {
                    // empty catch block
                }
            }
        }
        return s_searchWindow;
    }
}

