/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.cloud;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.jsoneditor.RowDataHandler;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.ui.table.GenericTable;

public class BasicCloudEditor
extends AsynchronousViewerEditor {
    private JPanel _gui = null;
    GenericTable _table;
    private CloudObject _current;
    private DefaultTableModel _model;

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        this.refreshDetails(false);
    }

    private void refreshDetails(boolean bl) {
        try {
            Node node = this._context.getNode();
            if (node == null) {
                node = (Node)this._context.getSelection()[0];
            }
            if (bl || this._current == null || this._current != (CloudObject)((IViewerNode)node).getDBObject().getElement()) {
                String string;
                List list;
                CloudObject cloudObject = null;
                if (node instanceof IViewerNode) {
                    this._current = cloudObject = (CloudObject)((IViewerNode)node).getDBObject().getElement();
                }
                if (this._table == null) {
                    this._table = new GenericTable();
                    this._model = new DefaultTableModel();
                    this._table.setModel((TableModel)this._model);
                } else {
                    this._model = new DefaultTableModel();
                    this._table.setModel((TableModel)this._model);
                }
                String string2 = cloudObject.getConnectionName();
                Session session = CConnections.getInstance().getConnection(string2, false);
                if (session != null && (list = (List)session.executeQuery(string = cloudObject.getRemoteURI().toString(), RowDataHandler.getHandler())).size() > 0) {
                    RowDataHandler.Row row = (RowDataHandler.Row)list.get(0);
                    for (RowDataHandler.Column object : row.getColumns()) {
                        this._model.addColumn(object.getName());
                    }
                    for (RowDataHandler.Row row2 : list) {
                        this._model.addRow(row2.getData());
                    }
                    this._model.fireTableDataChanged();
                }
            }
        }
        catch (SessionException sessionException) {
            sessionException.printStackTrace();
        }
    }

    @Override
    protected JComponent createViewerUI() {
        if (this._gui == null) {
            this._gui = new JPanel();
            this._gui.setLayout(new BorderLayout());
            this._gui.add((Component)this._table, "Center");
        }
        this.refreshDetails(false);
        return this._gui;
    }

    @Override
    protected void updateContent(boolean bl) {
        this.refreshDetails(bl);
    }

    @Override
    protected void cleanUp() {
        this._gui = null;
    }

    @Override
    public Object getPrintable() {
        return this._gui;
    }
}

