/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net;

import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public abstract class DefaultFormatHelper
extends DBURLFormatHelper {
    private static final Map<URL, ParsedURL> s_parsedURLs = new WeakHashMap<URL, ParsedURL>();

    private static synchronized ParsedURL getParsedURL(URL uRL) {
        ParsedURL parsedURL = s_parsedURLs.get(uRL);
        if (parsedURL == null) {
            String string = URLFileSystem.getPath((URL)uRL);
            int n = 5;
            String[] stringArray = new String[n];
            int n2 = 0;
            ParsedURL parsedURL2 = null;
            int n3 = -1;
            while (true) {
                int n4;
                if (n2 >= n) {
                    URL uRL2 = URLFactory.replacePathPart((URL)uRL, (String)string.substring(0, n3));
                    parsedURL2 = parsedURL2 == null ? new ParsedURLImpl(uRL2, stringArray) : new EnclosedURL(uRL2, parsedURL2, stringArray);
                    n2 = 0;
                    n = 2;
                    stringArray = new String[n];
                }
                if ((n4 = string.indexOf(47, n3 + 1)) < 0) break;
                String string2 = string.substring(n3 + 1, n4);
                stringArray[n2++] = DefaultFormatHelper.decode(string2);
                n3 = n4;
            }
            stringArray[n2++] = DefaultFormatHelper.decode(string.substring(n3 + 1));
            if (n2 < n) {
                String[] stringArray2 = stringArray;
                stringArray = new String[n2];
                System.arraycopy(stringArray2, 0, stringArray, 0, n2);
            } else {
                String string3 = uRL.getRef();
                if (ModelUtil.hasLength((String)string3)) {
                    int n5 = string3.indexOf(47);
                    if (n5 < 0) {
                        String[] stringArray3 = stringArray;
                        stringArray = new String[n2 + 1];
                        System.arraycopy(stringArray3, 0, stringArray, 0, n2);
                        stringArray[n2++] = DefaultFormatHelper.decode(string3);
                    } else {
                        String[] stringArray4 = stringArray;
                        stringArray = new String[n2 + 2];
                        System.arraycopy(stringArray4, 0, stringArray, 0, n2);
                        stringArray[n2++] = DefaultFormatHelper.decode(string3.substring(0, n5));
                        stringArray[n2++] = DefaultFormatHelper.decode(string3.substring(n5 + 1));
                    }
                }
            }
            parsedURL = parsedURL2 == null ? new ParsedURLImpl(uRL, stringArray) : new EnclosedURL(uRL, parsedURL2, stringArray);
            if (parsedURL != null) {
                s_parsedURLs.put(uRL, parsedURL);
            }
        }
        return parsedURL;
    }

    protected DefaultFormatHelper(String string) {
        super(string);
    }

    @Override
    protected String getConnectionNameImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return DefaultFormatHelper.getParsedURL(uRL).getConnectionName();
    }

    @Override
    protected String getCatalogImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return DefaultFormatHelper.getParsedURL(uRL).getCatalog();
    }

    @Override
    protected String getSchemaImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return DefaultFormatHelper.getParsedURL(uRL).getSchema();
    }

    @Override
    protected String getBaseTypeImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return DefaultFormatHelper.getParsedURL(uRL).getObjectType();
    }

    @Override
    protected String getNameImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return DefaultFormatHelper.getParsedURL(uRL).getObjectName();
    }

    @Override
    protected Icon getIconImpl(URL uRL) {
        Icon icon = null;
        try {
            String string = this.getConnectionNameImpl(uRL);
            ObjectFactory objectFactory = ObjectFactory.getFactory(string, Connections.getInstance().getConnection(string));
            DatabaseObject databaseObject = objectFactory.getObjectDescriptor(this.getBaseTypeImpl(uRL));
            if (databaseObject != null) {
                icon = databaseObject.getIcon();
            }
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        return icon;
    }

    @Override
    protected String getChildTypeImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return DefaultFormatHelper.getParsedURL(uRL).getChildType();
    }

    @Override
    protected String getChildNameImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return DefaultFormatHelper.getParsedURL(uRL).getChildName();
    }

    @Override
    protected URL getEnclosingURLImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        ParsedURL parsedURL = DefaultFormatHelper.getParsedURL(uRL).getEnclosingURL();
        return parsedURL != null ? parsedURL.getURL() : null;
    }

    @Override
    protected URL getTypeURLImpl(URL uRL) {
        assert (uRL != null);
        assert (this.getProtocol().equals(uRL.getProtocol()));
        return DefaultFormatHelper.getParsedURL(uRL).getTypeURL();
    }

    private static interface ParsedURL {
        public String getConnectionName();

        public String getCatalog();

        public String getSchema();

        public String getObjectType();

        public String getObjectName();

        public ParsedURL getEnclosingURL();

        public URL getURL();

        public String getChildType();

        public String getChildName();

        public URL getTypeURL();
    }

    private static final class ParsedURLImpl
    implements ParsedURL {
        private static int CNAME_PART = 0;
        private static int CATALOG_PART = CNAME_PART + 1;
        private static int SCHEMA_PART = CATALOG_PART + 1;
        private static int BASETYPE_PART = SCHEMA_PART + 1;
        private static int NAME_PART = BASETYPE_PART + 1;
        private static int CHILDTYPE_PART = NAME_PART + 1;
        private static int CHILDNAME_PART = CHILDTYPE_PART + 1;
        private final String[] m_parts = new String[CHILDNAME_PART + 1];
        private final URL m_url;

        ParsedURLImpl(URL uRL, String ... stringArray) {
            this.m_url = uRL;
            System.arraycopy(stringArray, 0, this.m_parts, 0, Math.min(stringArray.length, this.m_parts.length));
        }

        @Override
        public String getConnectionName() {
            return this.m_parts[CNAME_PART];
        }

        @Override
        public String getCatalog() {
            return this.m_parts[CATALOG_PART];
        }

        @Override
        public String getSchema() {
            return this.m_parts[SCHEMA_PART];
        }

        @Override
        public String getObjectType() {
            return this.m_parts[BASETYPE_PART];
        }

        @Override
        public String getObjectName() {
            return this.m_parts[NAME_PART];
        }

        @Override
        public ParsedURL getEnclosingURL() {
            return null;
        }

        @Override
        public URL getURL() {
            return this.m_url;
        }

        @Override
        public String getChildType() {
            return this.m_parts[CHILDTYPE_PART];
        }

        @Override
        public String getChildName() {
            return this.m_parts[CHILDNAME_PART];
        }

        @Override
        public URL getTypeURL() {
            if (this.m_parts[BASETYPE_PART] != null) {
                if (this.m_parts[NAME_PART] == null) {
                    return this.m_url;
                }
                return DBURLFormatHelper.getURL(this.m_url.getProtocol(), this.m_parts[CNAME_PART], this.m_parts[CATALOG_PART], this.m_parts[SCHEMA_PART], this.m_parts[BASETYPE_PART]);
            }
            return null;
        }
    }

    private static final class EnclosedURL
    implements ParsedURL {
        private static int BASETYPE_PART = 0;
        private static int NAME_PART = BASETYPE_PART + 1;
        private static int CHILDTYPE_PART = NAME_PART + 1;
        private static int CHILDNAME_PART = CHILDTYPE_PART + 1;
        private final ParsedURL m_enclosingURL;
        private final URL m_url;
        private final String[] m_parts = new String[CHILDNAME_PART + 1];

        EnclosedURL(URL uRL, ParsedURL parsedURL, String ... stringArray) {
            this.m_url = uRL;
            this.m_enclosingURL = parsedURL;
            System.arraycopy(stringArray, 0, this.m_parts, 0, Math.min(stringArray.length, this.m_parts.length));
        }

        @Override
        public String getConnectionName() {
            return this.m_enclosingURL.getConnectionName();
        }

        @Override
        public String getCatalog() {
            return this.m_enclosingURL.getCatalog();
        }

        @Override
        public String getSchema() {
            return this.m_enclosingURL.getSchema();
        }

        @Override
        public String getObjectType() {
            return this.m_parts[BASETYPE_PART];
        }

        @Override
        public String getObjectName() {
            return this.m_parts[NAME_PART];
        }

        @Override
        public ParsedURL getEnclosingURL() {
            return this.m_enclosingURL;
        }

        @Override
        public URL getURL() {
            return this.m_url;
        }

        @Override
        public String getChildType() {
            return this.m_parts[CHILDTYPE_PART];
        }

        @Override
        public String getChildName() {
            return this.m_parts[CHILDNAME_PART];
        }

        @Override
        public URL getTypeURL() {
            return DBURLFormatHelper.getURL(this.m_enclosingURL.getURL(), this.m_parts[BASETYPE_PART]);
        }
    }
}

