/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.model;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.ide.model.Element;

public abstract class NavigatorQueryTask
extends DatabaseQueryTask<Collection<Element>> {
    private String m_connName;
    private volatile Thread m_execThread;

    protected NavigatorQueryTask(String string, String string2, boolean bl) {
        super(string, IRaptorTaskRunMode.IDE_STATUSBAR, false, bl, true);
        this.m_connName = string2;
    }

    protected NavigatorQueryTask(String string, String string2) {
        this(string, string2, false);
    }

    public String getConnectionName() {
        return this.m_connName;
    }

    public String getQuery() {
        return "";
    }

    protected final Collection<Element> doWork() throws TaskException {
        this.m_execThread = Thread.currentThread();
        try {
            Collection<Element> collection = this.doWorkImpl();
            return collection;
        }
        finally {
            this.m_execThread = null;
        }
    }

    protected abstract Collection<Element> doWorkImpl() throws TaskException;

    public final boolean cancel() {
        Thread thread = this.m_execThread;
        if (thread != null) {
            DBUtil.cancelExecution((Thread)thread);
        }
        return true;
    }

    protected void checkStatus(String string) throws AbortException {
        try {
            this.checkCanProceed();
        }
        catch (ExecutionException executionException) {
            throw new AbortException(string);
        }
    }
}

