/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.navigator.db.ConnectionFolderOwner;
import oracle.dbtools.raptor.navigator.folders.ConnectionFolderOwnerTreeNode;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.dnd.ConnectionDragHelper;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DropHelper;

public class ConnectionDropHelper
implements DropHelper {
    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        NavigatorTreeNode navigatorTreeNode;
        Element element;
        return n == 2 && Arrays.asList(dataFlavorArray).contains(ConnectionDragHelper.CONN_NODE_FLAVOR) && ((element = (navigatorTreeNode = (NavigatorTreeNode)object).getElement()) instanceof DatabasesFolder || element instanceof ConnectionFolderOwner);
    }

    public float getWeight() {
        return 10.0f;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        NavigatorTreeNode navigatorTreeNode;
        NavigatorTreeNode navigatorTreeNode2;
        boolean bl = false;
        List<Element> list = this.getConnectionNodes(transferableArray);
        if (list.size() > 0 && (navigatorTreeNode2 = (navigatorTreeNode = (NavigatorTreeNode)object).findAncestorTreeNode(ConnectionFolderOwner.class, true)) instanceof ConnectionFolderOwnerTreeNode) {
            bl = true;
            ConnectionFolderOwnerTreeNode connectionFolderOwnerTreeNode = (ConnectionFolderOwnerTreeNode)navigatorTreeNode2;
            TreePath treePath = navigatorTreeNode == navigatorTreeNode2 ? null : connectionFolderOwnerTreeNode.getTreePath(navigatorTreeNode);
            for (Element element : list) {
                NavigatorTreeNode navigatorTreeNode3 = navigatorTreeNode2.getOwningNavigatorTree().findTreeNode(element, navigatorTreeNode2);
                if (navigatorTreeNode3 == null || navigatorTreeNode3.isNodeDescendant(navigatorTreeNode)) continue;
                connectionFolderOwnerTreeNode.updateFolder(connectionFolderOwnerTreeNode.getOwningNavigatorTree(), treePath, new Element[]{element});
            }
        }
        return bl;
    }

    private List<Element> getConnectionNodes(Transferable[] transferableArray) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Transferable transferable : transferableArray) {
            if (!transferable.isDataFlavorSupported(ConnectionDragHelper.CONN_NODE_FLAVOR)) continue;
            try {
                arrayList.add((Element)transferable.getTransferData(ConnectionDragHelper.CONN_NODE_FLAVOR));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.warn(this.getClass(), (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Logger.warn(this.getClass(), (Throwable)iOException);
            }
        }
        return arrayList;
    }
}

