/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.xml.AbstractFilterableItemInstance;
import oracle.dbtools.raptor.navigator.db.xml.FilterCache;
import oracle.dbtools.raptor.navigator.db.xml.Predicate;
import oracle.dbtools.raptor.navigator.db.xml.QueryAttributeInstance;
import oracle.dbtools.raptor.navigator.db.xml.XmlObjectFactory;
import oracle.dbtools.raptor.navigator.db.xml.XmlSchemaImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlTypeOwnerInstance;
import oracle.dbtools.raptor.navigator.filter.FilterResources;
import oracle.dbtools.raptor.navigator.filter.SchemaFilterPanel;
import oracle.dbtools.raptor.query.QueryParameter;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.javatools.data.PropertyStorage;

class XmlSchemaInstance
extends XmlTypeOwnerInstance
implements DBSchemaInstance {
    private static Map<String, FilterWrapper> s_filterMap = new HashMap<String, FilterWrapper>();
    private String m_key;

    XmlSchemaInstance(XmlObjectFactory xmlObjectFactory, XmlSchemaImpl xmlSchemaImpl) {
        super(xmlObjectFactory, xmlSchemaImpl);
    }

    @Override
    public boolean promptForSchemaFilter() {
        Object object;
        boolean bl = false;
        QueryAttributeInstance queryAttributeInstance = this.getSchemaFilter();
        if (queryAttributeInstance == null) {
            object = NameParam.INSTANCE;
            queryAttributeInstance = new QueryAttributeInstance((QueryParameter)object);
        }
        object = new SchemaFilterPanel();
        Namespace namespace = new Namespace();
        namespace.put("Attribute", (Object)queryAttributeInstance);
        namespace.put("Details", (Object)this.getObjectFactory().getConnectionTypeDescriptor().getImpl().getFilterDetails());
        String string = FilterResources.getString("SCHEMA_FILTER_TITLE");
        object.setHelpID("f1_navfilters_html");
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), string, (Traversable)object, namespace);
        tDialogLauncher.setPackDialog(true);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setInitialFocus(((SchemaFilterPanel)((Object)object)).getInitialFocusComponent());
        if (tDialogLauncher.showDialog()) {
            this.setSchemaFilter((QueryAttributeInstance)namespace.find("Attribute"));
            bl = true;
        }
        tDialogLauncher.dispose();
        return bl;
    }

    @Override
    public void clearFilter() {
        this.setSchemaFilter(null);
    }

    static QueryAttributeInstance getSchemaFilter(String string) {
        FilterWrapper filterWrapper = s_filterMap.get(string);
        if (filterWrapper == null) {
            QueryAttributeInstance queryAttributeInstance = XmlSchemaInstance.loadFilter(string);
            filterWrapper = new FilterWrapper(queryAttributeInstance);
            s_filterMap.put(string, filterWrapper);
        }
        return filterWrapper.m_filter;
    }

    QueryAttributeInstance getSchemaFilter() {
        return XmlSchemaInstance.getSchemaFilter(this.getKey());
    }

    void setSchemaFilter(QueryAttributeInstance queryAttributeInstance) {
        s_filterMap.put(this.getKey(), new FilterWrapper(queryAttributeInstance));
        this.persistFilter(queryAttributeInstance);
    }

    @Override
    public boolean isSchemaFiltered() {
        return XmlSchemaInstance.getSchemaFilter(this.getKey()) != null;
    }

    private void persistFilter(QueryAttributeInstance queryAttributeInstance) {
        List<Map<String, Object>> list = null;
        if (queryAttributeInstance != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("ARG_NAME", queryAttributeInstance.getAttribute().getName());
            hashMap.put("ARG_PRED", queryAttributeInstance.getPredicate().name());
            hashMap.put("ARG_VALS", queryAttributeInstance.getValues());
            hashMap.put("ARG_CASE", Boolean.toString(queryAttributeInstance.isCaseSensitive()));
            list = Collections.singletonList(hashMap);
        } else {
            list = Collections.emptyList();
        }
        FilterCache.getInstance((PropertyStorage)Preferences.getPreferences()).setFilterArguments(this.getKey(), list);
    }

    private static QueryAttributeInstance loadFilter(String string) {
        Map<String, Object> map;
        String string2;
        List<Map<String, Object>> list = FilterCache.getInstance((PropertyStorage)Preferences.getPreferences()).getFilterArguments(string);
        if (list != null && list.size() > 0 && "NAME".equals(string2 = (String)(map = list.get(0)).get("ARG_NAME"))) {
            return new QueryAttributeInstance(NameParam.INSTANCE, Predicate.valueOf((String)map.get("ARG_PRED")), (String[])map.get("ARG_VALS"), Boolean.valueOf((String)map.get("ARG_CASE")));
        }
        return null;
    }

    protected String getKey() {
        if (this.m_key == null) {
            this.m_key = AbstractFilterableItemInstance.createSchemaKey(this);
        }
        return this.m_key;
    }

    private static final class NameParam
    extends QueryParameter {
        private static final NameParam INSTANCE = new NameParam();

        private NameParam() {
        }

        public String toXML(int n) {
            return null;
        }

        static {
            INSTANCE.setName("NAME");
            INSTANCE.setPrompt(FilterResources.getString("SCHEMA_FILTER_NAME_ATTRIBUTE_LABEL"));
        }
    }

    private static class FilterWrapper {
        private QueryAttributeInstance m_filter;

        private FilterWrapper(QueryAttributeInstance queryAttributeInstance) {
            this.m_filter = queryAttributeInstance;
        }
    }
}

