/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.raptor.config.NavigatorFilterConfig;
import oracle.dbtools.raptor.navigator.db.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBTypeOwnerInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.Element;

public abstract class TypeContainerTreeNode
extends AsynchronousNavigatorTreeNode {
    protected TypeContainerTreeNode() {
        this.setComparator(new C());
    }

    protected final List<Element> loadTypeFolders(DBTypeOwnerInstance dBTypeOwnerInstance, String string, String string2, String string3) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        String string4 = this.getURLProtocol();
        if (string4 != null) {
            String string5 = dBTypeOwnerInstance.getObjectFactory().getConnectionType();
            boolean bl = this.isNavigationFilterEnabled() && string4.equals("sqldev.nav") && (string5.equals("Oracle") || string5.equals("TimesTen"));
            Set<String> set = this.getNodesFromPreference(string5);
            for (DBFolderInstance dBFolderInstance : dBTypeOwnerInstance.listTypeFolders()) {
                String string6 = dBFolderInstance.getType();
                URL uRL = DBURLFormatHelper.getURL(string4, string, string2, string3, string6);
                Element element = this.createTypeFolder(dBFolderInstance, uRL);
                if (bl && !set.contains(string6)) continue;
                arrayList.add(element);
            }
        }
        return arrayList;
    }

    private Element createTypeFolder(DBFolderInstance dBFolderInstance, URL uRL) {
        return DatabaseNavigatorElementFactory.getTypeFolder(uRL, dBFolderInstance);
    }

    protected Set<String> getNodesFromPreference(String string) {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        Set<String> set = null;
        Map<String, Object> map = null;
        if (string.equals("Oracle")) {
            map = navigatorFilterConfig.getAllOracleElements();
        }
        if (string.equals("TimesTen")) {
            map = navigatorFilterConfig.getAllTimesTenElements();
        }
        if (map != null) {
            set = this.processTypeMap(map);
        }
        return set;
    }

    private Set<String> processTypeMap(Map<String, Object> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Set<String> set;
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Boolean) {
                if (!((Boolean)object).booleanValue()) continue;
                hashSet.add(string);
                continue;
            }
            if (!(object instanceof Map) || (set = this.processTypeMap((Map)object)).size() <= 0) continue;
            hashSet.add(string);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    protected boolean isNavigationFilterEnabled() {
        NavigatorFilterConfig navigatorFilterConfig = NavigatorFilterConfig.getInstance();
        boolean bl = navigatorFilterConfig.isFeatureEnabled();
        return bl;
    }

    private void printTreeMap(TreeMap<String, Object> treeMap, String string) {
        System.out.println("----- printTreeMap ------------");
        System.out.println("----- " + string);
        System.out.println("----- printTreeMap ------------");
        if (treeMap != null) {
            for (String string2 : treeMap.keySet()) {
                Object object = treeMap.get(string2);
                if (object == null) continue;
                if (object instanceof Boolean) {
                    System.out.println("---- ----[" + string2 + "," + object + "]");
                }
                if (!(object instanceof TreeMap)) continue;
                this.printTreeMap((TreeMap)object, string2);
            }
        }
        System.out.println("------ printTreeMap ------------");
    }

    private static class C
    implements Comparator<NavigatorTreeNode> {
        private C() {
        }

        @Override
        public int compare(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode navigatorTreeNode2) {
            if (navigatorTreeNode == navigatorTreeNode2) {
                return 0;
            }
            Element element = navigatorTreeNode.getElement();
            Element element2 = navigatorTreeNode2.getElement();
            if (element instanceof OtherSchemasFolder) {
                return 1;
            }
            if (element2 instanceof OtherSchemasFolder) {
                return -1;
            }
            double d = this.getWeight(element);
            double d2 = this.getWeight(element2);
            if (d != Double.NEGATIVE_INFINITY && d2 != Double.NEGATIVE_INFINITY) {
                double d3 = d - d2;
                if (d3 < 0.0) {
                    return -1;
                }
                if (d3 > 0.0) {
                    return 1;
                }
            }
            return element.toString().compareTo(element2.toString());
        }

        private double getWeight(Element element) {
            double d = Double.NEGATIVE_INFINITY;
            if (element instanceof ObjectFolder) {
                DBFolderInstance dBFolderInstance = ((ObjectFolder)element).getFolderInstance();
                DatabaseFolder databaseFolder = (DatabaseFolder)dBFolderInstance.getDescriptor();
                d = databaseFolder.getWeight();
            } else if (element instanceof CategoryFolder) {
                CategoryInstance categoryInstance = ((CategoryFolder)element).getCategoryInstance();
                ObjectCategory objectCategory = (ObjectCategory)categoryInstance.getDescriptor();
                d = objectCategory.getWeight();
            }
            return d;
        }
    }
}

