/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.panels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ExtendedTextField;

public class PredicatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String _baseSql;
    private ArrayList<String> _partitions;
    private ExtendedTextField _objectPredicate;
    private JTextField _globalPredicate;
    private JButton apply;
    private JLabel _objectWhere = new JLabel(ExtractResources.getString((String)"EO_PRED_OBJ_WHERE"));
    private JLabel _globalWhere = new JLabel(ExtractResources.getString((String)"EO_PRED_GLOBAL_WHERE"));
    private JLabel _and = new JLabel(ExtractResources.getString((String)"EO_PRED_AND"));
    private ResultSetTable _sampleTab;
    private String _conn;
    private String _globalPredicateText;
    private List _bindList = null;
    private Map _bindMap = null;
    private boolean _dirty = true;
    private boolean _verticalDiaplay = false;
    private boolean _showGlobal = true;
    private JLabel _lblSampleData = new JLabel(ExtractResources.getString((String)"EO_PRED_SAMPLE"));
    private ExtractObject _dataObject;
    private int _rowCount = 0;

    public PredicatePanel(ExtractObject extractObject, String string) {
        this(extractObject, string, true, false);
    }

    public PredicatePanel(ExtractObject extractObject, String string, boolean bl) {
        this(extractObject, string, bl, false);
    }

    public PredicatePanel(ExtractObject extractObject, String string, boolean bl, boolean bl2) {
        this._dataObject = extractObject;
        this._globalPredicateText = extractObject.getListModel().getGlobalWhere();
        this._bindMap = this._dataObject.getBindMap();
        this._bindList = extractObject.getBindList();
        this._showGlobal = bl;
        this.showPanel(this._dataObject.getSourceConnName(), this._dataObject.getSqlForVisibleCols());
        this.setPredicate(string);
        this._dirty = true;
        SwingUtilities.invokeLater(() -> {
            this.showSampleData();
            if (bl2) {
                this._dataObject.isDataPrepared(false);
            }
        });
    }

    public PredicatePanel(String string, String string2, List list) {
        this._bindList = list;
        this.showPanel(string, string2);
    }

    public PredicatePanel(String string, String string2, Map map) {
        this._bindMap = map;
        this.showPanel(string, string2);
    }

    public PredicatePanel(String string, String string2) {
        this.showPanel(string, string2);
    }

    protected ExtractObject getDataObject() {
        return this._dataObject;
    }

    public void PredicatePanelRefresh(String string) {
        if (string != null && !this._baseSql.equals(string)) {
            this.showPanelRefresh(this._conn, string);
        }
    }

    public void showPanelRefresh(String string, String string2) {
        String string3 = this.getPredicate();
        this.removeAll();
        this.showPanel(string, string2);
        this.setPredicate(string3);
        this.validate();
    }

    public void showPanel(String string, String string2) {
        this._baseSql = string2;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttablepredicate_html");
        this.setLayout(new SpringLayout());
        this._globalPredicate = new JTextField(this._globalPredicateText);
        this._objectPredicate = new ExtendedTextField();
        String string3 = this.getObjectWhereToolTip();
        if (string3 != null && !string3.isEmpty()) {
            this._objectPredicate.setToolTipText(string3);
        }
        this._objectPredicate.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                PredicatePanel.this._dirty = true;
                if (keyEvent.getKeyChar() == '\n') {
                    PredicatePanel.this.showSampleData();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.apply = new JButton();
        this.apply.setText(ExtractResources.getString((String)"EO_PRED_GO"));
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredicatePanel.this._dirty = true;
                if (PredicatePanel.this._dataObject.getColumns() == null || PredicatePanel.this._dataObject.getColumns().isEmpty()) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)ExtractResources.getString((String)"NO_COL_ERROR"), (String)ExtractResources.getString((String)"WHERE_ERROR_TITLE"), (String)"SELECTION_CRITERIA_ERROR");
                } else {
                    PredicatePanel.this.showSampleData();
                }
            }
        });
        this._sampleTab = new ResultSetTable();
        this._sampleTab.setColumnSelectorAvailable(false);
        this._sampleTab.getTableHeader().setReorderingAllowed(false);
        this._sampleTab.setEnabled(false);
        this._conn = string;
        this.setLayout(new GridBagLayout());
        int n = 0;
        if (this._showGlobal) {
            this.add((Component)this._globalWhere, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
            this.add((Component)this._globalPredicate, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            this.add((Component)this._and, LayoutControl.GBC.gbc(2, n, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
            this._globalWhere.setEnabled(false);
        }
        this.add((Component)this._objectWhere, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add((Component)this._objectPredicate, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.add((Component)this.apply, LayoutControl.GBC.gbc(2, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this._lblSampleData, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.SECTION_LINE_START_COMP));
        this.add((Component)new JScrollPane((Component)((Object)this._sampleTab)), LayoutControl.GBC.gbc(1, n, 2, 18, LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
    }

    protected String getObjectWhereToolTip() {
        return "";
    }

    public void setVerticalDisplay(boolean bl) {
        this._verticalDiaplay = bl;
        if (this._sampleTab != null) {
            this._sampleTab.setVerticalDisplay(this._verticalDiaplay);
        }
        this.apply.setVisible(!bl);
        this._objectPredicate.setVisible(!bl);
        this._objectWhere.setVisible(!bl);
        this._lblSampleData.setVisible(!bl);
    }

    public void showSampleData() {
        String string = this.getSQL().trim();
        String string2 = null;
        if (this._dirty) {
            if (this._sampleTab.getModel() instanceof ResultSetTableModel && ((ResultSetTableModel)((Object)this._sampleTab.getModel())).getSql() != null) {
                string2 = ((ResultSetTableModel)((Object)this._sampleTab.getModel())).getSql().trim();
            }
            if ((this._sampleTab.getModel() instanceof DefaultTableModel || string2 != null && !string2.equals(string)) && this._conn != null) {
                this._sampleTab.setQuery(this._conn, string, this._bindList, this._bindMap);
                try {
                    this._sampleTab.open(true);
                    this._dirty = false;
                    this._rowCount = this._sampleTab.getModel().getRowCount();
                }
                catch (Throwable throwable) {
                    ExceptionHandler.handleException((String)this._conn, (Throwable)throwable);
                }
            }
        }
        this._dirty = false;
    }

    public int getRowCount() {
        return this._sampleTab == null ? 0 : this._sampleTab.getModel().getRowCount();
    }

    public List<IRaptorTaskListener> getTaskListeners() {
        return null;
    }

    public void setSQL(String string) {
        string.intern();
        if (!this._baseSql.equals(string)) {
            this._baseSql = string;
            this._dirty = true;
            this._baseSql.intern();
        }
    }

    public void setPredicate(String string) {
        this._objectPredicate.setText(string);
    }

    public ArrayList<String> getPartitions() {
        return this._partitions;
    }

    public void setPartitions(ArrayList<String> arrayList) {
        this._partitions = arrayList;
        this._dirty = true;
    }

    @Override
    public String toString() {
        String string = this._objectPredicate.getText();
        return string != null ? string : "";
    }

    public String getSQL() {
        if (this._partitions == null || this._partitions.size() == 1 && this._partitions.get(0).equals("*")) {
            return this._baseSql + " " + this.getPredicate() + this.getGlobalPredicate();
        }
        StringBuffer stringBuffer = new StringBuffer();
        BasicDBObject basicDBObject = this._dataObject.getDBObject();
        String string = PredicatePanel.isHiveConnection(basicDBObject.getConnectionName()) ? basicDBObject.getSchemaName() + "." + basicDBObject.getObjectName() : DBUtil.addDoubleQuote((String)basicDBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)basicDBObject.getObjectName());
        for (String string2 : this._partitions) {
            stringBuffer.append("select " + this._dataObject.getColumns() + " from " + string + " PARTITION (" + string2 + ") " + this.getPredicate() + " UNION ALL ");
        }
        String string3 = stringBuffer.toString();
        return string3.length() > 10 ? string3.substring(0, string3.length() - 10) : "";
    }

    public static boolean isHiveConnection(String string) {
        Properties properties;
        String string2;
        return !Connections.getInstance().isOracle(string) && (string2 = (properties = Connections.getInstance().getConnectionInfo(string)).getProperty("subtype")).equals("Hive");
    }

    public String getBaseSql() {
        return this._baseSql;
    }

    public String getPredicate(boolean bl) {
        Object object = this._objectPredicate.getText();
        if (!((String)object).equals("")) {
            if (bl) {
                if (((String)object).trim().toLowerCase().indexOf("where ") != 0) {
                    object = " where " + (String)object;
                }
            } else if (((String)object).trim().toLowerCase().indexOf("where ") == 0) {
                object = ((String)object).substring(6);
            }
        }
        return object;
    }

    public String getPredicate() {
        Object object = this._objectPredicate.getText();
        if (!((String)object).equals("") && ((String)object).trim().toLowerCase().indexOf("where") != 0) {
            object = " where " + (String)object;
        }
        return object;
    }

    public String getGlobalPredicate() {
        Object object;
        String string = this._objectPredicate.getText();
        Object object2 = object = this._globalPredicateText != null ? this._globalPredicateText : "";
        if (((String)object).length() > 0) {
            object = string.length() == 0 ? " where " + (String)object : " and " + (String)object;
        }
        return object;
    }

    public ResultSetTable getTable() {
        if (this._dirty) {
            this.showSampleData();
            this._dirty = false;
        }
        return this._sampleTab;
    }

    public void setDirty() {
        this._dirty = true;
    }

    public boolean isDirty() {
        return this._dirty;
    }
}

