/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.models.BasicExtractSqlHandler;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.extract.models.ExtractObjectSqlModel;
import oracle.dbtools.extract.models.IExtractSqlHandler;
import oracle.dbtools.insight.BasicSuggestedItem;
import oracle.dbtools.insight.BasicTabCol;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.format.IResultsFormatterWrapper;
import oracle.dbtools.raptor.format.ResultSetFormatterWrapper;
import oracle.dbtools.raptor.format.ui.TableFormatterWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.dbtools.util.Logger;

public class UIExtractSqlHandler
extends BasicExtractSqlHandler
implements IExtractSqlHandler {
    private static IExtractSqlHandler handler;

    public static void setHandler(IExtractSqlHandler iExtractSqlHandler) {
        handler = iExtractSqlHandler;
    }

    public String getInternalTableName(ExtractObject extractObject) {
        JTable jTable = (JTable)extractObject.getTable();
        String string = "";
        if (jTable instanceof ResultSetTable) {
            string = ((ResultSetTable)((Object)jTable)).getDefaultExportName();
        }
        if (string == null || string.length() == 0) {
            return super.getInternalTableName(extractObject);
        }
        return string;
    }

    public boolean isTableDirty(ExtractObject extractObject) {
        JTable jTable = (JTable)extractObject.getTable();
        if (jTable != null && jTable.getModel() != null && jTable.getModel() instanceof ResultSetTableModel) {
            if (((ResultSetTableModel)((Object)jTable.getModel())).getSql() != null) {
                if (extractObject.getFinalWhere().length() == 0) {
                    return false;
                }
                return !((ResultSetTableModel)((Object)jTable.getModel())).getSql().equals(extractObject.getFinalSQL());
            }
            return true;
        }
        return false;
    }

    public IResultsFormatterWrapper getDataProvider(ExtractObject extractObject) throws Exception {
        JTable jTable = (JTable)extractObject.getTable();
        ExtractObjectSqlModel extractObjectSqlModel = extractObject.getSqlModel();
        extractObjectSqlModel.isExtractOwnedRS(false);
        if (extractObject.isTypeDataFile() || jTable == null) {
            return super.getDataProvider(extractObject);
        }
        if (extractObject.isTableDirty() || extractObject.isExcludedColumns()) {
            super.getDataProvider(extractObject);
        }
        boolean bl = false;
        if (jTable instanceof ResultSetTable) {
            bl = ((ResultSetTable)((Object)jTable)).allRowsFetched();
        }
        if (!bl) {
            Connection connection = Connections.getInstance().getConnection(((ResultSetTableModel)((Object)jTable.getModel())).getConnectionName());
            String string = ((ResultSetTableModel)((Object)jTable.getModel())).getModifiedSql();
            Map<String, ?> map = ((ResultSetTableModel)((Object)jTable.getModel())).getBindMap();
            List<?> list = ((ResultSetTableModel)((Object)jTable.getModel())).getBindList();
            ResultSet resultSet = this.getClonedResultSetForTableSql(connection, string, map, list);
            extractObjectSqlModel.setClonedRS(resultSet);
            extractObjectSqlModel.isExtractOwnedRS(resultSet != null);
            TableModel tableModel = jTable.getModel();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            TableFormatterWrapper tableFormatterWrapper = new TableFormatterWrapper(jTable);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            int[] nArray = new int[tableFormatterWrapper.getColumnCount()];
            int[] nArray2 = new int[tableFormatterWrapper.getColumnCount()];
            IResultSetTableModel iResultSetTableModel = UIExtractSqlHandler.getBaseModel(tableModel);
            for (int i = 0; i < tableFormatterWrapper.getColumnCount(); ++i) {
                int n2;
                n = n2 = tableColumnModel.getColumn(i).getModelIndex();
                arrayList.add(n);
                nArray[i] = tableFormatterWrapper.getColumnSize(i);
                arrayList2.add(tableFormatterWrapper.getColumnName(i));
                nArray2[i] = iResultSetTableModel != null ? iResultSetTableModel.getColumnSqlType(n2) : 0;
            }
            return new ResultSetFormatterWrapper(extractObjectSqlModel.getClonedRS(), arrayList, arrayList2, nArray, nArray2, string);
        }
        return new TableFormatterWrapper(jTable);
    }

    private static IResultSetTableModel getBaseModel(TableModel tableModel) {
        if (tableModel instanceof TableSorter) {
            tableModel = ((TableSorter)tableModel).getTableModel();
        }
        return tableModel instanceof IResultSetTableModel ? (IResultSetTableModel)((Object)tableModel) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet getClonedResultSetForTableSql(Connection connection, String string, Map<String, ?> map, List<?> list) throws Exception {
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            if (connection != null && (bl = Connections.getInstance().lock(connection))) {
                resultSet = map != null ? DBUtil.getInstance((Connection)connection).executeQuery(string, map) : DBUtil.getInstance((Connection)connection).executeQuery(string, list);
            }
        }
        finally {
            if (connection != null && bl) {
                Connections.getInstance().unlock(connection);
            }
        }
        return resultSet;
    }

    public void dataPrepare(ExtractObject extractObject) {
        ExtractObjectSqlModel extractObjectSqlModel = extractObject.getSqlModel();
        BasicDBObject basicDBObject = extractObject.getDBObject();
        JTable jTable = (JTable)extractObject.getTable();
        if (extractObject.getType() == 0 && extractObject.getTable() == null) {
            this.initSqlForDBO(extractObject);
            this.scrubColList(extractObject);
            extractObjectSqlModel.isDataPrepared(true);
            extractObjectSqlModel.setColumns("*");
            if (extractObject.getTable() == null && extractObject.isSourceConnTimesTen()) {
                ResultSetTable resultSetTable = new ResultSetTable();
                resultSetTable.setQuery(basicDBObject.getConnectionName(), extractObject.getSqlForVisibleCols(), extractObjectSqlModel.getBindList(), extractObjectSqlModel.getBindMap());
                try {
                    resultSetTable.open(false);
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                }
                extractObject.setTable((Object)resultSetTable);
            }
        } else {
            this.initSqlForQuery(extractObject);
            this.scrubColList(extractObject);
            this.finalizeSqlForQuery(extractObject);
            extractObjectSqlModel.setColumns("*");
            extractObject.setWhere("");
            extractObjectSqlModel.isDataPrepared(true);
        }
    }

    private void initSqlForQuery(ExtractObject extractObject) {
        ExtractObjectSqlModel extractObjectSqlModel = extractObject.getSqlModel();
        JTable jTable = (JTable)extractObject.getTable();
        StringBuilder stringBuilder = new StringBuilder();
        if (jTable.getModel() instanceof IResultSetTableModel) {
            try {
                extractObjectSqlModel.isVertical(((IResultSetTableModel)((Object)jTable.getModel())).isVerticalDisplay());
                extractObjectSqlModel.setSql(((IResultSetTableModel)((Object)jTable.getModel())).getModifiedSql());
                int n = 0;
                n = !extractObjectSqlModel.isVertical() ? jTable.getColumnCount() : ((IResultSetTableModel)((Object)jTable.getModel())).getResultSetMetaData().getColumnCount();
                boolean bl = false;
                String string = null;
                for (int i = 0; i < n; ++i) {
                    string = !extractObjectSqlModel.isVertical() ? jTable.getColumnName(i) : ((IResultSetTableModel)((Object)jTable.getModel())).getResultSetMetaData().getColumnName(i + 1);
                    if (!("ORA_ROWSCN".equals(string) || "ROWID".equals(string) || "SDEV_LINK_OWNER".equals(string) || "SDEV_LINK_NAME".equals(string) || "SDEV_LINK_TYPE".equals(string) || "SDEV_LINK_LINE".equals(string))) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        if (string.equals("TABLESPACE NAME") && (extractObjectSqlModel.getSql().contains("tablespace_name") || extractObjectSqlModel.getSql().contains("TABLESPACE_NAME"))) {
                            string = "TABLESPACE_NAME";
                        } else if (string.equals("PCT USED") && (extractObjectSqlModel.getSql().contains("pct_used") || extractObjectSqlModel.getSql().contains("PCT_USED"))) {
                            string = "PCT_USED";
                        } else if (string.equals("PERCENT USED") && (extractObjectSqlModel.getSql().contains("percent_used") || extractObjectSqlModel.getSql().contains("PERCENT USED"))) {
                            string = "PERCENT_USED";
                        }
                        stringBuilder.append(DBUtil.addDoubleQuote((String)string));
                    }
                    if (!"LEVEL".equals(string) || !extractObjectSqlModel.getSql().contains("CONNECT BY") && !extractObjectSqlModel.getSql().contains("connect by")) continue;
                    bl = true;
                }
                if (!bl) {
                    extractObjectSqlModel.setSql("SELECT " + stringBuilder + " FROM (" + extractObjectSqlModel.getSql() + ")");
                }
                extractObjectSqlModel.setRawSql(extractObjectSqlModel.getSql());
                extractObjectSqlModel.setBindMap(((IResultSetTableModel)((Object)jTable.getModel())).getBindMap());
                extractObjectSqlModel.setBindList(((IResultSetTableModel)((Object)jTable.getModel())).getBindList());
                if (extractObjectSqlModel.getSql().trim().toLowerCase().startsWith("--notextendable")) {
                    extractObjectSqlModel.isSqlExtendable(false);
                } else {
                    extractObjectSqlModel.isSqlExtendable(true);
                }
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                return;
            }
        }
    }

    private void finalizeSqlForQuery(ExtractObject extractObject) {
        ExtractObjectSqlModel extractObjectSqlModel = extractObject.getSqlModel();
        if (!extractObjectSqlModel.isSqlExtendable()) {
            extractObjectSqlModel.setSql("\n" + extractObjectSqlModel.getSql() + "\n");
            if (extractObjectSqlModel.getSqlLobs() != null) {
                extractObjectSqlModel.setSqlLobs("\n" + extractObjectSqlModel.getSqlLobs() + "\n");
            }
            if (extractObjectSqlModel.getSqlNoLobs() != null) {
                extractObjectSqlModel.setSqlLobs("\n" + extractObjectSqlModel.getSqlLobs() + "\n");
            }
        } else if (extractObject.isSourceConnOracle() || extractObject.isSourceConnTimesTen()) {
            extractObjectSqlModel.setSql("select * from (\n" + extractObjectSqlModel.getSql() + "\n)");
            if (extractObjectSqlModel.getSqlLobs() != null) {
                extractObjectSqlModel.setSqlLobs("select * from (\n" + extractObjectSqlModel.getSqlLobs() + "\n)");
            }
            if (extractObjectSqlModel.getSqlNoLobs() != null) {
                extractObjectSqlModel.setSqlNoLobs("select * from (\n" + extractObjectSqlModel.getSqlNoLobs() + "\n)");
            }
        } else {
            extractObjectSqlModel.setSql("select * from (\n" + extractObjectSqlModel.getSql() + "\n) as t");
            if (extractObjectSqlModel.getSqlLobs() != null) {
                extractObjectSqlModel.setSqlLobs("select * from (\n" + extractObjectSqlModel.getSqlLobs() + "\n) as t");
            }
            if (extractObjectSqlModel.getSqlNoLobs() != null) {
                extractObjectSqlModel.setSqlNoLobs("select * from (\n" + extractObjectSqlModel.getSqlNoLobs() + "\n) as t");
            }
        }
    }

    protected void scrubColList(ExtractObject extractObject, BasicTabCol basicTabCol) {
        BasicDBObject basicDBObject = extractObject.getDBObject();
        ExtractObjectSqlModel extractObjectSqlModel = extractObject.getSqlModel();
        if (basicTabCol == null) {
            basicTabCol = new BasicTabCol(extractObject.getSourceConnName());
        }
        if (extractObject.isSourceConnOracle() && !extractObject.isSourceConnTimesTen()) {
            try {
                JTable jTable = (JTable)extractObject.getTable();
                if (jTable != null && jTable.getModel() instanceof IResultSetTableModel) {
                    IResultSetTableModel iResultSetTableModel = (IResultSetTableModel)((Object)jTable.getModel());
                    super.scrubColList(extractObject, basicTabCol);
                    return;
                }
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        }
        super.scrubColList(extractObject, basicTabCol);
    }

    TreeSet<BasicSuggestedItem> getResultSetColumns(IResultSetTableModel iResultSetTableModel) {
        TreeSet<BasicSuggestedItem> treeSet = new TreeSet<BasicSuggestedItem>();
        try {
            if (iResultSetTableModel != null) {
                ResultSetMetaData resultSetMetaData = iResultSetTableModel.getResultSetMetaData();
                for (int i = 0; i < iResultSetTableModel.getColumnCount(); ++i) {
                    String string = iResultSetTableModel.getColumnName(i);
                    String string2 = null;
                    for (int j = 1; j <= resultSetMetaData.getColumnCount(); ++j) {
                        if (!string.equalsIgnoreCase(resultSetMetaData.getColumnName(j))) continue;
                        string2 = resultSetMetaData.getColumnTypeName(j);
                        break;
                    }
                    if (string2 == null) continue;
                    BasicSuggestedItem basicSuggestedItem = new BasicSuggestedItem("COLUMN", null, string, i);
                    basicSuggestedItem.columnType = string2;
                    treeSet.add(basicSuggestedItem);
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
        return treeSet;
    }
}

