/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.util.Encodings;
import oracle.ide.util.ResourceUtils;

public class TargetOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel _saveAsPanel = null;
    private JCheckBox _openTarget = new JCheckBox();
    private JCheckBox _genScript = new JCheckBox();
    private JCheckBox _genDate = new JCheckBox();
    private JCheckBox _compression = new JCheckBox();
    private JComboBox _saveAsType = new JComboBox();
    private JComboBox _compressionType = new JComboBox();
    private JComboBox _encoding = new JComboBox();
    private JComboBox _standardEncodings = new JComboBox();
    private JComboBox _formatEncodings = new JComboBox();
    private URLFileChooser.URLFileChooserPanel _saveAsChooser;
    private JPanel _saveAsLayout = new JPanel(new GridBagLayout());
    private TargetFormat _targetFormat;
    private JLabel _saveAsLabel;
    private JLabel _encodingLabel;
    private boolean _isStandardEncodings;

    public TargetOptionsPanel(Component component) {
        this(component, 1, 1);
    }

    public TargetOptionsPanel(Component component, TargetFormat targetFormat) {
        this._targetFormat = targetFormat;
        this.initFilePanel(component);
    }

    public TargetOptionsPanel(Component component, int n, int n2) {
        this._targetFormat = new TargetFormat(n, n2);
        this.initFilePanel(component);
    }

    public JComboBox getSaveAsTypeComponent() {
        return this._saveAsType;
    }

    public JCheckBox getCompressionComponent() {
        return this._compression;
    }

    public TargetFormat getFormat() {
        this._targetFormat.isOpenTarget(this._openTarget.isSelected());
        this._targetFormat.isGenScript(this._genScript.isSelected());
        this._targetFormat.isGenDate(this._genDate.isSelected());
        this._targetFormat.setSaveAsType(this._saveAsType.getSelectedIndex());
        try {
            String string = this._saveAsChooser.getText();
            this._targetFormat.setSaveAs(string);
        }
        catch (Exception exception) {
            URL uRL = this._saveAsChooser.getSelectedURL();
            if (uRL != null) {
                this._targetFormat.setSaveAs(uRL.toExternalForm());
            }
            this._targetFormat.setSaveAs("");
        }
        if (this._targetFormat.getShowEncoding()) {
            this._targetFormat.setEncoding(this._encoding.getSelectedItem().toString());
        } else {
            this._targetFormat.setEncoding("UTF8");
        }
        if (this._targetFormat.getShowCompression()) {
            this._targetFormat.isCompressed(this._compression.isSelected());
            this._targetFormat.setCompressionType(this._compressionType.getSelectedIndex());
        }
        return this._targetFormat;
    }

    public JPanel getPanel() {
        return this.getPanel(true);
    }

    public JPanel getPanel(boolean bl) {
        return this.getPanel(bl, false);
    }

    public JPanel getPanel(boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        if (this._targetFormat.getShowEncoding()) {
            this.initEncoding();
        }
        if (this._targetFormat.getShowCompression()) {
            this.initCombo(this._compressionType, false, this._targetFormat.getCompressionTypes(), this._targetFormat.getCompressionType());
            ResourceUtils.resButton((AbstractButton)this._compression, (String)DDLResources.getString("COMPRESSION"));
            this._compression.setSelected(this._targetFormat.isCompressed());
        }
        ResourceUtils.resButton((AbstractButton)this._openTarget, (String)DDLResources.getString("OPEN_FILE"));
        ResourceUtils.resButton((AbstractButton)this._genScript, (String)DDLResources.getString("GEN_SCRIPT"));
        ResourceUtils.resButton((AbstractButton)this._genDate, (String)DDLResources.getString("GEN_DATE"));
        this._saveAsType = new JComboBox();
        this.initCombo(this._saveAsType, false, this._targetFormat.getSaveAsTypes(), this._targetFormat.getSaveAsType());
        this._saveAsLabel = new JLabel(StringUtils.stripMnemonic((String)DDLResources.getString("SAVE_AS")));
        this._saveAsLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DDLResources.getString("SAVE_AS")));
        this._saveAsLabel.setLabelFor(this._saveAsType);
        n2 = 0;
        if (this._targetFormat.getShowSaveAsType()) {
            this._saveAsLabel = new JLabel(StringUtils.stripMnemonic((String)DDLResources.getString("SAVE_AS")));
            this._saveAsLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DDLResources.getString("SAVE_AS")));
            this._saveAsLabel.setLabelFor(this._saveAsType);
            this._saveAsLayout.add((Component)this._saveAsLabel, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(this._targetFormat.getUsage() == 0 ? 12 : 8, 0, 0, 8), 0, 0));
            this._saveAsLayout.add((Component)this._saveAsType, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 2, new Insets(this._targetFormat.getUsage() == 0 ? 10 : 6, 0, 0, 8), 0, 0));
        }
        if (this._targetFormat.getShowCompression()) {
            this._saveAsLayout.add((Component)this._compression, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 8), 0, 0));
            ++n2;
        }
        if (this._targetFormat.getShowEncoding() && this._targetFormat.getShowSaveAsType()) {
            this._saveAsLayout.add((Component)this._encodingLabel, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 12, 0, new Insets(8, 8, 0, 8), 0, 0));
            this._saveAsLayout.add((Component)this._encoding, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 12, 0, new Insets(6, 0, 0, 0), 0, 0));
        }
        n2 = 0;
        this._saveAsPanel.add((Component)this._saveAsLayout, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
        ++n;
        this._saveAsLabel = new JLabel(StringUtils.stripMnemonic((String)DDLResources.getString("SAVE_AS")));
        this._saveAsLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DDLResources.getString("SAVE_AS")));
        this._saveAsLabel.setLabelFor(this._saveAsType);
        n2 = 0;
        this._saveAsLabel = this._targetFormat.getPreference() == 6 ? new JLabel(StringUtils.stripMnemonic((String)DDLResources.getString("LOCATION_LABEL"))) : new JLabel(this._targetFormat.getUsage() == 0 ? StringUtils.stripMnemonic((String)DDLResources.getString("DIR_LABEL")) : StringUtils.stripMnemonic((String)DDLResources.getString("FILE_LABEL")));
        if (bl2) {
            this._saveAsLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)(this._targetFormat.getUsage() == 0 ? DDLResources.getString("DIR_LABEL") : DDLResources.getString("FILE_LABEL"))));
        }
        this._saveAsLabel.setLabelFor(this._saveAsChooser);
        this._saveAsPanel.add((Component)this._saveAsLabel, new GridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(this._targetFormat.getUsage() == 0 ? 12 : 2, 0, 0, 8), 0, 0));
        this._saveAsPanel.add((Component)this._saveAsChooser, new GridBagConstraints(n2++, n, 1, 1, 1.0, 0.0, 10, 2, new Insets(this._targetFormat.getUsage() == 0 ? 10 : 0, 0, 0, 0), 0, 0));
        if (this._targetFormat.getShowEncoding() && !this._targetFormat.getShowSaveAsType()) {
            n2 = 0;
            this._saveAsPanel.add((Component)this._encodingLabel, new GridBagConstraints(n2++, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0));
            this._saveAsPanel.add((Component)this._encoding, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        }
        if (this._targetFormat.getUsage() == 0 && this._targetFormat.getPreference() != 3 && this._targetFormat.getPreference() != 4 && this._targetFormat.getPreference() != 5) {
            n2 = 0;
            this._saveAsPanel.add((Component)this._openTarget, new GridBagConstraints(n2, ++n, 3, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 24), 0, 0));
            this._saveAsPanel.add((Component)this._genScript, new GridBagConstraints(n2, ++n, 3, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 24), 0, 0));
            this._saveAsPanel.add((Component)this._genDate, new GridBagConstraints(n2, ++n, 3, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 24), 0, 0));
        }
        this.setFormat();
        return this._saveAsPanel;
    }

    public void setFormat(TargetFormat targetFormat) {
        this._targetFormat = targetFormat;
        this.setFormat();
    }

    private void setFormat() {
        this._openTarget.setSelected(this._targetFormat.isOpenTarget());
        this._genScript.setSelected(this._targetFormat.isGenScript());
        this._genDate.setSelected(this._targetFormat.isGenDate());
        if (this._targetFormat.getShowEncoding()) {
            this._encoding.setSelectedItem(this._targetFormat.getEncoding());
        }
        if (this._targetFormat.getShowCompression()) {
            this._compression.setSelected(this._targetFormat.isCompressed());
            this._compressionType.setSelectedIndex(this._targetFormat.getCompressionType());
        }
        int n = this._targetFormat.getSaveAsType();
        this._saveAsType.setSelectedIndex(n);
        int n2 = (n == 0 || this._compression.isSelected()) && this._targetFormat.getUsage() != 0 ? 0 : 1;
        this._saveAsChooser.setSelectionScope(n2);
        this._saveAsChooser.setSelectedURL(null);
        this._saveAsChooser.setSelectedURL(this._targetFormat.getSaveAsURL());
    }

    public String getFileName() {
        return this._saveAsChooser.getText();
    }

    public URL getSelectedURL() {
        return this._saveAsChooser.getSelectedURL();
    }

    public void setSelectedURL(URL uRL) {
        this._saveAsChooser.setSelectedURL(null);
        this._saveAsChooser.setSelectedURL(uRL);
    }

    private void initFilePanel(Component component) {
        this._saveAsPanel = new JPanel(new GridBagLayout());
        this._saveAsChooser = URLFileChooser.createURLFileChooserPanel(1, this._targetFormat.getPreference() != 6 ? null : "Cloud Transfer Location", null, false, false, this._targetFormat.getPreference() != 6);
        if (this._targetFormat != null && this._targetFormat.getPreference() != 0) {
            this._saveAsChooser.setPathContext(this._targetFormat.getUrlPathContext());
        }
        int n = (this._targetFormat.getSaveAsType() == 0 || this._targetFormat.isCompressed()) && this._targetFormat.getUsage() != 0 ? 0 : 1;
        this._saveAsChooser.setSelectionScope(n);
    }

    private void initEncoding() {
        if (this._encodingLabel == null) {
            this._standardEncodings = new JComboBox();
            Encodings.initComboBox((JComboBox)this._standardEncodings, (boolean)true, (String)this._targetFormat.getEncoding());
            this._isStandardEncodings = true;
            this._encoding = this._standardEncodings;
            this._encodingLabel = new JLabel(StringUtils.stripMnemonic((String)ExportWizArb.getString("ENCODING")));
            this._encodingLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)ExportWizArb.getString("ENCODING")));
            this._encodingLabel.setLabelFor(this._encoding);
        }
    }

    void initCombo(JComboBox jComboBox, boolean bl, String[] stringArray, int n) {
        jComboBox.setEditable(bl);
        for (String string : stringArray) {
            jComboBox.addItem(string);
        }
        jComboBox.setSelectedIndex(n);
    }

    public void saveAsTypeChanged(String string) {
        Object object;
        int n = this._saveAsType.getSelectedIndex();
        int n2 = (n == 0 || this._compression.isSelected()) && this._targetFormat.getUsage() != 0 ? 0 : 1;
        this._saveAsChooser.setSelectionScope(n2);
        this._saveAsChooser.setEnabled(true);
        this._saveAsLabel.setEnabled(true);
        this.enableEncoding(!this._compression.isSelected());
        this.enableCompression(true);
        Object object2 = object = this._saveAsChooser.getText() != null ? this._saveAsChooser.getText() : "";
        if (n == 0 || this._compression.isSelected() && n < 4) {
            File file = new File((String)object);
            if (file.isDirectory()) {
                if (!((String)object).endsWith(File.separator)) {
                    object = (String)object + File.separator;
                }
                if (this._compression.isSelected()) {
                    this._saveAsChooser.setText((String)object + DDLResources.getString("DEFAULT_DEPLOY_FILENAME") + "." + this._targetFormat.getCompressionExt());
                } else {
                    this._saveAsChooser.setText((String)object + DDLResources.getString("DEFAULT_EXPORT_FILENAME") + "." + string);
                }
            } else {
                Object object3 = file.getName();
                if (((String)object3).contains(".")) {
                    Object object4 = object3 = file.getParent() != null ? file.getParent() : "";
                    if (!((String)object3).endsWith(File.separator)) {
                        object3 = (String)object3 + File.separator;
                    }
                    if (this._compression.isSelected()) {
                        this._saveAsChooser.setText((String)object3 + DDLResources.getString("DEFAULT_DEPLOY_FILENAME") + "." + this._targetFormat.getCompressionExt());
                    } else {
                        this._saveAsChooser.setText((String)object3 + DDLResources.getString("DEFAULT_EXPORT_FILENAME") + "." + string);
                    }
                }
            }
        } else if (n >= 4) {
            this._saveAsChooser.setEnabled(false);
            this._saveAsLabel.setEnabled(false);
            this.enableEncoding(false);
            this.enableCompression(false);
        } else {
            String string2;
            this._saveAsChooser.setEnabled(true);
            this._saveAsLabel.setEnabled(true);
            this.enableEncoding(true);
            this.enableCompression(true);
            File file = new File((String)object);
            if (!file.isDirectory() && (string2 = file.getName()).contains(".")) {
                this._saveAsChooser.setText(file.getParent() != null ? file.getParent() : "");
            }
        }
    }

    public void adjustSaveAs(String string, ExtractDataFormat extractDataFormat) {
        String string2;
        int n = this._saveAsType.getSelectedIndex();
        String string3 = string2 = this._saveAsChooser.getText() != null ? this._saveAsChooser.getText() : "";
        if (n == 0 || this._compression.isSelected()) {
            if (this._compression.isSelected()) {
                string = this._targetFormat.getCompressionExt();
            }
            this._saveAsChooser.setEnabled(true);
            this._saveAsLabel.setEnabled(true);
            this.enableEncoding(true);
            File file = new File(string2);
            if (!file.isDirectory()) {
                String string4 = file.getName();
                Object object = "";
                int n2 = string4.lastIndexOf(".");
                if (n2 > -1) {
                    n2 = string2.lastIndexOf(".");
                    object = string2.substring(0, n2 + 1) + string;
                } else {
                    object = string2 + "." + string;
                }
                this._saveAsChooser.setText((String)object);
            } else {
                this._saveAsChooser.setText(string2 + (string2.endsWith(File.separator) ? "" : File.separator) + DDLResources.getString("DEFAULT_EXPORT_FILENAME") + "." + string);
            }
            this.enableEncoding(!this._compression.isSelected());
        } else if (n >= 4) {
            this._saveAsChooser.setEnabled(false);
            this._saveAsLabel.setEnabled(false);
            this.enableEncoding(false);
            this.enableCompression(false);
        } else {
            this._saveAsChooser.setEnabled(true);
            this._saveAsLabel.setEnabled(true);
            this.enableEncoding(true);
            this.enableCompression(true);
        }
        this.enableOpen(string, extractDataFormat);
    }

    public void enableOpen(String string, ExtractDataFormat extractDataFormat) {
        if (extractDataFormat != null && extractDataFormat.isExportEnabled() && extractDataFormat.getFileExtension() != null && extractDataFormat.getFileExtension().equals(string) && !extractDataFormat.isTextEditorReadable()) {
            this._openTarget.setSelected(false);
            this._openTarget.setEnabled(false);
        } else {
            this._openTarget.setEnabled(true);
            this._openTarget.setSelected(this._targetFormat.isDefaultOpenTarget());
        }
    }

    void enableOptions(boolean bl) {
        this._openTarget.setEnabled(bl);
    }

    void enableCompression(boolean bl) {
        if (this._compression != null) {
            this._compression.setEnabled(bl);
        }
    }

    void enableEncoding(boolean bl) {
        if (this._encodingLabel != null) {
            this._encoding.setEnabled(bl);
            this._encodingLabel.setEnabled(bl);
        }
    }

    public void setEncodings(ExtractDataFormat extractDataFormat) {
        if (extractDataFormat != null && extractDataFormat.isExportEnabled() && !extractDataFormat.isStandardEncodings() && this._isStandardEncodings) {
            this._formatEncodings = new JComboBox();
            this.initCombo(this._formatEncodings, true, extractDataFormat.getEncodings(), 0);
            this._saveAsLayout.remove(this._encoding);
            this._encoding = this._formatEncodings;
            this._saveAsLayout.add((Component)this._encoding, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            this._isStandardEncodings = false;
            this._saveAsPanel.repaint();
            this._saveAsPanel.revalidate();
        } else if (!this._isStandardEncodings) {
            this._saveAsLayout.remove(this._encoding);
            this._encoding = this._standardEncodings;
            this._saveAsLayout.add((Component)this._encoding, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
            this._saveAsPanel.repaint();
            this._saveAsPanel.revalidate();
            this._isStandardEncodings = true;
        }
    }
}

