/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.export.wizard.ExportWizDataMulti;
import oracle.dbtools.raptor.export.wizard.ExportWizDataSelector;
import oracle.dbtools.raptor.export.wizard.ExportWizDestinstaionPanel;
import oracle.dbtools.raptor.export.wizard.ExportWizObjectShuttlePanel;
import oracle.dbtools.raptor.export.wizard.ExportWizSummaryPanel;
import oracle.dbtools.raptor.export.wizard.ExportWizTypesPanel;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class ExportWizMain {
    static final String STATE_C = "StateC";
    static final String TRANSITION_C = "C";
    static final String STATE_B = "StateB";
    static final String TRANSITION_B = "B";
    static final String TRANSITION_FIN = "Fin";
    static final String STATE_FIN = "StateFin";
    static final String STATE_A = "StateA";
    static final String TRANSITION_A = "A";
    static final String KEY_FILENAME = "FILENAME";
    static final String KEY_CONN = "CONNECTION";
    static final String KEY_CNAME = "CONNECTION_NAME";
    static final String KEY_TARGETFORMAT = "TARGETFORMAT";
    static final String KEY_DATA_LIST = "DATA_LIST";
    static final String KEY_ACTION_OBJECT_LIST = "ACTION_OBJECT_LIST";
    static final String KEY_WIZARD_TYPE = "WIZARD_TYPE";
    public static final String WIZARD_TYPE_TOOL = "1";
    public static final String WIZARD_TYPE_DDL = "2";
    public static final String WIZARD_TYPE_OBJECT_DATA = "3";
    public static final String WIZARD_TYPE_OBJECT_ALL = "4";
    public static final String WIZARD_TYPE_QUERY_DATA = "5";
    public static final String WIZARD_TYPE_QUERY_OBJECT = "6";
    public static final String EXPORT_NAME = "raptor.exportWizard";
    public static final int EXPORT_ACTION = Ide.findOrCreateCmdID((String)"raptor.exportWizard");
    private static ExportWizMain INSTANCE;

    private static FSM getFSMforDBTool() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(ExportWizArb.getString("STEP1"), ExportWizDestinstaionPanel.class, "f1_help_id_for_step1");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_A, (Object)STATE_A);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step2 = new Step(ExportWizArb.getString("STEP2"), ExportWizTypesPanel.class, "f1_help_id_for_step2");
        fSMBuilder.newState((Object)STATE_A, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_B, (Object)STATE_B);
        fSMBuilder.addStateTrans((Object)TRANSITION_C, (Object)STATE_C);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step3 = new Step(ExportWizArb.getString("STEP3"), ExportWizObjectShuttlePanel.class, "f1_help_id_for_step3");
        fSMBuilder.newState((Object)STATE_B, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_C, (Object)STATE_C);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step4 = new Step(ExportWizArb.getString("STEP4"), ExportWizDataSelector.class, "f1_help_id_for_step4");
        fSMBuilder.newState((Object)STATE_C, step4, (Object)STATE_FIN);
        Step step5 = new Step(ExportWizArb.getString("STEP5"), ExportWizSummaryPanel.class, "f1_help_id_for_step5");
        fSMBuilder.newFinalState((Object)STATE_FIN, step5);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private static FSM getFSMforDDL() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(ExportWizArb.getString("STEP1"), ExportWizDestinstaionPanel.class, "f1_help_id_for_step1");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step2 = new Step(ExportWizArb.getString("STEP5"), ExportWizSummaryPanel.class, "f1_help_id_for_step5");
        fSMBuilder.newFinalState((Object)STATE_FIN, step2);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private static FSM getFSMforData() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(ExportWizArb.getString("STEP1"), ExportWizDestinstaionPanel.class, "f1_help_id_for_step1");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_A, (Object)STATE_A);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step2 = new Step(ExportWizArb.getString("STEP4"), ExportWizDataMulti.class, "f1_help_id_for_step4");
        fSMBuilder.newState((Object)STATE_A, step2, (Object)STATE_FIN);
        Step step3 = new Step(ExportWizArb.getString("STEP5"), ExportWizSummaryPanel.class, "f1_help_id_for_step5");
        fSMBuilder.newFinalState((Object)STATE_FIN, step3);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    private static FSM getFSMforQuery() {
        return ExportWizMain.getFSMforDDL();
    }

    public void launchForDBTool() {
        FSM fSM = ExportWizMain.getFSMforDBTool();
        this.launchWizard(fSM, WIZARD_TYPE_TOOL, new ExtractListModel());
    }

    public void launchForDDL(ExtractListModel extractListModel) {
        FSM fSM = ExportWizMain.getFSMforDDL();
        this.launchWizard(fSM, WIZARD_TYPE_DDL, extractListModel);
    }

    public void launchForData(ExtractListModel extractListModel) {
        FSM fSM = ExportWizMain.getFSMforData();
        this.launchWizard(fSM, WIZARD_TYPE_OBJECT_DATA, extractListModel);
    }

    public void launchForObjectGrid(ExtractListModel extractListModel) {
        FSM fSM = ExportWizMain.getFSMforQuery();
        this.launchWizard(fSM, WIZARD_TYPE_QUERY_OBJECT, extractListModel);
    }

    public void launchForDataAndDDL(ExtractListModel extractListModel) {
        if (!extractListModel.isPreSelectedDataExtractable()) {
            this.launchForDDL(extractListModel);
        } else {
            FSM fSM = ExportWizMain.getFSMforData();
            this.launchWizard(fSM, WIZARD_TYPE_OBJECT_ALL, extractListModel);
        }
    }

    public void launchForGrid(ExtractListModel extractListModel) {
        FSM fSM = ExportWizMain.getFSMforQuery();
        this.launchWizard(fSM, WIZARD_TYPE_QUERY_DATA, extractListModel);
    }

    public void launchWizard(FSM fSM, String string, ExtractListModel extractListModel) {
        Namespace namespace = new Namespace();
        namespace.put(KEY_WIZARD_TYPE, (Object)string);
        if (extractListModel == null) {
            namespace.put("EXTRACT_LIST_MODEL", (Object)new ExtractListModel());
        } else {
            namespace.put("EXTRACT_LIST_MODEL", (Object)extractListModel);
        }
        namespace.put(KEY_CNAME, (Object)extractListModel.getSourceConnName());
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        bigWizardDialog.setPreferredSize(new Dimension(720, 580));
        fSMWizard.setWizardTitle(ExportWizArb.getString("MAIN_TITLE"));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(ExportWizArb.getImage("WIZ_IMAGE"));
        fSMWizard.setLogoImage(ExportWizArb.getImage("WIZ_LOGO"));
        fSMWizard.setRoadmapVisible(true);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)EXPORT_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static ExportWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExportWizMain();
        }
        return INSTANCE;
    }

    static boolean acquireLock(String string) {
        return LockedConnection.acquireLock(string);
    }

    static void freeLock() {
        LockedConnection.freeLock();
    }

    private static class LockedConnection {
        private static String _connName;
        private static boolean _locked;

        private LockedConnection() {
        }

        static synchronized boolean acquireLock(String string) {
            boolean bl = false;
            LockedConnection.freeLock();
            bl = _locked = Connections.getInstance().lock(string, true);
            if (bl) {
                _connName = string;
            }
            return bl;
        }

        static synchronized void freeLock() {
            if (_connName != null && _locked) {
                Connections.getInstance().unlock(_connName);
                _locked = false;
                _connName = null;
            }
        }

        static {
            _locked = false;
        }
    }

    public static class ExportController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == EXPORT_ACTION) {
                ExportWizMain.getInstance().launchForDBTool();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == EXPORT_ACTION) {
                if (Connections.getInstance().getConnNames().length <= 0) {
                    ideAction.setEnabled(false);
                } else {
                    ideAction.setEnabled(true);
                }
                return true;
            }
            return false;
        }
    }
}

