/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.importer.writers.IGenerationOutputStream;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.ZipOutputHandler;

public class ExportGenerationOutputStream
implements IGenerationOutputStream {
    protected final int FLUSH_EVERY_N_WRITE = 20;
    protected int m_writeTracker = 0;
    private TargetFormat m_targetFormat;
    private ResultsFormatter m_formatter;
    private long m_linesWritten = 0L;
    private Writer m_currentWriter;
    private OutputStream m_fout;
    private OutputStream m_bout;
    private ZipOutputHandler m_zipper;
    private String m_currentObjectType = "";
    private String m_lastObjectType = "";
    private ArrayList<String> m_createdFiles;
    private String m_currentFileName;
    private String m_controllingScriptName;
    private String m_controllingHeader;
    private boolean m_isControllingFileExecutable = false;
    private String m_encoding;
    private static final TypeToFolderNameTuple[] FOLDER_NAME_MAP = new TypeToFolderNameTuple[]{new TypeToFolderNameTuple("DROP", ExportResources.getString((String)"DROP_FOLDER")), new TypeToFolderNameTuple("VIEW", ExportResources.getString((String)"VIEW_FOLDER")), new TypeToFolderNameTuple("TYPE", ExportResources.getString((String)"TYPE_FOLDER")), new TypeToFolderNameTuple("TRIGGER", ExportResources.getString((String)"TRIGGER_FOLDER")), new TypeToFolderNameTuple("TABLE", ExportResources.getString((String)"TABLE_FOLDER")), new TypeToFolderNameTuple("SEQUENCE", ExportResources.getString((String)"SEQUENCE_FOLDER")), new TypeToFolderNameTuple("PROCEDURE", ExportResources.getString((String)"PROCEDURE_FOLDER")), new TypeToFolderNameTuple("PACKAGE BODY", ExportResources.getString((String)"PACKBODY_FOLDER")), new TypeToFolderNameTuple("PACKAGE", ExportResources.getString((String)"PACKSPEC_FOLDER")), new TypeToFolderNameTuple("MATERIALIZED VIEW", ExportResources.getString((String)"MATVIEW_FOLDER")), new TypeToFolderNameTuple("INDEX", ExportResources.getString((String)"INDEX_FOLDER")), new TypeToFolderNameTuple("FUNCTION", ExportResources.getString((String)"FUNCTION_FOLDER")), new TypeToFolderNameTuple("DATABASE LINK", ExportResources.getString((String)"DBLINK_FOLDER")), new TypeToFolderNameTuple("SYNONYM", ExportResources.getString((String)"SYNONYM_FOLDER")), new TypeToFolderNameTuple("MATERIALIZED VIEW LOG", ExportResources.getString((String)"MATVIEWLOG_FOLDER")), new TypeToFolderNameTuple("DIRECTORY", ExportResources.getString((String)"DIRECTORY_FOLDER")), new TypeToFolderNameTuple("QUEUE", ExportResources.getString((String)"QUEUE_FOLDER")), new TypeToFolderNameTuple("QUEUE TABLE", ExportResources.getString((String)"QUEUETABLE_FOLDER")), new TypeToFolderNameTuple("CONSTRAINT", ExportResources.getString((String)"CONSTRAINT_FOLDER")), new TypeToFolderNameTuple("REFCONSTRAINT", ExportResources.getString((String)"REFCONSTRAINT_FOLDER")), new TypeToFolderNameTuple("BEFORE_CREATE", ExportResources.getString((String)"SCRIPT_FOLDER")), new TypeToFolderNameTuple("AFTER_CREATE", ExportResources.getString((String)"SCRIPT_FOLDER")), new TypeToFolderNameTuple("BEFORE_LOAD", ExportResources.getString((String)"SCRIPT_FOLDER")), new TypeToFolderNameTuple("AFTER_LOAD", ExportResources.getString((String)"SCRIPT_FOLDER")), new TypeToFolderNameTuple("INITIAL", ExportResources.getString((String)"SCRIPT_FOLDER")), new TypeToFolderNameTuple("FINAL", ExportResources.getString((String)"SCRIPT_FOLDER"))};

    public ExportGenerationOutputStream(TargetFormat targetFormat) {
        this.m_targetFormat = targetFormat;
        this.m_encoding = targetFormat.getEncoding();
    }

    public void setControllingFileHeader(String string) {
        this.m_controllingHeader = string;
    }

    public void startPreamble(String string) throws FileNotFoundException, UnsupportedEncodingException {
        this.m_createdFiles = new ArrayList();
        if (this.m_targetFormat.isCompressed()) {
            this.m_zipper = new ZipOutputHandler();
            this.m_zipper.setEncoding(this.m_targetFormat.getEncoding());
            String string2 = this.m_targetFormat.getSaveAs();
            File file = new File(string2);
            String string3 = file.getParent();
            this.m_zipper.openZip(string2);
            this.m_targetFormat.setSaveAs(string3);
            if (this.m_targetFormat.isSingleFile()) {
                this.open(this.m_targetFormat.getControllingBaseName());
            } else {
                this.m_controllingScriptName = this.m_targetFormat.getControllingBaseName();
                this.m_targetFormat.setControllingBaseName(this.m_controllingScriptName);
            }
        } else if (this.m_targetFormat.isSingleFile() || this.m_targetFormat.isStringType() || this.m_targetFormat.isCompressed()) {
            this.open(this.m_targetFormat.getSaveAs());
        } else {
            this.m_controllingScriptName = string;
            this.m_targetFormat.setControllingBaseName(this.m_controllingScriptName);
        }
    }

    public void endPreamble() {
    }

    public void startObject(String string, String string2) {
        this.startObject(string, string2, null, null);
    }

    public void startObject(String string, String string2, String string3, String string4) {
        block19: {
            boolean bl = !this.m_currentObjectType.equals(string2);
            this.m_lastObjectType = this.m_currentObjectType;
            this.m_currentObjectType = string2;
            try {
                if (this.m_targetFormat.isCompressed()) {
                    if (this.m_targetFormat.isMultipleFiles() || this.m_targetFormat.isTypeFiles() && bl || this.m_targetFormat.isTypeFiles() && this.isTypeData(string2) || this.m_targetFormat.isSeparateDirs()) {
                        this.closeCurrentStream();
                        this.m_currentFileName = this.getFileName(Service.cleanScriptFileName((String)string), string2);
                        if (!this.m_targetFormat.isTypeFiles() && string3 != null) {
                            this.writeScript(string, string3, string4);
                        }
                        this.m_zipper.openEntry(this.m_currentFileName);
                        if (this.m_targetFormat.isTypeFiles() && string3 != null) {
                            this.writeScript(string, string3, string4);
                        }
                    } else {
                        this.flushCurrentStream();
                        if (string3 != null) {
                            this.writeScript(string, string3, string4);
                        }
                    }
                    break block19;
                }
                if (this.m_targetFormat.isMultipleFiles() || this.m_targetFormat.isSeparateDirs()) {
                    this.closeCurrentStream();
                    this.m_currentFileName = this.getFileName(Service.cleanScriptFileName((String)string), string2);
                    if (this.m_targetFormat.isSeparateDirs() && bl) {
                        File file = new File(this.m_currentFileName).getParentFile();
                        try {
                            file.mkdir();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string3 != null) {
                        this.writeScript(string, string3, string4);
                    }
                    this.open(this.m_currentFileName);
                    break block19;
                }
                if (this.m_targetFormat.isTypeFiles() && bl || this.m_targetFormat.isTypeFiles() && this.isTypeData(string2)) {
                    this.closeCurrentStream();
                    this.m_currentFileName = this.getFileName(Service.cleanScriptFileName((String)string), string2);
                    this.open(this.m_currentFileName);
                    if (string3 != null) {
                        this.writeScript(string, string3, string4);
                    }
                } else {
                    this.m_currentFileName = this.m_targetFormat.getSaveAs();
                    this.flushCurrentStream();
                    if (string3 != null) {
                        this.writeScript(string, string3, string4);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public void endObject() {
    }

    public void println(String string) {
        assert (this.m_currentWriter != null || this.m_zipper != null);
        int n = ExportGenerationOutputStream.countLines(string);
        try {
            if (string != null) {
                if (this.m_targetFormat.isCompressed()) {
                    this.m_zipper.writeEntryText(string);
                } else {
                    this.m_currentWriter.write(string);
                }
                if (this.m_writeTracker < 20) {
                    ++this.m_writeTracker;
                } else {
                    if (this.m_targetFormat.isCompressed()) {
                        this.m_zipper.flush();
                    } else {
                        this.m_currentWriter.flush();
                    }
                    this.m_writeTracker = 0;
                }
                this.m_linesWritten += (long)n;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeScript(String string, String string2, String string3) {
        if (this.m_targetFormat.isSingleFile() || this.m_targetFormat.isStringType() || this.m_targetFormat.isTypeFiles() && !string2.equals("INITIAL") && !string2.equals("FINAL")) {
            InputStreamReader inputStreamReader = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(string3);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                inputStreamReader = this.m_encoding == null ? new InputStreamReader(bufferedInputStream) : new InputStreamReader((InputStream)bufferedInputStream, this.m_encoding);
                String string4 = ExportResources.format((String)"START_SCRIPT", (Object[])new Object[]{string2, string3});
                if (this.m_targetFormat.isCompressed()) {
                    this.m_zipper.writeEntryText("--------------------------------------------------------\n");
                    this.m_zipper.writeEntryText("-- " + string4 + "\n");
                    this.m_zipper.writeEntryText("--------------------------------------------------------\n");
                    this.m_zipper.writeEntryCharStream((Reader)inputStreamReader);
                }
                this.m_currentWriter.write("\n");
                this.m_currentWriter.write("--------------------------------------------------------\n");
                this.m_currentWriter.write("-- " + string4 + "\n");
                this.m_currentWriter.write("--------------------------------------------------------\n");
                int n = 0;
                char[] cArray = new char[1024];
                while ((n = inputStreamReader.read(cArray, 0, 1024)) > 0) {
                    this.m_currentWriter.write(cArray, 0, n);
                }
                this.m_currentWriter.write("\n");
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        } else {
            String string5 = this.getFileName(string, string2);
            if (this.m_targetFormat.isCompressed()) {
                this.writeFileEntry(string3, string5);
            } else {
                Service.copy((String)string3, null, (String)string5, (String)this.m_encoding);
                this.m_createdFiles.add(string5);
            }
        }
    }

    public void writeFileEntry(String string, String string2) {
        try {
            this.m_zipper.writeFileEntry(string, string2, true);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void writeFileEntry(URL uRL) {
        try {
            this.m_zipper.writeFileEntry(uRL);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void finished() {
        this.m_lastObjectType = this.m_currentObjectType;
        if (!this.m_targetFormat.isStringType()) {
            this.closeCurrentStream();
            if (this.m_targetFormat.isCompressed()) {
                try {
                    if (!this.m_targetFormat.isSingleFile() && this.m_targetFormat.isGenScript()) {
                        this.m_zipper.addSQLControllingFile(this.m_targetFormat.getControllingFile(), this.m_controllingHeader, this.m_targetFormat.isExcutableControlFile());
                    }
                    this.m_zipper.closeZip();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            } else if (!this.m_targetFormat.isCompressed() && this.m_targetFormat.isGenScript() && this.m_createdFiles != null && this.m_createdFiles.size() > 1 && (this.m_targetFormat.isMultipleFiles() || this.m_targetFormat.isSeparateDirs() || this.m_targetFormat.isTypeFiles())) {
                try {
                    for (String string : this.m_createdFiles) {
                        if (!string.endsWith(".sql")) continue;
                        this.m_isControllingFileExecutable = true;
                    }
                    if (this.m_isControllingFileExecutable) {
                        this.open(this.m_targetFormat.getControllingFile());
                        this.println(this.m_controllingHeader);
                        this.m_createdFiles.remove(this.m_createdFiles.size() - 1);
                        for (String string : this.m_createdFiles) {
                            if (new File(string).length() <= 0L) continue;
                            if (string.endsWith(".sql")) {
                                this.println("@" + string + "\n");
                                this.m_isControllingFileExecutable = true;
                                continue;
                            }
                            this.println("--@" + string + "\n");
                        }
                        this.m_lastObjectType = "CONTROL";
                        this.closeCurrentStream();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
                }
            }
        }
    }

    public boolean isControlFileExecutable() {
        return this.m_isControllingFileExecutable;
    }

    private void closeCurrentStream() {
        try {
            if (!this.m_targetFormat.isCompressed() && this.m_currentWriter != null) {
                if (this.isTypeData(this.m_lastObjectType) && this.m_formatter.isStreamHandler()) {
                    this.m_formatter.closeStream();
                } else {
                    File file;
                    this.m_currentWriter.flush();
                    this.m_currentWriter.close();
                    if (this.m_currentFileName != null && (file = new File(this.m_currentFileName)).length() == 0L) {
                        file.delete();
                    }
                }
                this.m_writeTracker = 0;
                this.m_currentWriter = null;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void flushCurrentStream() {
        try {
            if (!this.m_targetFormat.isCompressed() && this.m_currentWriter != null) {
                if (this.isTypeData(this.m_lastObjectType) && this.m_formatter.isStreamHandler()) {
                    this.m_formatter.flushStream();
                } else {
                    this.m_currentWriter.flush();
                }
                this.m_writeTracker = 0;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private static int countLines(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n;
        }
        return n;
    }

    private void open(String string) throws FileNotFoundException, UnsupportedEncodingException {
        if (this.m_targetFormat.isCompressed()) {
            try {
                this.m_zipper.openEntry(string);
                this.m_createdFiles.add(string.toString());
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        } else if (this.m_targetFormat.isStringType()) {
            this.m_currentWriter = new StringWriter();
        } else {
            this.m_fout = new FileOutputStream(new File(string));
            this.m_bout = new BufferedOutputStream(this.m_fout);
            this.m_currentWriter = this.m_encoding == null ? new OutputStreamWriter(this.m_bout, this.m_encoding) : new OutputStreamWriter(this.m_bout, this.m_encoding);
            this.m_createdFiles.add(string.toString());
        }
    }

    public void addToControllingFile(String string) {
        this.m_createdFiles.add(string);
    }

    public Writer getWriter() {
        return this.m_currentWriter;
    }

    public OutputStream getOutputStream() {
        return this.m_bout;
    }

    public ZipOutputHandler getZipper() {
        return this.m_zipper;
    }

    public String toString() {
        if (this.m_currentWriter != null && this.m_currentWriter instanceof StringWriter) {
            return this.m_currentWriter.toString();
        }
        return null;
    }

    protected TargetFormat getTargetFormat() {
        return this.m_targetFormat;
    }

    protected void setTargetFormat(TargetFormat targetFormat) {
        this.m_targetFormat = targetFormat;
    }

    public void setFormatter(ResultsFormatter resultsFormatter) {
        this.m_formatter = resultsFormatter;
    }

    public String getFileNameToOpen() {
        if (this.m_targetFormat.isSingleFile()) {
            return this.m_targetFormat.getSaveAs();
        }
        if (this.isControlFileExecutable()) {
            return this.m_targetFormat.getControllingFile();
        }
        if (this.m_createdFiles != null && this.m_createdFiles.size() > 0) {
            String string = null;
            for (String string2 : this.m_createdFiles) {
                if (!string2.endsWith(".sql")) continue;
                if (string != null) {
                    return null;
                }
                string = string2;
            }
            return string;
        }
        return null;
    }

    private String getFileName(String string, String string2) {
        Object object;
        if (this.m_targetFormat.isCompressed()) {
            string = (string = Service.convertNonAsciiFileName((String)string)).startsWith("-") ? "X_" + string.substring(1) : string;
        }
        Object object2 = object = this.m_targetFormat.isCompressed() ? "" : this.m_targetFormat.getSaveAs();
        if (this.m_targetFormat.isSingleFile() || this.m_targetFormat.isStringType()) {
            return object;
        }
        Object object3 = "";
        if (this.isTypeData(string2)) {
            object3 = "_" + string2;
        } else if (string2.equals("CONSTRAINT")) {
            object3 = "_CONSTRAINT";
        } else if (string2.equals("REFCONSTRAINT")) {
            object3 = "_REFCONSTRAINT";
        } else if (this.isTypeScript(string2)) {
            object3 = "_" + string2;
        }
        String string3 = Character.valueOf(File.separatorChar).toString();
        if (((String)object).endsWith(string3) || this.m_targetFormat.isCompressed() && !this.m_targetFormat.isSeparateDirs()) {
            string3 = "";
        }
        object = this.m_targetFormat.isMultipleFiles() ? (this.isTypeProcessScript(string2) ? (String)object + string3 + string : (String)object + string3 + string + (String)object3) : (this.m_targetFormat.isTypeFiles() ? (this.isTypeData(string2) ? (String)object + string3 + string + (String)object3 : (this.isTypeScript(string2) ? (String)object + string3 + string : (String)object + string3 + this.getFolderNameForType(string2))) : (!this.m_targetFormat.isCompressed() ? (this.isTypeObjectScript(string2) ? (String)object + string3 + this.getFolderNameForType(string2) + string3 + string + (String)object3 : (String)object + string3 + this.getFolderNameForType(string2) + string3 + string) : (this.isTypeObjectScript(string2) ? this.getFolderNameForType(string2) + string3 + string + (String)object3 : this.getFolderNameForType(string2) + string3 + string)));
        object = this.m_targetFormat.isCompressed() ? this.m_zipper.getUniqueEntryName((String)object, this.getExtension(string2)) : this.getUniqueFileName((String)object, this.getExtension(string2));
        return object;
    }

    private boolean isTypeData(String string) {
        return string.startsWith("DATA") && !string.equals("DATABASE LINK");
    }

    private boolean isTypeScript(String string) {
        return string.startsWith("INITIAL") || string.startsWith("FINAL") || string.startsWith("BEFORE") || string.startsWith("AFTER");
    }

    private boolean isTypeObjectScript(String string) {
        return string.startsWith("BEFORE") || string.startsWith("AFTER");
    }

    private boolean isTypeProcessScript(String string) {
        return string.startsWith("INITIAL") || string.startsWith("FINAL");
    }

    private String getUniqueFileName(String string, String string2) {
        String string3 = string + string2;
        File file = new File(string3);
        int n = 0;
        while (file.isFile()) {
            string3 = string + "_" + ++n + string2;
            file = new File(string3);
        }
        return string3;
    }

    public String getCurrentFileName() {
        return this.m_currentFileName;
    }

    private String getExtension(String string) {
        return !this.isTypeData(string) ? ".sql" : "." + this.m_targetFormat.getDataFormatExtension();
    }

    private String getFolderNameForType(String string) {
        for (TypeToFolderNameTuple typeToFolderNameTuple : FOLDER_NAME_MAP) {
            if (!typeToFolderNameTuple.getType().equals(string)) continue;
            return typeToFolderNameTuple.getFolderName();
        }
        return string;
    }

    public void close() {
    }

    private static class TypeToFolderNameTuple {
        private String m_type;
        private String m_folderName;

        public TypeToFolderNameTuple(String string, String string2) {
            this.setType(string);
            this.setFolderName(string2);
        }

        public String getFolderName() {
            return this.m_folderName;
        }

        public String getType() {
            return this.m_type;
        }

        protected void setFolderName(String string) {
            this.m_folderName = string;
        }

        protected void setType(String string) {
            this.m_type = string;
        }
    }
}

