/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.io.Console;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.connections.db.ConnectionCreator;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.PasswordPrompter;
import oracle.dbtools.raptor.dialogs.conn.ConnectionInfoPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;

public class ConnectionPrompt
implements PasswordPrompter {
    private RaptorPrompter getDelegate() {
        return Holder.INSTANCE;
    }

    public Connection promptForPassword(Properties properties, String string, ConnectionCreator connectionCreator) throws SQLException {
        return this.getDelegate().promptForPassword(properties, string, connectionCreator);
    }

    public void disconnect(Properties properties) {
        this.getDelegate().disconnect(properties);
    }

    public void cache(Properties properties) {
        this.getDelegate().cache(properties);
    }

    public Connection promptForPassword(DatabaseProvider databaseProvider) throws SQLException {
        return this.getDelegate().promptForPassword(databaseProvider);
    }

    public void disconnect(DatabaseProvider databaseProvider) {
        this.getDelegate().disconnect(databaseProvider);
    }

    public void cache(DatabaseProvider databaseProvider) {
        this.getDelegate().cache(databaseProvider);
    }

    public void uncache(Properties properties) {
        this.getDelegate().uncache(properties);
    }

    private static class Holder {
        static final RaptorPrompter INSTANCE = IdeUtil.isHeadless() ? new HeadlessPrompter() : new DefaultPrompter();

        private Holder() {
        }
    }

    static abstract class RaptorPrompter
    implements PasswordPrompter {
        private Map<String, AuthKey> m_cache = new HashMap<String, AuthKey>();

        RaptorPrompter() {
        }

        public void cache(Properties properties) {
            String string = this.getKey(properties);
            String string2 = properties.getProperty("password");
            String string3 = properties.getProperty("user");
            if (string != null && string2 != null) {
                this.m_cache.put(string, new AuthKey(string3, string2));
            }
        }

        public void uncache(Properties properties) {
            this.m_cache.remove(this.getKey(properties));
        }

        public void disconnect(Properties properties) {
            this.m_cache.remove(this.getKey(properties));
        }

        public char[] getCachedPassword(Properties properties) {
            char[] cArray = new char[]{};
            String string = this.getKey(properties);
            AuthKey authKey = this.getAuthentication(string);
            if (authKey != null && authKey.m_pwd != null) {
                cArray = authKey.m_pwd.toCharArray();
            }
            return cArray;
        }

        protected AuthKey getAuthentication(String string) {
            return string != null ? this.m_cache.get(string) : null;
        }

        protected String getKey(Properties properties) {
            String string = properties.getProperty("UnsharedWorksheetOriginalConnectionName");
            string = string != null ? Connections.getConnectionName(string) : properties.getProperty("ConnName");
            String string2 = string;
            return string2;
        }

        protected static class AuthKey {
            final String m_pwd;
            final String m_user;

            AuthKey(String string, String string2) {
                this.m_pwd = string2;
                this.m_user = string;
            }
        }
    }

    static class DefaultPrompter
    extends RaptorPrompter {
        private DefaultPrompter() {
        }

        public Connection promptForPassword(Properties properties, String string, ConnectionCreator connectionCreator) throws SQLException {
            Connection connection = null;
            String string2 = properties.getProperty("password");
            if (string2 == null) {
                if (properties.getProperty("ConnName") == null && string != null) {
                    properties.setProperty("ConnName", string);
                }
                RaptorPrompter.AuthKey authKey = this.getAuthentication(this.getKey(properties));
                boolean bl = Boolean.parseBoolean(properties.getProperty("NoPasswordConnection", "true"));
                if (authKey != null) {
                    properties.setProperty("user", authKey.m_user);
                    properties.setProperty("password", authKey.m_pwd);
                } else if (bl) {
                    ConnectionInfoPanel.promptForConnection(properties);
                }
            }
            connection = connectionCreator.getConnection(properties);
            this.cache(properties);
            return connection;
        }

        public void disconnect(DatabaseProvider databaseProvider) {
            Properties properties = databaseProvider.getProperties();
            String string = databaseProvider.getName();
            if (properties.getProperty("ConnName") == null) {
                properties.setProperty("ConnName", string);
            }
            this.disconnect(properties);
        }

        public void cache(DatabaseProvider databaseProvider) {
            Properties properties = databaseProvider.getProperties();
            String string = databaseProvider.getName();
            if (properties.getProperty("ConnName") == null) {
                properties.setProperty("ConnName", string);
            }
            this.cache(properties);
        }
    }

    private static class HeadlessPrompter
    extends RaptorPrompter {
        private HeadlessPrompter() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Connection promptForPassword(Properties properties, String string, ConnectionCreator connectionCreator) throws SQLException {
            Connection connection = null;
            String string2 = properties.getProperty("UnsharedWorksheetOriginalConnectionName");
            if (string2 != null) {
                try {
                    return Connections.getInstance().getConnection(string2, true);
                }
                catch (DBException dBException) {
                    Throwable throwable = dBException.getCause();
                    if (!(throwable instanceof SQLException)) return connection;
                    throw (SQLException)throwable;
                }
            }
            if (properties.getProperty("password") == null) {
                Console console = System.console();
                if (console != null) {
                    char[] cArray = console.readPassword("Password for " + string + "?", new Object[0]);
                    properties.setProperty("password", new String(cArray));
                    connection = connectionCreator.getConnection(properties);
                    this.cache(properties);
                    return connection;
                } else {
                    System.out.println("Password was not saved with the connection information - please either save the password or run sdcli from the command prompt");
                }
                return connection;
            } else {
                connection = connectionCreator.getConnection(properties);
                this.cache(properties);
            }
            return connection;
        }
    }
}

