/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.dbdiff.Messages;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizArb;
import oracle.dbtools.raptor.ui.URLFileChooser;

public class FilePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField _fileName;
    private Component _parent;
    private JButton _browse;
    private String _defaultName = "";
    private String _encoding;

    public FilePanel(Component component) {
        this._parent = component;
        this.setLayout(new BorderLayout());
        this._fileName = new JTextField(this._defaultName);
        this.add((Component)this._fileName, "Center");
        this._browse = new JButton(StringUtils.stripMnemonic((String)Messages.getString("FilePanel.0")));
        this._browse.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("FilePanel.0")));
        this._browse.addActionListener(this);
        this.add((Component)this._browse, "East");
        int n = Double.valueOf(this.getPreferredSize().getWidth()).intValue();
        Dimension dimension = new Dimension(n + 150, Double.valueOf(this.getPreferredSize().getHeight()).intValue());
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
    }

    public void prompt() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setPathContext("EXPORTDIR");
        String string = this._fileName.getText();
        Object object = DBConfig.getInstance().getString("EXPORTDIR") + File.separator;
        if (object == null || ((String)object).equals("")) {
            object = System.getProperty("user.home");
        }
        if (string.equals("")) {
            try {
                File file = new File((String)object + "diff.sql");
                uRLFileChooser.setSelectedFile(file);
            }
            catch (Exception exception) {
                File file = new File((String)object + "diff.sql");
                uRLFileChooser.setSelectedFile(file);
            }
        } else {
            int n = string.lastIndexOf(File.separator);
            if (n > -1) {
                uRLFileChooser.setSelectedFile(new File(string));
            } else {
                uRLFileChooser.setSelectedFile(new File(DBConfig.getInstance().getString("EXPORTDIR") + File.separator + string));
            }
        }
        uRLFileChooser.showEncodings(true);
        if (uRLFileChooser.showSaveDialog(this._parent, DBDiffWizArb.getString("FILE_DIALOG")) == 0) {
            int n;
            String string2 = uRLFileChooser.getSelectedFile().toString();
            String string3 = string2.substring(n = string2.lastIndexOf(File.separator));
            if (string3.lastIndexOf(".") > -1) {
                this._fileName.setText(uRLFileChooser.getSelectedFile().toString());
            } else {
                this._fileName.setText(uRLFileChooser.getSelectedFile().toString() + ".sql");
            }
            this._encoding = uRLFileChooser.getEncoding();
        }
    }

    public void setFileName(String string) {
        this._fileName.setText(string);
    }

    public String getFileName() {
        return this._fileName.getText();
    }

    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.prompt();
    }
}

