/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.SquareIconButton;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeArb;
import oracle.dbtools.raptor.datatypes.ui.cell.BaseCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.CellEditorPanel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.icons.OracleIcons;

public abstract class BaseCustomCellEditor
extends BaseCellEditor {
    public static final String DISABLE_EDIT_BUTTON = "BaseCustomCellEditor.DISABLE_EDIT_BUTTON";
    protected BaseCellEditor cellEditor;
    protected JButton editButton;
    protected CellEditorPanel panel = (CellEditorPanel)this.getComponent();

    public BaseCustomCellEditor(BaseCellEditor baseCellEditor) {
        super(new CellEditorPanel());
        this.cellEditor = baseCellEditor;
        this.panel.setEditor(this);
    }

    public BaseCellEditor getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public void configure(DataType dataType) {
        boolean bl;
        super.configure(dataType);
        this.panel.setLayout(new BorderLayout());
        this.panel.add("Center", this.cellEditor.getEditorComponent());
        String string = this.getProperty(DISABLE_EDIT_BUTTON);
        boolean bl2 = bl = string != null && Boolean.parseBoolean(string);
        if (!bl) {
            this.editButton = this.getEditButton();
            this.panel.add("East", this.editButton);
        }
        Component component = this.cellEditor.getComponent();
        if (!bl && !component.isFocusable()) {
            component = this.editButton;
        }
        this.panel.setFocusDelegate(component);
        if (!bl) {
            this.editButton.setName("CustomCellEditor.EditButton");
        }
    }

    public Object getEditorValue() {
        return this.cellEditor.getCellEditorValue();
    }

    public void setEditorValue(Object object) {
        this.cellEditor.setValue(object);
    }

    protected JButton getEditButton() {
        SquareIconButton squareIconButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
        squareIconButton.setMargin(new Insets(2, 2, 2, 2));
        squareIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseCustomCellEditor.this.handleCustomEdit();
            }
        });
        squareIconButton.setVerifyInputWhenFocusTarget(false);
        return squareIconButton;
    }

    protected void handleCustomEdit() {
        JComponent jComponent = this.getCustomEditorComponent();
        if (jComponent == null) {
            return;
        }
        JComponent jComponent2 = this.getCustomEditorFocusComponent();
        String string = this.getPropertyName();
        String string2 = DataTypeArb.format((String)"CUSTOM_CELL_EDITOR_TITLE", (Object[])new Object[]{string});
        HelpSystem.getHelpSystem().registerTopic(jComponent, this.getCustomEditorHelpTopicId());
        this.setCustomEditorValue(this.getEditorValue());
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, (Component)jComponent2, (String)string2);
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(true);
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            this.setEditorValue(this.getCustomEditorValue());
            this.stopCellEditing();
        } else {
            this.cancelCellEditing();
        }
    }

    protected abstract JComponent getCustomEditorComponent();

    protected abstract JComponent getCustomEditorFocusComponent();

    protected abstract Object getCustomEditorValue();

    protected abstract void setCustomEditorValue(Object var1);

    String getCustomEditorHelpTopicId() {
        return "f1_extendeddataedit_html";
    }
}

