/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class DataUIUtils {
    public static String credentialQuery = "select CREDENTIAL_NAME from all_credentials";

    public static JComboBox<String> getSQLCombo(JLabel jLabel) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEnabled(true);
        jLabel.setEnabled(true);
        jLabel.setLabelFor(jComboBox);
        jComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Object object = popupMenuEvent.getSource();
                if (object instanceof JComboBox && ((JComboBox)object).getModel() instanceof SQLComboxModel) {
                    ((SQLComboxModel)((JComboBox)object).getModel()).load();
                }
            }
        });
        return jComboBox;
    }

    public static void setCredentialModel(JComboBox<String> jComboBox, String string) {
        DataUIUtils.initSQLComboBox(jComboBox, string, credentialQuery, false);
    }

    public static void setCredentialModel(JComboBox<String> jComboBox, String string, boolean bl, String string2) {
        DataUIUtils.initSQLComboBox(jComboBox, string, credentialQuery, bl, string2);
    }

    public static void setCredentialModel(JComboBox<String> jComboBox, Connection connection, boolean bl, String string) {
        if (connection != null && jComboBox != null) {
            SQLComboxModel sQLComboxModel = null;
            sQLComboxModel = new SQLComboxModel(connection, credentialQuery, null, string);
            sQLComboxModel.setDelayed(bl);
            jComboBox.setModel(sQLComboxModel);
        }
    }

    private static void initSQLComboBox(JComboBox<String> jComboBox, String string, String string2) {
        DataUIUtils.initSQLComboBox(jComboBox, string, string2, true);
    }

    private static void initSQLComboBox(JComboBox<String> jComboBox, String string, String string2, boolean bl) {
        if (string != null && jComboBox != null) {
            SQLComboxModel sQLComboxModel = DataUIUtils.getSQLComboModel(string, string2, bl);
            jComboBox.setModel(sQLComboxModel);
        }
    }

    private static void initSQLComboBox(JComboBox<String> jComboBox, String string, String string2, boolean bl, String string3) {
        if (string != null && jComboBox != null) {
            SQLComboxModel sQLComboxModel = DataUIUtils.getSQLComboModel(string, string2, bl, string3);
            jComboBox.setModel(sQLComboxModel);
        }
    }

    private static SQLComboxModel getSQLComboModel(String string, String string2, boolean bl) {
        SQLComboxModel sQLComboxModel = null;
        if (string != null) {
            sQLComboxModel = new SQLComboxModel(string, string2);
            sQLComboxModel.setDelayed(bl);
        }
        return sQLComboxModel;
    }

    private static SQLComboxModel getSQLComboModel(String string, String string2, boolean bl, String string3) {
        SQLComboxModel sQLComboxModel = null;
        if (string != null) {
            sQLComboxModel = new SQLComboxModel(string, string2);
            sQLComboxModel.setDelayed(bl);
            sQLComboxModel.setDefaultObject(string3);
        }
        return sQLComboxModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTable(ImportProperties importProperties, String string) {
        String string2 = "drop table :TABLE";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = (String)importProperties.get(ImportKeys.CONNECTION_NAME);
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string3);
            hashMap.put("TABLE", string);
            if (Connections.getInstance().lock(connection)) {
                PreparedStatement preparedStatement = DBUtil.getInstance((Connection)connection).prepareExecute(string2, hashMap);
                preparedStatement.execute();
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public static void setFileColumnsFromSource(ImportProperties importProperties) {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        DataPreviewGizmo dataPreviewGizmo = (DataPreviewGizmo)importProperties.get(ImportKeys.GIZMO);
        boolean bl = importProperties.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
        boolean bl2 = importProperties.getValueBoolean(ImportKeys.IS_CART);
        ArrayList arrayList = (ArrayList)loadFile.getFields();
        JTable jTable = dataPreviewGizmo.getTable();
        TableColumnModel tableColumnModel = jTable.getTableHeader().getColumnModel();
        ArrayList<Column> arrayList2 = new ArrayList<Column>();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Column column = new Column();
            Object object = tableColumnModel.getColumn(i).getHeaderValue();
            String string = object == null ? "" : object.toString();
            column.setSourceColumnName(string);
            if (bl) {
                column.setName("");
            } else {
                column.setName(column.getSourceColumnName());
            }
            column.setSourceColID(DataUIUtils.getSourceID(importProperties, column.getSourceColumnName()));
            column.setPrecision(dataPreviewGizmo.getDataReader().getWidth(i));
            column.setType("VARCHAR2");
            column.setScale(0);
            column.setNullable(true);
            arrayList2.add(i, column);
            ((LoadField)arrayList.get(i)).setColumn(column);
            if (bl2) {
                ((LoadField)arrayList.get(i)).setName(column.getName());
            }
            importProperties.put(ImportKeys.FILE_COLUMNS, (Object)arrayList2.toArray(new Column[arrayList2.size()]));
        }
    }

    public static int getSourceID(ImportProperties importProperties, String string) {
        int n = -1;
        DataPreviewGizmo dataPreviewGizmo = (DataPreviewGizmo)importProperties.get(ImportKeys.GIZMO);
        String[] stringArray = dataPreviewGizmo.getDataReader().getColumnNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static boolean isExisting(Object object) {
        if (object != null && object instanceof DBObject) {
            DBObject dBObject = (DBObject)((Object)object);
            return dBObject.getObjectType().equals("TABLE");
        }
        return false;
    }
}

