/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.importer.IImportTester;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.core.ImportXMLUtil;
import oracle.dbtools.importer.writers.ImportGenHelper;
import oracle.dbtools.importer.writers.ImportWriteStream;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.DataWizardCommitListener;
import oracle.dbtools.raptor.data.importer.ImportGenLauncherSD;
import oracle.dbtools.raptor.data.ui.DataPreviewPage;
import oracle.dbtools.raptor.data.ui.DataSummaryPanel;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public class DataSummaryPage
extends DefaultTraversablePanel {
    protected final String ENCODING = "UTF-8";
    private JPanel savePanel;
    private JButton _saveButton;
    private URLFileChooser _configChooser;
    private final FileNameExtensionFilter _configFilter = new FileNameExtensionFilter(DataImportArb.getString("CONFIG_FILE_TYPE"), "sdimp");
    private static final long serialVersionUID = -4806824652842858395L;
    private TraversableContext m_ctx;
    private DataSummaryPanel _summaryPanel = new DataSummaryPanel();
    private ImportProperties _iProps;
    private boolean _isCart = false;

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this._iProps = (ImportProperties)this.m_ctx.get("IMPORT_PROPERTIES");
        this._iProps.put(ImportKeys.FIELDSEPARATOR, (Object)DBConfig.getInstance((PropertyStorage)Preferences.getPreferences()).getString("IMPORT_DELIMITER"));
        this._isCart = this._iProps.getValueBoolean(ImportKeys.IS_CART);
        this._summaryPanel.onEntry(traversableContext);
        this.build();
        this.getSaveButton().setVisible(!this._isCart || this._iProps.get(ImportKeys.INITIAL_CONFIG_URL) == null);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            ImportGenLauncherSD importGenLauncherSD;
            if (this._iProps.getValueBoolean(ImportKeys.IS_CLEANUP_TEST_NEEDED).booleanValue()) {
                this._iProps.put(ImportKeys.IS_CLEANUP_TEST_NEEDED, (Object)false);
                importGenLauncherSD = (IImportTester)this._iProps.get(ImportKeys.IMPORT_TESTER);
                this._iProps.put(ImportKeys.IMPORT_TESTER, null);
                Connection connection = null;
                if (importGenLauncherSD != null) {
                    try {
                        connection = Connections.getInstance().getConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME));
                        if (Connections.getInstance().lock(connection)) {
                            importGenLauncherSD.cleanUpTest();
                        }
                        if (connection != null) {
                            Connections.getInstance().unlock(connection);
                        }
                    }
                    catch (Exception exception) {
                        try {
                            ExceptionHandler.handleException((Throwable)exception);
                            if (connection != null) {
                                Connections.getInstance().unlock(connection);
                            }
                        }
                        catch (Throwable throwable) {
                            if (connection != null) {
                                Connections.getInstance().unlock(connection);
                            }
                            throw throwable;
                        }
                    }
                }
            }
            this.initGenProperties();
            if (!this._isCart) {
                importGenLauncherSD = new ImportGenLauncherSD();
                importGenLauncherSD.start(this._iProps);
                importGenLauncherSD.process();
            }
        }
    }

    private void initGenProperties() {
        try {
            ImportWriteStream importWriteStream;
            GenericTable genericTable = (GenericTable)this._iProps.get(ImportKeys.TABLE);
            for (Column column : importWriteStream = (ImportWriteStream)this._iProps.get(ImportKeys.SELECTED_COLUMNS)) {
                Column column2 = genericTable.getTable().getColumnByName(column.getName());
                column2.setSourceColumnName(column.getSourceColumnName());
                column2.setSourceColID(column.getSourceColID());
                if (!this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE).booleanValue()) {
                    column2.setType(column.getType());
                    column2.setPrecision(column.getPrecision());
                    column2.setScale(column.getScale());
                    column2.setFormat(column.getFormat());
                    column2.setNullable(column.isNullable());
                    column2.setComment(column.getComment());
                }
                column = column2;
            }
            this._iProps.put(ImportKeys.TABLE, (Object)genericTable);
            ImportWriteStream importWriteStream2 = DataSummaryPage.createPrintStream(this._iProps);
            this._iProps.put(ImportKeys.URL_FOR_AUTO_OPEN, (Object)importWriteStream2.getURL());
            this._iProps.put(ImportKeys.IMPORT_WRITE_STREAM, (Object)importWriteStream2);
            this._iProps.put(ImportKeys.IS_BATCH, (Object)false);
            this._iProps.put(ImportKeys.ERROR_LIMIT, (Object)0);
        }
        catch (Exception exception) {
            Logger.getLogger(DataWizardCommitListener.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static ImportWriteStream createPrintStream(ImportProperties importProperties) throws IOException, UnsupportedEncodingException {
        DBConfig dBConfig;
        String string = Ide.getEnvironOptions().getEncoding();
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        int n = 0;
        String string2 = null;
        String string3 = null;
        if (importProperties.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
            string2 = (String)importProperties.get(ImportKeys.OSS_PATH);
            n = string2.lastIndexOf("/");
            string3 = ".log";
        } else {
            string2 = loadFile.getName();
            n = string2.lastIndexOf(File.separator);
            string3 = ".sql";
        }
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        string2 = string2.replace(".", "-");
        String string4 = null;
        int n2 = importProperties.getValueInteger(ImportKeys.LOAD_METHOD);
        if (n2 == 0 || n2 == 1) {
            dBConfig = DBConfig.getInstance();
            string4 = dBConfig.getString("IMPORT_INS_GEN_DIR");
            boolean bl = dBConfig.getBoolean("IMPORT_INS_GEN_TEMP");
            if (string4 == null || string4.length() == 0) {
                string4 = dBConfig.getString("IMPORTDIR");
                if (bl) {
                    try {
                        string4 = ImportWriteStream.getTempDir();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        dBConfig = new ImportWriteStream(ImportResources.getString((String)"IMPORT_TOOL") + "-" + string2, string, string4, string3);
        return dBConfig;
    }

    public void build() {
        JLabel jLabel = new JLabel(DataImportArb.getString("SAVE_CONFIG"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add((Component)this.getSaveButton(), "South");
        this.removeAll();
        this.add(jPanel, "North");
        this.add((Component)((Object)this._summaryPanel), "Center");
    }

    private Component getXTableComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("XTABLE_TITLE")));
        ResultSetTable resultSetTable = new ResultSetTable();
        jPanel.add((Component)((Object)resultSetTable), "Center");
        int n = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        String string = n == 3 ? ImportGenHelper.addUser((ImportProperties)this._iProps, (String)((String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME))) : ImportGenHelper.addUser((ImportProperties)this._iProps, (String)((String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME)));
        resultSetTable.setQuery((String)this._iProps.get(ImportKeys.CONNECTION_NAME), "select * from " + string, null, null);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)resultSetTable));
        jScrollPane.setRowHeaderView(resultSetTable.getRowHeader());
        jScrollPane.setColumnHeaderView(resultSetTable.getTableHeader());
        try {
            resultSetTable.open(false);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
        return jScrollPane;
    }

    private Component getDDLComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextComponent jTextComponent = this.createTextPane(false);
        DBObject dBObject = (DBObject)((Object)this._iProps.get(ImportKeys.DBOBJECT));
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", (String)this._iProps.get(ImportKeys.CONNECTION_NAME), null, dBObject.getSchemaName(), "TABLE");
        URL uRL2 = DBURLFormatHelper.getURL(uRL, (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME));
        ExtractListModel extractListModel = new ExtractListModel();
        DDLTypes dDLTypes = new DDLTypes();
        dDLTypes.setTableDeps(false);
        dDLTypes.setShowTableDeps(false);
        extractListModel.setDDLTypes(dDLTypes);
        extractListModel.setDDLFormat(new DDLFormat());
        ExtractObject extractObject = new ExtractObject(uRL2, extractListModel);
        jTextComponent.setText(extractObject.getDDL(1));
        extractObject.setListModel(extractListModel);
        jTextComponent.setCaretPosition(0);
        jPanel.add((Component)jTextComponent, "Center");
        return jPanel;
    }

    private JTextComponent createTextPane(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        DataSummaryPage dataSummaryPage = new DataSummaryPage();
        jDialog.add((Component)((Object)dataSummaryPage));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(Boolean.TRUE);
    }

    protected JButton getSaveButton() {
        if (this._saveButton == null) {
            this._saveButton = new JButton(DataImportArb.getString("CONFIG_SAVE_STATE"));
            this._saveButton.setIcon(RaptorImagesArb.getIcon("GEAR"));
            this._saveButton.setToolTipText(DataImportArb.getString("SAVE_CONFIG_TIP"));
            this._saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSummaryPage.this.saveConfig();
                }
            });
        }
        return this._saveButton;
    }

    public void saveConfig() {
        File file;
        File file2;
        String string = DataImportArb.getString("SAVE_CONFIG_DIALOG_TITLE");
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_saveimportconfig_html");
        this._configChooser = new URLFileChooser();
        this._configChooser.showEncodings(true);
        this._configChooser.setSelectedURL(null);
        this._configChooser.setPathContext(DataPreviewPage.CONFIG_PATH_CONTEXT);
        URL uRL = (URL)this._iProps.get(ImportKeys.CONFIG_URL);
        if (uRL != null) {
            this._configChooser.setSelectedURL(uRL);
        } else if (!this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
            LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
            file2 = new File(loadFile.getName()).getParentFile();
            file = new File(file2.getPath() + File.separator + loadFile.getShortName() + ".sdimp");
            try {
                this._configChooser.setSelectedFile(file);
            }
            catch (Exception exception) {
                Logger.getLogger(DataSummaryPage.class.getClass().getName()).log(Level.WARNING, exception.getMessage());
            }
        }
        this._configChooser.clearChooseableURLFilters();
        this._configChooser.setFileFilter(this._configFilter);
        int n = this._configChooser.showSaveDialog((Component)((Object)this), string);
        if (n == 0) {
            file2 = this._configChooser.getSelectedFile();
            file = new TargetFormat(1, 0);
            file.setSaveAsType(0);
            Object object = null;
            if (file2 != null && !((String)(object = file2.getPath())).contains(".")) {
                object = (String)object + ".sdimp";
                file2 = new File((String)object);
            }
            file.setSaveAs((String)object);
            int n2 = file.validateSaveAs((Component)((Object)this));
            if (n2 == 1) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)file.getValidationMessage(), (String)ImportResources.getString((String)"OPEN_CONFIG_ERROR_TITLE"), (String)"IMPORT_FILE_ERROR");
            } else if (n2 == 0) {
                ImportXMLUtil importXMLUtil = new ImportXMLUtil();
                importXMLUtil.saveConfigOptions(file2, this._iProps, this._configChooser.getEncoding());
                if (this._isCart) {
                    URL uRL2 = null;
                    try {
                        uRL2 = file2.toURI().toURL();
                        if (uRL2 == null) {
                            this._iProps.put(ImportKeys.IS_CONFIGFILE, (Object)false);
                        } else {
                            this._iProps.put(ImportKeys.IS_CONFIGFILE, (Object)true);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(DataSummaryPage.class.getClass().getName()).log(Level.WARNING, exception.getMessage());
                        this._iProps.put(ImportKeys.IS_CONFIGFILE, (Object)false);
                    }
                    this._iProps.put(ImportKeys.INITIAL_CONFIG_URL, (Object)uRL2);
                }
            }
        }
    }
}

