/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.ui.SourceColumnDefRenderer;
import oracle.dbtools.raptor.data.validators.LoadFieldValidator;
import oracle.ide.panels.TraversableContext;

public class ColumnListPanel
extends JPanel {
    private static final long serialVersionUID = -10394687240089213L;
    private DefaultListModel mdlColumns = new DefaultListModel();
    private JList lstColumns = new JList(this.mdlColumns);
    private SourceColumnDefRenderer _colRenderer = new SourceColumnDefRenderer();
    private JScrollPane scrColumns = new JScrollPane();
    private JScrollPane _statusScroll = new JScrollPane();
    private JTextArea _statusText = new JTextArea(4, 1);
    private ImportProperties _iProps;
    private LoadFieldValidator[] _validators;
    private LoadFile _loadFile;

    public ColumnListPanel() {
        super(new BorderLayout(0, 16));
        this.scrColumns.setVerticalScrollBarPolicy(22);
        this.lstColumns.setCellRenderer(this._colRenderer);
        this.scrColumns.getViewport().add((Component)this.lstColumns, null);
        this.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("DATA_MAPPING_SRC_COLUMNS")));
        this.add((Component)this.scrColumns, "Center");
        this._statusScroll.setBorder(BorderFactory.createTitledBorder(ImportResources.getString((String)"PREREQ_CHECK_HEADING_STATUS")));
        this._statusScroll.setVerticalScrollBarPolicy(20);
        this._statusScroll.setHorizontalScrollBarPolicy(31);
        this._statusText.setLineWrap(true);
        this._statusText.setWrapStyleWord(true);
        this._statusScroll.getViewport().add((Component)this._statusText, null);
        this.add((Component)this._statusScroll, "South");
    }

    protected void onEntry(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._validators = new LoadFieldValidator[this._loadFile.getFieldCount()];
        for (int i = 0; i < this._loadFile.getFieldCount(); ++i) {
            this._validators[i] = new LoadFieldValidator(this._iProps, this._loadFile.getField(i));
        }
        this._iProps.put(ImportKeys.VALIDATORS, (Object)this._validators);
        this._colRenderer.setProperties(this._iProps);
    }

    public void resetValidators() {
        for (int i = 0; i < this._validators.length; ++i) {
            if (!this._validators[i].getLoadField().isLoad()) continue;
            this._validators[i].runAllTests();
        }
    }

    public void resetValidators(LoadFieldValidator.Test test) {
        for (int i = 0; i < this._validators.length; ++i) {
            this._validators[i].run(test);
        }
    }

    public Column getCurrentSelection() {
        return (Column)this.lstColumns.getSelectedValue();
    }

    void setCurrentSelection(int n) {
        int n2 = this.lstColumns.getModel().getSize();
        if (n >= 0) {
            this.lstColumns.setSelectedIndex(n % (n2 + 1));
            LoadFieldValidator loadFieldValidator = this._validators[this.getCurrentSelection().getSourceColID()];
            this._statusText.setText(loadFieldValidator.getStatus());
        }
    }

    public void resetCurrentSelection() {
        this.lstColumns.setSelectedIndex(this.lstColumns.getSelectedIndex());
    }

    public void resetCurrentSelectionValidator() {
        LoadFieldValidator loadFieldValidator = this._validators[this.getCurrentSelection().getSourceColID()];
        loadFieldValidator.runAllTests();
        this._statusText.setText(loadFieldValidator.getStatus());
    }

    public void resetCurrentSelectionValidator(LoadFieldValidator.Test test) {
        LoadFieldValidator loadFieldValidator = this._validators[this.getCurrentSelection().getSourceColID()];
        loadFieldValidator.run(test);
        this._statusText.setText(loadFieldValidator.getStatus());
    }

    public void resetCurrentSelectionValidator(LoadFieldValidator.Test[] testArray) {
        LoadFieldValidator loadFieldValidator = this._validators[this.getCurrentSelection().getSourceColID()];
        loadFieldValidator.getLoadField().setColumn(this.getCurrentSelection());
        for (LoadFieldValidator.Test test : testArray) {
            loadFieldValidator.run(test);
        }
        this._statusText.setText(loadFieldValidator.getStatus());
    }

    public void addColumn(Column column) {
        this.mdlColumns.add(0, column);
    }

    public void addColumn(int n, Column column) {
        this.mdlColumns.add(n, column);
    }

    public void addColumns(Column[] columnArray) {
        for (int i = 0; i < columnArray.length; ++i) {
            this.addColumn(i, columnArray[i]);
        }
    }

    public Column[] getColumns() {
        Column[] columnArray = new Column[this.mdlColumns.size()];
        this.mdlColumns.copyInto(new Column[this.mdlColumns.size()]);
        return columnArray;
    }

    public JList getLstColumns() {
        return this.lstColumns;
    }
}

