/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.importer;

import java.net.URL;
import java.sql.PreparedStatement;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.importer.ImportGenLauncherSD;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.log.LogManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.IdeUtil;

public class ImportGenLauncherSDCli
extends ImportGenLauncherSD {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process() {
        if (this._iGenModel.isExitCodeSuccess()) {
            try {
                if (!this._iGenModel.lockConnectionForImport()) {
                    this._iGenModel.isCancel(true);
                }
                if (this._iGenModel.isCancel()) return;
                this._iGenModel.isCancel(!this._iGenModel.getService().process());
                if (this._iGenModel.getExitCode() == ExitCode.EXIT_SUCCESS && !this._iGenModel.isCancel()) {
                    this.commitTask();
                    return;
                }
                this.rollbackTask();
                return;
            }
            catch (Exception exception) {
                ExitCode exitCode = ExitCode.EXIT_SEVERE;
                exitCode.setMessage(exception.getLocalizedMessage());
                this._iGenModel.setExitCode(exitCode);
                return;
            }
            finally {
                this._iGenModel.unlockConnectionForImport();
                this._iGenModel.getService().finish();
            }
        } else {
            this._iGenModel.setExitCode(ExitCode.EXIT_SEVERE);
        }
    }

    public final void rollbackTask() {
        try {
            if (!this._iGenModel.getConn().isClosed() && this._iGenModel.isConnLocked()) {
                this._iGenModel.getConn().rollback();
                if (this._iGenModel.isTableCreated() && !this._iGenModel.isIgnoreAllErrors()) {
                    String string = this._iGenModel.getDropTableStatementForPrepare();
                    PreparedStatement preparedStatement = this._iGenModel.getConn().prepareStatement(string);
                    preparedStatement.execute();
                    this._iGenModel.getConn().commit();
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    public void commitTask() {
        try {
            if (this._iGenModel.isConnLocked()) {
                this._iGenModel.getConn().commit();
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    private void outBad(String string) {
        try {
            this._iGenModel.getStream().printlnBad(string);
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    public void closeFiles() {
        if (this._iGenModel.getStream() != null) {
            this._iGenModel.getStream().finished();
            this._iGenModel.getStream().deleteEmptyFile();
            try {
                this._iGenModel.getStream().finishedBad();
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
        }
    }

    final class SDTaskListener
    extends RaptorTaskAdapter {
        SDTaskListener() {
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.finish();
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            this.finish();
        }

        private void finish() {
            URL uRL = (URL)ImportGenLauncherSDCli.this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN);
            if (uRL != null) {
                if (!ImportGenLauncherSDCli.this._iGenModel.isBatch() && uRL.getPath().endsWith(".sql")) {
                    if (ImportGenLauncherSDCli.this._iProps.getValueBoolean(ImportKeys.SEND_TO_WORKSHEET).booleanValue() || ImportGenLauncherSDCli.this._iProps.getValueInteger(ImportKeys.LOAD_METHOD) != 0 && ImportGenLauncherSDCli.this._iGenModel.getStream().isFileUsed()) {
                        Logger.info(((Object)((Object)this)).getClass(), (String)Messages.getString("ImportGenerator.77"));
                        try {
                            this.openSqlNodeForURL((URL)ImportGenLauncherSDCli.this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN));
                        }
                        catch (Exception exception) {
                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                        }
                    }
                } else {
                    try {
                        ImportGenLauncherSDCli.this._iGenModel.getStream().closeLog();
                        this.openTextNodeForURL(uRL);
                    }
                    catch (Exception exception) {
                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                    }
                }
            }
            if (!ImportGenLauncherSDCli.this._iGenModel.isBatch() && ImportGenLauncherSDCli.this._iGenModel.getStream().isBadFileUsed()) {
                try {
                    this.openSqlNodeForURL(ImportGenLauncherSDCli.this._iGenModel.getStream().geturlBad());
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                }
            }
            ImportGenLauncherSDCli.this._iGenModel.getStream().finished();
            if (ImportGenLauncherSDCli.this._iGenModel.isTableCreated()) {
                this.getPostProcessCallback().run();
            }
            if (!ImportGenLauncherSDCli.this._iGenModel.isExitCodeSuccess()) {
                LogManager.getLogManager().getLogWindow().selectPage(LogManager.getLogManager().getMsgPage());
                LogManager.getLogManager().getLogWindow().activate();
            }
        }

        private void openTextNodeForURL(URL uRL) throws Exception {
            TextNode textNode = null;
            textNode = (TextNode)NodeFactory.findOrCreate(TextNode.class, (URL)uRL);
            final TextNode textNode2 = textNode;
            if (textNode2 != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                EditorUtil.openDefaultEditorInFrame((Node)textNode2);
                            }
                        });
                    }
                });
            }
        }

        private void openSqlNodeForURL(URL uRL) throws Exception {
            SqlNode sqlNode = null;
            sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
            final SqlNode sqlNode2 = sqlNode;
            if (sqlNode2 != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                            }
                        });
                    }
                });
            }
        }

        protected ObjectActionController.ObjectActionPostProcess getPostProcessCallback() {
            ObjectAction objectAction = (ObjectAction)((Object)ImportGenLauncherSDCli.this._iProps.get(ImportKeys.OBJECTACTION));
            DBObject dBObject = (DBObject)((Object)ImportGenLauncherSDCli.this._iProps.get(ImportKeys.DBOBJECT));
            ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback(objectAction, dBObject);
            return objectActionPostProcess;
        }
    }
}

