/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import oracle.dbtools.raptor.controls.display.chart.AbstractLayoutPanel;
import oracle.dbtools.raptor.controls.display.chart.AbstractPropertyPanel;
import oracle.dbtools.raptor.controls.display.chart.Alignment;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManager;
import oracle.dbtools.raptor.controls.display.chart.FontPanel;
import oracle.dbtools.raptor.controls.display.chart.LegendLocation;
import oracle.dbtools.raptor.controls.display.chart.PropertyEvent;
import oracle.dbtools.raptor.controls.display.chart.PropertyListener;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.TransparentColorPanel;

class LegendPropertyPanel
extends AbstractPropertyPanel {
    LegendPropertyPanel(ChartPropertyManager chartPropertyManager) {
        super(chartPropertyManager, 4);
        this.addCheckBox(PropertyType.LEGEND, 0, 0, 0, AbstractLayoutPanel.Align.LEFT, null);
        this.addComboBox(PropertyType.LEGEND_LOCATION, 0, 1, 3, AbstractLayoutPanel.Align.LEFT, LegendLocation.values());
        this.addLabel(PropertyType.LEGEND_BORDER_COLOR, 1, 0, 0, ChartArb.getString("COLORS_LABEL"));
        this.addButton(PropertyType.LEGEND_BORDER_COLOR, 1, 1, 1, AbstractLayoutPanel.Align.LEFT, ChartArb.getString("BORDER_BUTTON_LABEL"), new TransparentColorPanel(true));
        this.addButton(PropertyType.LEGEND_BACKGROUND_COLOR, 1, 2, 2, AbstractLayoutPanel.Align.RIGHT, ChartArb.getString("BACKGROUND_BUTTON_LABEL"), new TransparentColorPanel(true));
        this.addLabel(PropertyType.LEGEND_ALIGNMENT, 2, 0, 0, ChartArb.getString("ALIGNMENT_LABEL"));
        this.addComboBox(PropertyType.LEGEND_ALIGNMENT, 2, 1, 1, AbstractLayoutPanel.Align.LEFT, Alignment.values());
        this.addButton(PropertyType.LEGEND_FONT, 2, 2, 2, AbstractLayoutPanel.Align.RIGHT, ChartArb.getString("FONT_BUTTON_LABEL"), new FontPanel());
        this.updateEnablement();
        chartPropertyManager.addPropertyListener(new PropertyListener(){

            @Override
            public void onChange(PropertyEvent propertyEvent) {
                if (propertyEvent.changed(PropertyType.LEGEND)) {
                    LegendPropertyPanel.this.updateEnablement();
                }
            }
        });
    }

    private void updateEnablement() {
        Boolean bl = this.propertyManager.get(PropertyType.LEGEND, Boolean.class);
        if (bl != null) {
            this.enableProperty(PropertyType.LEGEND_LOCATION, bl);
            this.enableProperty(PropertyType.LEGEND_BORDER_COLOR, bl);
            this.enableProperty(PropertyType.LEGEND_BACKGROUND_COLOR, bl);
            this.enableProperty(PropertyType.LEGEND_ALIGNMENT, bl);
            this.enableProperty(PropertyType.LEGEND_FONT, bl);
        }
    }
}

