/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import oracle.dbtools.raptor.controls.display.chart.AbstractLayoutPanel;
import oracle.dbtools.raptor.controls.display.chart.AbstractPropertyPanel;
import oracle.dbtools.raptor.controls.display.chart.BarLabelPosition;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManager;
import oracle.dbtools.raptor.controls.display.chart.FontPanel;
import oracle.dbtools.raptor.controls.display.chart.NumberFormatsPanel;
import oracle.dbtools.raptor.controls.display.chart.PropertyEvent;
import oracle.dbtools.raptor.controls.display.chart.PropertyListener;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.SliceLabelPosition;
import oracle.dbtools.raptor.controls.display.chart.SliceLabelType;

class DataLabelsPropertyPanel
extends AbstractPropertyPanel {
    DataLabelsPropertyPanel(ChartPropertyManager chartPropertyManager) {
        super(chartPropertyManager, 4);
        this.addCheckBox(PropertyType.PLOT_DATALABELS, 0, 0, 0, AbstractLayoutPanel.Align.LEFT, null);
        this.addButton(PropertyType.PLOT_DATALABELS_FONT, 0, 1, 1, AbstractLayoutPanel.Align.LEFT, ChartArb.getString("FONT_BUTTON_LABEL"), new FontPanel());
        this.addButton(PropertyType.PLOT_DATALABELS_NUMBER_FORMATS, 0, 2, 2, AbstractLayoutPanel.Align.LEFT, ChartArb.getString("NUMBER_FORMATS_BUTTON_LABEL"), new NumberFormatsPanel());
        this.addLabel(PropertyType.PLOT_DATALABELS_BAR_POSITION, 1, 0, 0, ChartArb.getString("LABEL_POSITION_LABEL"));
        this.addComboBox(PropertyType.PLOT_DATALABELS_BAR_POSITION, 1, 1, 3, AbstractLayoutPanel.Align.LEFT, BarLabelPosition.values());
        this.addLabel(PropertyType.PLOT_DATALABELS_SLICE_POSITION, 1, 0, 0, ChartArb.getString("LABEL_POSITION_LABEL"));
        this.addComboBox(PropertyType.PLOT_DATALABELS_SLICE_POSITION, 1, 1, 3, AbstractLayoutPanel.Align.LEFT, SliceLabelPosition.values());
        this.addLabel(PropertyType.PLOT_DATALABELS_SLICE_TYPE, 2, 0, 0, ChartArb.getString("SLICE_TYPE_LABEL"));
        this.addComboBox(PropertyType.PLOT_DATALABELS_SLICE_TYPE, 2, 1, 3, AbstractLayoutPanel.Align.LEFT, SliceLabelType.values());
        this.updateEnablement();
        chartPropertyManager.addPropertyListener(new PropertyListener(){

            @Override
            public void onChange(PropertyEvent propertyEvent) {
                if (propertyEvent.changed(PropertyType.PLOT_DATALABELS)) {
                    DataLabelsPropertyPanel.this.updateEnablement();
                }
            }
        });
    }

    private void updateEnablement() {
        Boolean bl = this.propertyManager.get(PropertyType.PLOT_DATALABELS, Boolean.class);
        if (bl != null) {
            this.enableProperty(PropertyType.PLOT_DATALABELS_FONT, bl);
            this.enableProperty(PropertyType.PLOT_DATALABELS_NUMBER_FORMATS, bl);
            this.enableProperty(PropertyType.PLOT_DATALABELS_BAR_POSITION, bl);
            this.enableProperty(PropertyType.PLOT_DATALABELS_SLICE_POSITION, bl);
            this.enableProperty(PropertyType.PLOT_DATALABELS_SLICE_TYPE, bl);
        }
    }
}

