/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

abstract class AbstractLayoutPanel
extends JPanel {
    private int panelWidth;
    private Set<Component> previouslyEnabled;

    AbstractLayoutPanel(int n) {
        super(new GridBagLayout());
        this.panelWidth = n;
        this.add((Component)new JLabel(), new GridBagConstraints(0, 100, n, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    void addDivider(int n) {
        this.addComponent(new JLabel(), n, 0, 0, SizeToFit.NEITHER, Align.LEFT);
    }

    JButton addButton(int n, int n2, int n3, Align align, String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        this.addComponent(jButton, n, n2, n3, SizeToFit.NEITHER, align);
        return jButton;
    }

    JCheckBox addCheckBox(int n, int n2, int n3, Align align, String string, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.addActionListener(actionListener);
        this.addComponent(jCheckBox, n, n2, n3, SizeToFit.NEITHER, align);
        return jCheckBox;
    }

    void addComponent(JComponent jComponent, int n, int n2, int n3, SizeToFit sizeToFit, Align align) {
        if (n2 > n3 || n3 > this.panelWidth - 1) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        int n4 = 0;
        switch (sizeToFit) {
            case BOTH: {
                n4 = 1;
                d = 1.0;
                break;
            }
            case X: {
                n4 = 2;
                d = 1.0;
                break;
            }
            case Y: {
                n4 = 3;
            }
        }
        Insets insets = new Insets(5, 5, 5, 5);
        int n5 = n3 - n2 + 1;
        int n6 = align == Align.RIGHT ? 13 : 17;
        this.add((Component)jComponent, new GridBagConstraints(n2, n, n5, 1, d, 0.0, n6, n4, insets, 0, 0));
    }

    void enablePanel(boolean bl) {
        if (bl && this.previouslyEnabled != null) {
            this.enableChildren(this, true, this.previouslyEnabled);
            this.previouslyEnabled = null;
        } else if (!bl && this.previouslyEnabled == null) {
            this.previouslyEnabled = new HashSet<Component>();
            this.enableChildren(this, false, this.previouslyEnabled);
        }
    }

    private void enableChildren(JPanel jPanel, boolean bl, Set<Component> set) {
        int n = jPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jPanel.getComponent(i);
            if (component instanceof JPanel) {
                JPanel jPanel2 = (JPanel)component;
                this.enableChildren(jPanel2, bl, set);
            }
            if (bl) {
                if (!set.contains(component)) continue;
                component.setEnabled(true);
                continue;
            }
            if (!component.isEnabled()) continue;
            set.add(component);
            component.setEnabled(false);
        }
    }

    static enum SizeToFit {
        NEITHER,
        X,
        Y,
        BOTH;

    }

    static enum Align {
        LEFT,
        RIGHT;

    }
}

